export const Spinner = '<i class="bx bx-loader bx-spin" ></i>'
const url = new URL(window.location.href)

export const backendURL = 'backend/public'
export const uuid = () => {
  return 'xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
    var r = (Math.random() * 16) | 0,
      v = c == 'x' ? r : (r & 0x3) | 0x8
    return v.toString(16)
  })
}
const today = new Date()
const YY = today.getFullYear()
const mm = today.getMonth() + 1
const dd = today.getDate()
const MM = mm > 9 ? mm : '0' + mm
const DD = dd > 9 ? dd : '0' + dd
const Today = YY + '-' + MM + '/' + DD
const TodayFormatted = DD + '/' + MM + '/' + YY

export const formatter = new Intl.NumberFormat('en-US', {
  minimumFractionDigits: 2,
  maximumFractionDigits: 2
})
export const isEmpty = (obj) => {
  if (typeof obj === 'undefined') return true
  return Object.keys(obj).length === 0
}
export function formatNumbers(digits = 2) {
  return new Intl.NumberFormat('en-US', {
    minimumFractionDigits: digits,
    maximumFractionDigits: digits
  })
}
export const nl2br = (str, is_xhtml) => {
  if (typeof str === 'undefined' || str === null) {
    return ''
  }
  var breakTag = is_xhtml || typeof is_xhtml === 'undefined' ? '<br />' : '<br>'
  return (str + '').replace(
    /([^>\r\n]?)(\r\n|\n\r|\r|\n)/g,
    '$1' + breakTag + '$2'
  )
}
export const FlagRequiredinput = (value) => {
  return value
    ? '<i class="bx bxs-check-circle w3-text-green size14 bold" ></i>'
    : '<span class="w3-text-red size18 bold">*</span>'
}
export const FlagRequiredCurrencyinput = (value) => {
  return parseFloat(value) !== 0
    ? '<i class="bx bxs-check-circle w3-text-green size14 bold"></i>'
    : '<span class="w3-text-red size18 bold">*</span>'
}
export const FlagRequiredArrayInput = (value) => {
  return value?.length
    ? '<i class="bx bxs-check-circle w3-text-green size14 bold"></i>'
    : '<span class="w3-text-red size18 bold">*</span>'
}
export function formatCurrency(amount, symbol) {
  if (!symbol) {
    if (typeof amount === 'string' && amount.includes(',')) return amount
    return formatter.format(amount)
  }
  if (typeof amount === 'string' && amount.includes(',')) {
    return parseFloat(amount.replace(/,/g, '')) < 0
      ? '(' + symbol + amount + ')'
      : symbol + amount
  }
  return parseFloat(amount) < 0
    ? '(' + symbol + formatter.format(Math.abs(amount)) + ')'
    : symbol + formatter.format(amount)
}
export const FormatOn = {
  Focus: (e, RefObj) => {
    const inputName = e.target.name.replace(/\[/g, '').replace(/\]/g, '')
    RefObj[inputName] = e.target.value.replace(/,/g, '')
  },
  Blur: (e, RefObj) => {
    const inputName = e.target.name.replace(/\[/g, '').replace(/\]/g, '')
    RefObj[inputName] = formatter.format(e.target.value)
  }
}
export const FormatInputOn = {
  Focus: (e) => {
    e.target.value = e.target.value.replace(/,/g, '')
  },
  Blur: (e) => {
    if (e.target.value.includes(',')) return
    e.target.value = formatter.format(e.target.value)
  }
}
export function formattedDate(inputDate) {
  // input => yyyy-mm-dd
  // output => dd/mm/yyyy
  if (inputDate?.includes('/')) return inputDate
  const fomattedDate = inputDate?.substring(0, 10)?.split('-')
  if (!fomattedDate || fomattedDate[0] < 1980) return '-'
  return fomattedDate[2] + '/' + fomattedDate[1] + '/' + fomattedDate[0]
}
export function dbDateFormat(inputDate) {
  // input => dd/mm/yyyy
  // input => yyyy-mm-dd
  if (inputDate.includes('-')) return inputDate
  const fomattedDate = inputDate?.split('/')
  return fomattedDate[2] + '-' + fomattedDate[1] + '-' + fomattedDate[0]
}
export function hideEmail(email) {
  return email.replace(/(.{2})(.*)(?=@)/, function (gp1, gp2, gp3) {
    for (let i = 0; i < gp3.length; i++) {
      gp2 += '*'
    }
    return gp2
  })
}
export function queryParameter() {
  let uri = window.location.href.split('?')
  if (uri.length == 2) {
    let vars = uri[1].split('&')
    let parameters = {}
    let tmp = ''
    vars.forEach(function (v) {
      tmp = v.split('=')
      if (tmp.length == 2) parameters[tmp[0]] = tmp[1]
    })
    return parameters
  }
  return null
}
export function equalHeightColumns() {
  let isMobile = window.matchMedia('only screen and (max-width: 760px)').matches
  if (!isMobile) {
    $('.equalHeightColumns').each(function () {
      var highestBox = 0
      $('.column', this).each(function () {
        if ($(this).height() > highestBox) {
          highestBox = $(this).height()
        }
      })
      $('.column', this).height(highestBox)
    })
  }
}
export const Util = {
  openModal: (id) => {
    document.getElementById(id).style.display = 'block'
  },
  closeModal: (id) => {
    document.getElementById(id).style.display = 'none'
  },
  keyCount: (obj) => {
    if (typeof obj === 'undefined' || !obj) return 0
    var count = 0
    for (var prop in obj) {
      if (obj.hasOwnProperty(prop)) ++count
    }
    return count
  },
  removeArrayItem: (arr, item) => {
    console.log('item', item)
    const index = arr.indexOf(item)
    if (index > -1) {
      arr.splice(index, 1)
    }
  },
  BuildDataTable: (el, _config) => {
    const defaults = {
      retrieve: true,
      responsive: true,
      dom: '<"row mb-0"<"col-sm-3 w3-mobile"l><"col-sm-3 w3-mobile"B><"col-sm-6 w3-mobile"f><"col-sm w3-mobile"r>><"row"<"col"t>><"row"<"col"i><"col"p>>',
      buttons: [
        {
          extend: 'excel',
          className: 'w3-button w3-red mr-1 py-1'
        },
        // {
        //   extend: 'pdf',
        //   className: 'w3-button w3-red mr-1 py-1'
        // },
        {
          extend: 'print',
          className: 'w3-button w3-red mr-1 py-1'
        }
      ],
      pageLength: 25,
      lengthMenu: [
        [5, 10, 15, 25, 50, 100, 200, -1],
        [5, 10, 15, 25, 50, 100, 200, 'All']
      ]
    }
    const opt =
      typeof _config !== 'undefined'
        ? {
            ...defaults,
            ..._config
          }
        : defaults
    return $(el).DataTable(opt)
  },
  BuildDataTableWithPadding: (el, _config) => {
    const defaults = {
      retrieve: true,
      responsive: true,
      dom: '<"row mb-0"<"col-sm-3 w3-mobile"<"px-3"l>><"col-sm-3 w3-mobile"<"px-3 nowrap"B>><"col-sm-6 w3-mobile"<"px-3"f>><"col-sm w3-mobile"<"px-3"r>>><"row"<"col"t>><"row"<"col"<"px-3"i>><"col"<"px-3"p>>>',
      buttons: [
        {
          extend: 'excel',
          className: 'w3-button w3-red mr-1 py-1'
        },
        // {
        //   extend: 'pdf',
        //   className: 'w3-button w3-red mr-1 py-1'
        // },
        {
          extend: 'print',
          className: 'w3-button w3-red mr-1 py-1'
        }
      ],
      pageLength: 25,
      lengthMenu: [
        [5, 10, 15, 25, 50, 100, 200, -1],
        [5, 10, 15, 25, 50, 100, 200, 'All']
      ]
    }
    const opt =
      typeof _config !== 'undefined'
        ? {
            ...defaults,
            ..._config
          }
        : defaults
    return $(el).DataTable(opt)
  },
  scrollTo: (elem, offset) => {
    offset = typeof offset !== 'undefined' ? parseInt(offset) : 0
    scrollTop: $(elem).offset().top - offset
  },
  scrollToTop: () => {
    window.scroll({ top: 0, behavior: 'smooth' })
  },
  Today: Today,
  TodayFormatted: TodayFormatted,
  handleError: (error, msg) => {
    if (error.status === 'expired') {
      Util.RedirectPage(error.result)
      return false
    } else {
      const Message = msg ? msg : error.result
      console.log(Message)
      return Message
    }
  },
  RedirectPage: (url) => {
    if (typeof url !== 'undefined' && url !== '') {
      window.location = url
    }
  },
  equalHeightBox: () => {
    let isMobile = window.matchMedia(
      'only screen and (max-width: 760px)'
    ).matches
    if (!isMobile) {
      $('.equalHeightBox').each(function () {
        var highestBox = 0
        $('.box', this).each(function () {
          if ($(this).height() > highestBox) {
            highestBox = $(this).height()
          }
        })
        $('.box', this).height(highestBox)
      })
    }
  }
}
