<?php
defined('BASEPATH') OR exit('No direct script access allowed');
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'assets/PHPMailer/vendor/autoload.php';

function csrf_input(){
	$CI = &get_instance();
	$csrf = array(
        'name' => $CI->security->get_csrf_token_name(),
        'hash' => $CI->security->get_csrf_hash()
	);
   	return '<input type="hidden" name="' . $csrf['name'] . '" value="' . $csrf['hash'] . '" />';
}
function include_dir(){
	return _BASEDIR;
}
function views_dir(){
	return APPPATH . 'views/';
}
function callCurl($url, $port = false, $postdata = array(), $header = array()){
		$headers = array();
		if(!empty($header)){
			foreach($header	AS $key=>$value){
				$headers[] = $key . ': ' . $value;
			}
		}
		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, $url );
		if(!empty($port)) 
			curl_setopt($ch, CURLOPT_PORT, $port);
		if(!empty($headers)) 
			curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers );
			curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
			curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
			curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		if(!empty($postdata)) {
			curl_setopt( $ch, CURLOPT_POST, true );
			curl_setopt( $ch, CURLOPT_POSTFIELDS, $postdata );
		}
        $result = curl_exec($ch);
  		$err     = curl_errno( $ch ); 
        $errmsg  = curl_error( $ch );
		$info = curl_getinfo($ch);
        curl_close($ch);
		if($err > 0) return array("status"=>"error", "result"=>$errmsg, "info"=>$info);
		return array("status"=>"success", "result"=>json_decode($result, TRUE));
}
function doCurl($url, $port = false, $postdata = array(), $headers = array()){
	$curl = curl_init();
	$cul_options = array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_VERBOSE => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_HTTPHEADER => $headers
		);
	curl_setopt_array(
		$curl, 
		$cul_options
	);
		$response = curl_exec($curl);
		$err = curl_errno( $curl ); 
		$errmsg = curl_error( $curl );
		$info = curl_getinfo($curl);
		curl_close($curl);
}
function serialNumber(){
	$CI = &get_instance();
	$query = $CI->db->select_max("Extra")->get("application");
	$result = $query->row_array();
	return ($result['Extra']) ? $result['Extra'] + 1 : 1;
}
function logMessage($message = '', $reported = false){
	$file = 'mc-log.txt';
	$reported = $reported ? '(reported) ' : '';
	$message = date("Y-m-d H:i:s") . ' ' . $reported . $message . "\n";
	
	// Write the contents to the file, 
	// using the FILE_APPEND flag to append the content to the end of the file
	// and the LOCK_EX flag to prevent anyone else writing to the file at the same time
	file_put_contents($file, $message, FILE_APPEND/* | LOCK_EX*/);
}
function date_field($name = 'Date'){ 
ob_start();
$max_age = 80;
$average_age = 30;
$current_day = date("d");
$current_month = date("m");
$current_year = date("Y");
$min_year = $current_year - $max_age;
$max_year = $current_year - 1;
$default_year = $current_year - $average_age;
$Months = array(
	"01"=>"January",
	"02"=>"February",
	"03"=>"March",
	"04"=>"April",
	"05"=>"May",
	"06"=>"June",
	"07"=>"July",
	"08"=>"August",
	"09"=>"September",
	"10"=>"October",
	"11"=>"November",
	"12"=>"December"
);
?>
	<div class="input-group max-width300">
       <select id="<?php echo $name; ?>_dd" name="<?php echo $name; ?>_dd" class="form-control col-3 <?php echo $name; ?>_dd">
       		<option value="">Day</option>
            <?php for($i = 1; $i < 32; $i++){ 
				if($i < 10) $d = '0' . $i;
				else $d = $i;
			?>
        	<option value="<?php echo $d; ?>"><?php echo $d; ?></option>
            <?php } ?>
       </select>
       <select id="<?php echo $name; ?>_mm" name="<?php echo $name; ?>_mm" class="form-control col-5 <?php echo $name; ?>_mm">
       		<option value="">Month</option>
            <?php foreach($Months AS $mm=>$month){ ?>
        	<option value="<?php echo $mm; ?>"><?php echo $month; ?></option>
            <?php } ?>
       </select>
       <select id="<?php echo $name; ?>_yy" name="<?php echo $name; ?>_yy" class="form-control col-4 <?php echo $name; ?>_yy">
       		<option value="">Year</option>
            <?php for($y = $max_year; $y > $min_year; $y--){ ?>
        	<option value="<?php echo $y; ?>"><?php echo $y; ?></option>
            <?php } ?>
       </select>
  	</div>
 <?php 
 	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}
function get_app_title(){ 
	return _SUKUK_APP_TITLE;
}
function get_form_title(){ 
	ob_start();
	?>
        <h3 class="bold mb-1"><?php echo strtoupper(_SUKUK_APP_TITLE); ?></h3> 
        <h4 class="size18 bold mb-2 pb-2 w3-bottom-border w3-text-black">ON BEHALF OF THE FEDERAL GOVERNMENT OF NIGERIA</h4>
        <div class="mb-4" style="margin: auto; width: 40%;"></div>
<?php 
 	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}
function get_footer( $status = 'open', $align = 'center', $source = 'page' ){ 
	ob_start();
	?>
	<div id="logo" style="text-align: <?php echo $align; ?>; margin-top: 40px; margin-bottom: 15px;"><?php echo '<img src="' . base_url('images/LotusCapitalLogo.png') . '" width="200" alt=""/>'; ?></div>
	<div style="font-size: 12px; text-align: <?php echo $align; ?>; margin-bottom: 8px;">All right Reserved. ©'<?php echo date("Y"); ?> <?php echo _SUKUK_COMPANY_NAME; ?></div>
	<?php if($source != 'email'){ ?>
    <div style="font-size: 12px; text-align: <?php echo $align; ?>; margin-bottom: 8px;" class="no-print">
		<?php if($status != 'closed'){ ?>
        <a href="<?php echo site_url(); ?>" class="">NEW APPLICATION</a> | 
        <?php } ?>
        <a href="<?php echo _SUKUK_PRIVACY_POLICY; ?>" class="">PRIVACY POLICY</a>
    </div>
    <?php } ?>
    <div style="font-size: 12px; text-align: <?php echo $align; ?>; margin-bottom: 15px;"><?php echo _SUKUK_ADDRESS; ?><br>M <?php echo _SUKUK_CONTACT_TELEPHONE; ?> <br>Email <?php echo _SUKUK_CONTACT_EMAIL; ?></div>
<?php 
 	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}
function generate_serial_no(){
	$CI = &get_instance();	
		$CI->db->select_max('Extra');		
		$query = $CI->db->get('applications');
		$result = $query->row_array();
		$num = $result['Extra'];
		if($num > 0){
		$number = ltrim($num, "0");
			$number++;
		} else {
			$number = 1;
		}
		$pad = 9;
		$serial_no = str_pad($number, $pad, "0", STR_PAD_LEFT);
		$count = $CI->db->select('Extra')->where('Extra', $serial_no)->count_all_results('applications');
		if( $count > 0 ) generate_serial_no();
		return $serial_no; //000000002
}
function payment_notification_email($info){
	$align = defined('_SUKUK_EMAIL_BODY_ALIGN') && _SUKUK_EMAIL_BODY_ALIGN == 'center' ? 'center' : 'left';
	extract($info);
	ob_start();
	?>
<?php $amount = $InvestmentValue > 0 ? number_format($InvestmentValue, 2) : '0.00'; ?>
<p style="text-align: <?php echo $align; ?>;">Thank you for  subscribing to the 3rd FGN  Sukuk Issuance. You are almost done!</p>
<p style="text-align: <?php echo $align; ?>;">Your application however is <strong>INCOMPLETE</strong> until you pay for your subscription.</p>
<p style="text-align: <?php echo $align; ?>;">Kindly click  on the <strong>PAY NOW</strong> button to complete your application. </p>
<p style="text-align: <?php echo $align; ?>; margin-bottom: 20px;">
<a href="<?php echo site_url( 'prepayment/' . $ref_id ); ?>" style="padding: 10px 40px; display:inline-block; background-color:#F05A40; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif; text-decoration:none; color: #fff;">PAY NOW</a>
</p>
    <div style="max-width: 640px; border: 1px solid #C1C1C1; <?php if($align == 'center') echo 'margin: auto;'; ?>">
	<table style="width: 100%" border="0" cellspacing="0" cellpadding="0">
      <tbody>
        <tr>
          <td width="35%" align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Full name</td>
          <td width="65%" style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:13px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo strtoupper($trxFullname); ?></td>
        </tr>
        <tr>
          <td align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Application type</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:13px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo strtoupper($AccountType); ?></td>
        </tr>
        <tr>
          <td align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Amount </td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:13px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;">N<?php echo $amount; ?></td>
        </tr>
        <tr>
          <td align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Email Address</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:13px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $trxEmail; ?></td>
        </tr>
        <tr>
          <td align="left" style="padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Telephone</td>
          <td style="padding: 5px; text-align:left; font-size:13px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $trxPhoneNo; ?></td>
        </tr>
      </tbody>
    </table>
	</div>
    <p>&nbsp;</p>
    <p style="text-align:<?php echo $align; ?>">If you have any issue making payment, please contact us:<br>Lagos: +234908 7058 405, +234908 7058 406, +234807 7099 552, +234807 7099 553<br>Abuja: +234908 7058 409, +234807 7099 556<br>Email:   <a href="mailto:<?php echo _SUKUK_CONTACT_EMAIL; ?>" target="_blank"><?php echo _SUKUK_CONTACT_EMAIL; ?></a></p>
    <p style="text-align:<?php echo $align; ?>">Thank you</p>
<?php 
 	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}
function payment_success_email($info, $trans){
	extract($info);
	$naira = '<span class="dlt">N</span>';
	ob_start();
	$align = defined('_SUKUK_EMAIL_BODY_ALIGN') && _SUKUK_EMAIL_BODY_ALIGN == 'center' ? 'center' : 'left';
	?>
  <?php $amount = $trans['amount'] > 0 ? number_format($trans['amount'], 2) : '0.00'; ?>
<p style="text-align: <?php echo $align; ?>">Thank you for  subscribing to the 3rd FGN  Sukuk Issuance. Your application is complete!</p>
<p style="text-align: <?php echo $align; ?>;">Please find attached a pdf copy of your submitted form for your personal record.</p>
<p style="text-align: <?php echo $align; ?>">We would  review your application and our support team will contact you if necessary<strong>.</strong></p>
<p style="text-align: <?php echo $align; ?>">A confirmation of allotment would be sent to your email within 14 business days  of the close of the offer, where your application is successful.&nbsp;</p>
<p style="text-align: <?php echo $align; ?>">Your subscription amount would be duly refunded to  the account provided in your form if your application is unsuccessful.</p>
<p style="text-align: <?php echo $align; ?>">Payment of <?php echo $naira . $amount; ?> was completed. Please see your transaction detail below.</p>
    <div style="max-width: 640px; border: 1px solid #C1C1C1; <?php if($align == 'center') echo 'margin: auto;'; ?>">
  <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0" class="">
    <tbody>
          <tr>
            <td width="35%" nowrap="nowrap" style="font-weight: bold; border-top: 1px solid #C1C1C1; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Amount </td>
            <td width="65%" style=" border-top: 1px solid #C1C1C1;border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $naira . $amount; ?></td>
          </tr>
        <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Status </td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">COMPLETED</td>
        </tr>
       <?php if( !empty(trim($trans['payment_status_description'])) ){ ?>
        <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Narratives </td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo strtoupper($trans['payment_status_description']); ?></td>
        </tr>
        <?php } ?>
        <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Transaction Reference</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $trans['txnref']; ?></td>
        </tr>
         <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Sukuk Application ID</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $trans['ApplicationID']; ?></td>
        </tr>
        <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Application type</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo strtoupper($info['AccountType']); ?></td>
        </tr>
        <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Application Reference</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo strtoupper($trans['app_ref']); ?></td>
        </tr>
       <?php if( is_date($trans['payment_date']) ){ ?>
         <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Transaction Date </td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo !empty($trans['payment_date']) ? $trans['payment_date'] : '-'; ?></td>
        </tr>
        <?php } ?>
        <?php if(!empty( $trans['channel'])){ ?>
        <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Payment Channel</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo !empty($trans['channel']) ? strtoupper($trans['channel']) : '-'; ?></td>
        </tr>
        <?php } ?>
        <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Full name</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo strtoupper($trans['names']); ?></td>
        </tr>
        <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Email</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $trans['email_address']; ?></td>
        </tr>
        <tr>
          <td nowrap="nowrap" style="font-weight: bold; border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;">Telephone</td>
          <td style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:13px; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $trans['phone_number']; ?></td>
        </tr>
      </tbody>
  </table>
	</div>	
<p>&nbsp;</p>
<p style="text-align:<?php echo $align; ?>">For enquiries please  contact us on:<br>Lagos: +234908 7058 405, +234908 7058 406, +234807 7099 552, +234807 7099 553<br>Abuja: +234908 7058 409, +234807 7099 556<br>Email: <a href="mailto:<?php echo _SUKUK_CONTACT_EMAIL; ?>" target="_blank"><?php echo _SUKUK_CONTACT_EMAIL; ?></a></p>
<p style="text-align:<?php echo $align; ?>">Thank you.</p>
  <?php 
 	$content = ob_get_contents();
	ob_end_clean();

 $file_name = 'sukuk-' . strtolower($Comment) . '.pdf';
 $mail = new PHPMailer(true);
  try {
	  $mail->isMail();     
	  $mail->Mailer = "mail";                    // Send using MAIL or SMTP
	  $mail->Host       = '';                    // Set the SMTP server to send through
	  $mail->SMTPAuth   = true;                   // Enable SMTP authentication
	  $mail->Username   = '';                     // SMTP username
	  $mail->Password   = '';                               // SMTP password
	  $mail->Port       = 465;           // TCP port to connect to
	  $mail->setFrom(_SUKUK_EMAIL_SENDER, _SUKUK_EMAIL_SENDER_NAME);
	  $mail->addAddress($trans['email_address']); 	// Name is optional
	  $bcc = defined('_SUKUK_EMAIL_RECIPIENT') ? _SUKUK_EMAIL_RECIPIENT : false;
	  $bcc_email = !empty($bcc) ? explode(',', $bcc) : array();
	  if(!empty($bcc_email)){
		  foreach($bcc_email AS $bcc_address){			  
			  $mail->addBCC(trim($bcc_address)); //$mail->addCC(trim($bcc_address))
		  }
	  }
	  $mail->addAttachment($file_name); // Add attachments
	  $mail->isHTML(true); // Set email format to HTML
	  $mail->Subject = _SUKUK_SUBJECT_PREFIX . ': Your Application is Complete!';
	  $mail->Body    = $content . get_footer('open', $align, 'email');
	  $mail->AltBody = _SUKUK_SUBJECT_PREFIX . ': Your Application is Complete!';;
	  $mail->send();
  } 
  catch (Exception $e) {
	  logMessage("[" . $ref_id . "] Mailer Error: {$mail->ErrorInfo}");
	  return false;
  }
  return true;
}
function success_email(){
	ob_start();
	$align = defined('_SUKUK_EMAIL_BODY_ALIGN') && _SUKUK_EMAIL_BODY_ALIGN == 'center' ? 'center' : 'left';
	?>
    <p style="text-align: <?php echo $align; ?>">Thank you for  subscribing to the 3rd FGN  Sukuk Issuance. Your application is complete!</p>
	<p style="text-align: <?php echo $align; ?>;">Please find attached a pdf copy of your submitted form for your personal record.</p>
    <p style="text-align: <?php echo $align; ?>">We would review your application and our support team will contact you if necessary<strong>.</strong></p>
    <p style="text-align: <?php echo $align; ?>">A confirmation of allotment would be sent to your email within 14 business days  of the close of the offer, where your application is successful.&nbsp;</p>
    <p style="text-align: <?php echo $align; ?>">For enquiries please  contact us on:<br>Lagos: +234908 7058  405, +234908 7058 406, +234807 7099 552, +234807 7099 553<br>Abuja: +234908 7058  409, +234807 7099 556<br>Email: <a href="mailto:<?php echo _SUKUK_CONTACT_EMAIL; ?>" target="_blank"><?php echo _SUKUK_CONTACT_EMAIL; ?></a> </p>
    <p style="text-align: <?php echo $align; ?>">Thank you</p>
<?php 
 	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}
function curl_data($data, $type = 'array_of_object') {
	$arr_open = '';
	$arr_close = '';
	if($type == 'array_of_object') {
		$arr_open = '[ ';
		$arr_close = ']';
	}
return $arr_open . 
		 ' {  
			 "ApplicationID": ' . $data ['ApplicationID']. ',  
			 "Surname": "' . $data ['Surname']. '",  
			 "FirstName": "' . $data ['FirstName']. '",  
			 "OtherName": "' . $data ['OtherName']. '",  
			 "AccountType": "' . $data ['AccountType']. '",  
			 "Occupation": "' . $data ['Occupation']. '",  
			 "Address": "' . $data ['Address']. '",  
			 "Email": "' . $data ['Email']. '",  
			 "IDNo": "' . $data ['IDNo']. '",  
			 "DOB": "' . $data ['DOB']. '",  
			 "MotherMaidenName": "' . $data ['MotherMaidenName']. '",  
			 "NextOfKin": "' . $data ['NextOfKin']. '",  
			 "InvestmentValue": ' . $data ['InvestmentValue']. ',  
			 "Bank": "' . $data ['Bank']. '",  
			 "BVN": "' . $data ['BVN']. '",  
			 "InvestorCategory": "' . $data ['InvestorCategory']. '",  
			 "DataEntryDate": "' . $data ['DataEntryDate']. '",  
			 "USSD_Duration": ' . $data ['USSD_Duration']. ',  
			 "Title": "' . $data ['Title']. '",  
			 "Residency": "' . $data ['Residency']. '",  
			 "PhoneNo": "' . $data ['PhoneNo']. '",  
			 "CustodianAccount": "' . $data ['CustodianAccount']. '",  
			 "BankAccount": "' . $data ['BankAccount']. '",  
			 "UnitQuantity": ' . $data ['UnitQuantity']. ',  
			 "Company_Name": "' . $data ['Company_Name']. '",  
			 "Type_of_Business": "' . $data ['Type_of_Business']. '",  
			 "RC_No": "' . $data ['RC_No']. '",  
			 "Contact_Person": "' . $data ['Contact_Person']. '",  
			 "Full_Name2": "' . $data ['Full_Name2']. '",  
			 "Occupation2": "' . $data ['Occupation2']. '",  
			 "Phone_No2": "' . $data ['Phone_No2']. '",  
			 "Address2": "' . $data ['Address2']. '",  
			 "ID_Type2": "' . $data ['ID_Type2']. '",  
			 "IDNo2": "' . $data ['IDNo2']. '",  
			 "DOB2": "' . $data ['DOB2']. '",  
			 "MotherMaidName2": "' . $data ['MotherMaidName2']. '",  
			 "EmailAddress2": "' . $data ['EmailAddress2']. '",  
			 "Bank2": "' . $data ['Bank2']. '",  
			 "BankAccount2": "' . $data ['BankAccount2']. '",  
			 "BVN2": "' . $data ['BVN2']. '",  
			 "Authorised_Dealer": "' . $data ['Authorised_Dealer']. '",  
			 "Sukuk_Type": "' . $data ['Sukuk_Type']. '",  
			 "Application_Date": "' . $data ['Application_Date']. '",  
			 "Status": "' . $data ['Status']. '",  
			 "BD_User_ID": "' . $data ['BD_User_ID']. '",  
			 "BD_Date": "' . $data ['BD_Date']. '",  
			 "Fincon_User_ID": "' . $data ['Fincon_User_ID']. '",  
			 "FIncon_Date": "' . $data ['FIncon_Date']. '",  
			 "Comment": "' . $data ['Comment']. '",  
			 "Receiving_Bank": "' . $data ['Receiving_Bank']. '",  
			 "S4_Custodian": "' . $data ['S4_Custodian']. '",  
			 "CHN": "' . $data ['CHN']. '",  
			 "ID_Type": "' . $data ['ID_Type']. '",  
			 "Reject_Comment": "' . $data ['Reject_Comment']. '",  
			 "Extra1": "' . $data ['Extra1']. '",  
			 "Extra2": "' . $data ['Extra2']. '",  
			 "Extra3": "' . $data ['Extra3']. '",  
			 "Extra": "' . $data ['Extra']. '",  
			 "Extra4": "' . $data ['Extra4']. '"  
		   } ' .
		 $arr_close	;
}
function curl_data_with_newline($data, $type = 'array_of_object') {
	$arr_open = '';
	$arr_close = '';
	if($type == 'array_of_object') {
	$arr_open = '[ \ ';
	$arr_close = ']';
	}
return $arr_open . 
		 ' { \ 
			 "ApplicationID": ' . $data ['ApplicationID']. ', \ 
			 "Surname": "' . $data ['Surname']. '", \ 
			 "FirstName": "' . $data ['FirstName']. '", \ 
			 "OtherName": "' . $data ['OtherName']. '", \ 
			 "AccountType": "' . $data ['AccountType']. '", \ 
			 "Occupation": "' . $data ['Occupation']. '", \ 
			 "Address": "' . $data ['Address']. '", \ 
			 "Email": "' . $data ['Email']. '", \ 
			 "IDNo": "' . $data ['IDNo']. '", \ 
			 "DOB": "' . $data ['DOB']. '", \ 
			 "MotherMaidenName": "' . $data ['MotherMaidenName']. '", \ 
			 "NextOfKin": "' . $data ['NextOfKin']. '", \ 
			 "InvestmentValue": ' . $data ['InvestmentValue']. ', \ 
			 "Bank": "' . $data ['Bank']. '", \ 
			 "BVN": "' . $data ['BVN']. '", \ 
			 "InvestorCategory": "' . $data ['InvestorCategory']. '", \ 
			 "DataEntryDate": "' . $data ['DataEntryDate']. '", \ 
			 "USSD_Duration": ' . $data ['USSD_Duration']. ', \ 
			 "Title": "' . $data ['Title']. '", \ 
			 "Residency": "' . $data ['Residency']. '", \ 
			 "PhoneNo": "' . $data ['PhoneNo']. '", \ 
			 "CustodianAccount": "' . $data ['CustodianAccount']. '", \ 
			 "BankAccount": "' . $data ['BankAccount']. '", \ 
			 "UnitQuantity": ' . $data ['UnitQuantity']. ', \ 
			 "Company_Name": "' . $data ['Company_Name']. '", \ 
			 "Type_of_Business": "' . $data ['Type_of_Business']. '", \ 
			 "RC_No": "' . $data ['RC_No']. '", \ 
			 "Contact_Person": "' . $data ['Contact_Person']. '", \ 
			 "Full_Name2": "' . $data ['Full_Name2']. '", \ 
			 "Occupation2": "' . $data ['Occupation2']. '", \ 
			 "Phone_No2": "' . $data ['Phone_No2']. '", \ 
			 "Address2": "' . $data ['Address2']. '", \ 
			 "ID_Type2": "' . $data ['ID_Type2']. '", \ 
			 "IDNo2": "' . $data ['IDNo2']. '", \ 
			 "DOB2": "' . $data ['DOB2']. '", \ 
			 "MotherMaidName2": "' . $data ['MotherMaidName2']. '", \ 
			 "EmailAddress2": "' . $data ['EmailAddress2']. '", \ 
			 "Bank2": "' . $data ['Bank2']. '", \ 
			 "BankAccount2": "' . $data ['BankAccount2']. '", \ 
			 "BVN2": "' . $data ['BVN2']. '", \ 
			 "Authorised_Dealer": "' . $data ['Authorised_Dealer']. '", \ 
			 "Sukuk_Type": "' . $data ['Sukuk_Type']. '", \ 
			 "Application_Date": "' . $data ['Application_Date']. '", \ 
			 "Status": "' . $data ['Status']. '", \ 
			 "BD_User_ID": "' . $data ['BD_User_ID']. '", \ 
			 "BD_Date": "' . $data ['BD_Date']. '", \ 
			 "Fincon_User_ID": "' . $data ['Fincon_User_ID']. '", \ 
			 "FIncon_Date": "' . $data ['FIncon_Date']. '", \ 
			 "Comment": "' . $data ['Comment']. '", \ 
			 "Receiving_Bank": "' . $data ['Receiving_Bank']. '", \ 
			 "S4_Custodian": "' . $data ['S4_Custodian']. '", \ 
			 "CHN": "' . $data ['CHN']. '", \ 
			 "ID_Type": "' . $data ['ID_Type']. '", \ 
			 "Reject_Comment": "' . $data ['Reject_Comment']. '", \ 
			 "Extra1": "' . $data ['Extra1']. '", \ 
			 "Extra2": "' . $data ['Extra2']. '", \ 
			 "Extra3": "' . $data ['Extra3']. '", \ 
			 "Extra": "' . $data ['Extra']. '", \ 
			 "Extra4": "' . $data ['Extra4']. '" \ 
		   } \ ' .
		 $arr_close	;
}
function sukukSetup(){
// GET /api/SukukSetup
	$setup_url = _SUKUK_SETUP_API_URL; 
	$curl = curl_init();
	curl_setopt_array(
		$curl, 
		array(
		  CURLOPT_URL => $setup_url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_VERBOSE => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "GET",
		  CURLOPT_HTTPHEADER => array(
				"Content-Type: application/json",
				"cache-control: no-cache",
				"Accept: application/json"
		  )
		)
	);
		$response = curl_exec($curl);
		$err = curl_errno( $curl ); 
		$errmsg = curl_error( $curl );
		$info = curl_getinfo($curl);
		curl_close($curl);
		
	if($err > 0) {
		$api_error = true;
		logMessage("sukukSetup [" . $Trans['app_ref'] . "] " . $errmsg);
		return false;
	} 
	//POST TOPUP
	$setupGroup = !empty($response) ? json_decode(stripslashes($response), true) : false;
	
	if(empty($setupGroup)) return false;
	
	$setup = $setupGroup[count($setupGroup) - 1];
	return $setup;
}
function postSukuk($data, $insert_id, $files = array()){
	$CI = &get_instance();
	$api_error = false;
	$url = _SUKUK_CUSTOMER_API_URL; 
	$curl = curl_init();
	curl_setopt_array(
		$curl, 
		array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_VERBOSE => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS => json_encode($data),
		  CURLOPT_HTTPHEADER => array(
		  		"Content-Type: application/json",
				"cache-control: no-cache",
				"Accept: application/json"
		  )
		)
	);
		$response = curl_exec($curl);
		$err = curl_errno( $curl ); 
		$errmsg = curl_error( $curl );
		$info = curl_getinfo($curl);
		curl_close($curl);
		
	if($err > 0) {
		$api_error = true;
		if(_SUKUK_CONTINUE_ON_API_ERROR) {
			logMessage("[" . $ref_id . "] " . $errmsg);
		}
		else {
			if(!empty($files)) unlink_files($files);
			_return_error($errmsg);
		}
	} 
	
	$SukukCustomer = !$api_error ? json_decode(stripslashes($response), true) : false;
	$Message = false;
	if(empty($SukukCustomer)) {
		if(_SUKUK_CONTINUE_ON_API_ERROR) {
			logMessage("[" . $ref_id . "] API Error: No response received from API");
			$Message = 'success';
		}
		else {
			if(!empty($files)) unlink_files($files);
			_return_error("No response received from API");
		}
	} 
	else {
		$Message = array_key_exists('Message', $SukukCustomer) ? trim(strtolower($SukukCustomer['Message'])) : $Message;
		$Message = !$Message && array_key_exists('message', $SukukCustomer) ? trim(strtolower($SukukCustomer['message'])) : $Message;

		if($Message == 'success'){
			$Data = array_key_exists('Data', $SukukCustomer) ? $SukukCustomer['Data'] : array();
			$Data = empty($Data) && array_key_exists('data', $SukukCustomer) ? $SukukCustomer['data'] : $Data;

			if(!empty($Data)){
				
			$ApplicationID = array_key_exists('ApplicationID', $Data) ? $Data['ApplicationID'] : '0';
			$ApplicationID = empty($ApplicationID) && array_key_exists('applicationId', $Data) ? $Data['applicationId'] : $ApplicationID;

				$data['ApplicationID'] = $ApplicationID;
				$update = $CI->db->update("applications", array("ApplicationID"=>$data['ApplicationID']), array("id"=>$insert_id));
			}
		}
	}
	return $Message;
}
function sukukTopup( $app_ref ){
	$CI = &get_instance();
	$app = $CI->api_model->get_application($app_ref);
	if(empty($app)) return false;
	$ApplicationID = $app['ApplicationID'];
	if(empty($ApplicationID)) return false;
	
	
	$setupGroup = sukukSetup();
	if(empty($setupGroup)) return false;
	//$setup = $setupGroup[count($setupGroup) - 1];
	$InvestmentType = $setupGroup['Sukuk_ID'];
	$ContactNo = $ApplicationID; // 1;
	$PhoneNo = $app['PhoneNo']; // '08057104915';
	$UnitPrice = str_replace(',', '', $setupGroup['Unit_Price']);
	$Units = $app['InvestmentValue'] / $UnitPrice; // 20000;
	
	$topupData = array(
		"ContactNo" => $ContactNo,
		"PhoneNo" => $PhoneNo,
		"InvestmentType" => $InvestmentType,
		"UnitPrice" => $UnitPrice,
		"Units" => $Units
	);
	$topup_url = _SUKUK_TOPUP_API_URL; 
	$topupCurl = curl_init();
	curl_setopt_array(
		$topupCurl, 
		array(
		  CURLOPT_URL => $topup_url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_VERBOSE => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS => json_encode($topupData),
		  CURLOPT_HTTPHEADER => array(
				_SUKUK_TOPUP_APIKEY,
				"Content-Type: application/json",
				"cache-control: no-cache",
				"Accept: application/json"
		  )
		)
	);
		$topupResponse = curl_exec($topupCurl);
		$topupErr = curl_errno( $topupCurl ); 
		$topupErrmsg = curl_error( $topupCurl );
		curl_close($topupCurl);
		
	if($topupErr > 0) {
		$api_error = true;
		logMessage("sukukTopup [" . $Trans['app_ref'] . "] " . $topupErrmsg);
		return false;
	} 
	$UpdateData['topup_updated'] = '1';
	$UpdateData['topup_response'] = json_encode($topupResponse);
	$UpdateData['topup_data'] = json_encode($topupData);
	return $UpdateData;	
}
function updateSukuk( $ApplicationID, $putData ){
  if(empty($ApplicationID)) return false;
  //PUT /api/SukukCustomer/{id}
  $update_url = _SUKUK_CUSTOMER_API_URL . '/' . $ApplicationID; 
	$putCurl = curl_init();
	curl_setopt_array(
		$putCurl, 
		array(
		  CURLOPT_URL => $update_url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_VERBOSE => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS => json_encode($putData),
		  CURLOPT_HTTPHEADER => array(
				"Content-Type: application/json",
				"cache-control: no-cache",
				"Accept: application/json"
		  )
		)
	);
	$putResponse = curl_exec($putCurl);
	$putErr = curl_errno( $putCurl ); 
	$putErrmsg = curl_error( $putCurl );
	curl_close($putCurl);

	if($putErr > 0) {
		logMessage("updateSukuk 1 [" . $ApplicationID . "] " . $putErrmsg);
		return false;
	} 
	$put_Response = !empty($putResponse) ? json_decode(stripslashes($putResponse), true) : false;
	/*if(!empty($put_Response['Message'])){
		logMessage("updateSukuk 2 [" . $ApplicationID . "] " . $put_Response['Message']);
		return false;
	}	*/	
	$UpdateData['status_updated'] = '1';
	return $UpdateData;
}

function validate_request_token( $token = false ){
	$CI = &get_instance();
	if( get_setting('csrf_protection') !== 'enabled' ) return true;
	return true;
	if(!$token) $token = $CI->input->get("hf-token");
	if(!$token) $token = $CI->input->post("hf-token");
	if(!$token) {
		_return_error("Invalid request! Token not sent");
	}
	$Token = explode('-', $token);
	/*$site_url = site_url();
	$server = !empty($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : false;
	$url = substr($server, strlen($site_url));*/
	if($Token[0] == 'admin' && $CI->session->user['usr_rid'] == $Token[1]) $session = 'admin';
	if($Token[0] == 'client' && $CI->session->hfuser == $Token[1]) $session = 'client';
	if($Token[0] == 'csa' && $CI->session->hfcsa == $Token[1]) $session = 'csa';
	if($Token[0] == 'supplier' && $CI->session->hfsupplier == $Token[1]) $session = 'supplier';
	if($Token[0] == 'technician' && $CI->session->hftechnician == $Token[1]) $session = 'technician';
	
	if(empty($session)) _return_error("Invalid session token! You are not logged in or your session may have expired!");
	if (isset($_COOKIE['hf_request_token']) && is_string($_COOKIE['hf_request_token']) && $_COOKIE['hf_request_token'] == $token)
			{
				unset($_COOKIE['hf_request_token']);
				return true;
			}
	_return_error("Invalid token!");
}
function set_cookies($name, $value = '', $expire = 86400){
	setcookie($name, $value, $expire); 
}
function delete_cookie($name){
	setcookie($name,"",time() - 3600); 	
}
function get_random_bytes($length){
	if (empty($length) OR ! ctype_digit((string) $length)){
			return FALSE;
		}
		if (function_exists('random_bytes'))
		{
			try
			{
				// The cast is required to avoid TypeError
				return random_bytes((int) $length);
			}
			catch (Exception $e)
			{
				// If random_bytes() can't do the job, we can't either ...
				// There's no point in using fallbacks.
				return FALSE;
			}
		}

		// Unfortunately, none of the following PRNGs is guaranteed to exist ...
		if (defined('MCRYPT_DEV_URANDOM') && ($output = mcrypt_create_iv($length, MCRYPT_DEV_URANDOM)) !== FALSE)
		{
			return $output;
		}


		if (is_readable('/dev/urandom') && ($fp = fopen('/dev/urandom', 'rb')) !== FALSE)
		{
			// Try not to waste entropy ...
			is_php('5.4') && stream_set_chunk_size($fp, $length);
			$output = fread($fp, $length);
			fclose($fp);
			if ($output !== FALSE)
			{
				return $output;
			}
		}

		if (function_exists('openssl_random_pseudo_bytes'))
		{
			return openssl_random_pseudo_bytes($length);
		}

		return FALSE;
	}
function csrf_validate_get( $token = false ){
		$CI = &get_instance();
		if( get_setting('csrf_protection') == 'enabled' ){
			if( $CI->config->item("csrf_protection") === true ){
				$token_name = $CI->security->get_csrf_token_name();
				$token_hash = $CI->security->get_csrf_hash();
			} else {
				$token_name = $CI->config->item("csrf_token_name");
				$token_hash = session_id();
			}
			if( $token_hash !== $token ) {
				show_error("Permission denied for action", 403, $heading = 'Permission denied');
				return false;
			}
		}
		
	return true;
}
function echo_data($data, $empty = '-'){
	echo !empty($data) ? $data : $empty;
}
function force_ssl(){
	if(!is_https()){
		redirect('https://' . _BASEURL);
	}
}
function force_login(){
	if(!is_user()){
		if(uri_string() !== 'login') {
			$redirect = !empty($_SERVER['REQUEST_URI']) ? '?redirect=' . $_SERVER['REQUEST_URI'] : '';
		  	redirect(site_url('login' . $redirect));
		} 
	}
}
function _return_success( $result = 'success' ){
	die( json_encode(array("status"=>"success", "result"=>$result)) ); 
}
function generate_randomID(){
		$code = '-';
		$possible = '1234567890';
		for($i = 0; $i < 3; $i++){
			$random = mt_rand(0, strlen($possible)-1);
			$code .= $possible[$random];
		}
		$time = date("Ymd-His");
		return $time . $code;
	}
function _return_error( $result = 'error' ){
	die( json_encode(array("status"=>"error", "result"=>$result)) ); 
}
function print_array($string = false){
	if(!$string) return false;
	echo '<pre>' . print_r($string, true) . '</pre>';
}
function is_image( $type ){
	$imageTypes = array("image/gif", "image/jpg", "image/jpeg", "image/pjpeg", "image/png", "image/x-png");	
	if(in_array(strtolower($type), $imageTypes)) return true;
	return false;
}
function is_video( $type ){
	$videoTypes = array("video/mp4", "video/3gpp", "video/3gp");
	if(in_array(strtolower($type), $videoTypes)) return true;
	return false;
}
function alert($message = false, $type = 'success'){
	$CI = &get_instance();
	if(!empty($message)){
		$Alert['msg'] = $message;
		$Alert['type'] = $type;
		$CI->gResponse[] = $Alert;
	}
}
function flash_alert($message = false, $type = 'success'){
	$CI = &get_instance();
	$CI->load->library('session');
	$_SESSION[$type] = $message;
	$CI->session->set_flashdata($type, $message);
}
function error_exists(){
$CI = &get_instance();
	return !empty($CI->gResponse) ? true : false;
}
function split_array($data){
$CI = &get_instance();
		$msg = array();
		if(!empty($data) && is_array($data)){
			foreach($data as $key=>$value){
				$msg[] = '['.$key.'] => ' . $CI->split_array($value);
			}
		} else {
		$msg[] = $data;
		}
		return implode('<br />', $msg);
	}
function alerts(){ 
$CI = &get_instance();

		if($CI->session->flashdata('success')) {
			$msgSuccess = $CI->session->flashdata('success');
		print_array($msgError);
		}
		
		if($CI->session->flashdata('error')) {
			$msgError = $CI->session->flashdata('error');
		print_array($msgError);
		}
		if($CI->session->flashdata('warning')) {
			$msgWarning = $CI->session->flashdata('warning');
		print_array($msgError);
		}

	if(!empty($CI->gResponse)){
		ob_start();
		foreach($CI->gResponse AS $message){
			if(!empty($message['msg'])){
				if( $message['type'] == 'error' ) $message['type'] = 'danger';
				$message['type'] = !empty($message['type']) ? $message['type'] : 'success';
				switch($message['type']){
					case 'success': $color = 'green'; $icon = 'check'; break;
					case 'warning': $color = 'brown'; $icon = 'info-circle'; break;
					case 'danger': $color = 'red'; $icon = 'exclamation-triangle'; break;
					default: $color = 'black'; $icon = 'info'; break;
				}
			?>
    </p>
    <div class="alert alert-block alert-<?php echo $message['type']; ?>">
	  <button type="button" class="close" data-dismiss="alert"> <i class="ace-icon fa fa-times"></i> </button>
          <?php if(is_array($message['msg'])){
			  print_array($message['msg']);
		  } else { ?>
		  <i class="ace-icon fa fa-<?php echo $icon; ?> <?php echo $color; ?> w3-large"></i> <?php echo $message['msg']; ?>
          <?php } ?>
          </div>
		<?php 
			}
		}
			$content = ob_get_contents();
			   ob_end_clean();
			   return $content;
		}
    }
function response($wrap_open=FALSE, $wrap_close=FALSE){
$CI = &get_instance();
		$message = FALSE;
		$msgSuccess = FALSE;
		$msgError = FALSE;
		$msgWarning = FALSE;
		if((!isset($type) || $type=='success') && isset($CI->success)){
			foreach($CI->success as $msg){
				if($msg) {
					$msgSuccess[] = $CI->split_array($msg);
				}
			}
		}
		if((!isset($type) || $type=='error') && isset($CI->error)){
			foreach($CI->error as $msg){
				if($msg) $msgError[] = $CI->split_array($msg);
			}
		}
		if((!isset($type) || $type=='warning') && isset($CI->warning)){
			foreach($CI->warning as $msg){
				if($msg) $msgWarning[] = $CI->split_array($msg);
			}
		}
		
		if((!isset($type) || $type=='success') && $CI->session->flashdata('success')) 
		$msgSuccess[] = $CI->split_array($CI->session->flashdata('success'));
		if((!isset($type) || $type=='error') && $CI->session->flashdata('error')) 
		$msgError[] = $CI->split_array($CI->session->flashdata('error'));
		if((!isset($type) || $type=='warning') && $CI->session->flashdata('warning')) 
		$msgWarning[] = $CI->split_array($CI->session->flashdata('warning'));
		
		if($msgError){
			foreach($msgError as $Msg){
			$message .= '<div class="margin-10 block alert alert-danger alert-dismissable width-80p" style="display:block!important; margin-right: auto; margin-left:auto;">
				 <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' . 
				 $Msg .'</div>';
			}
		}
				
		if($msgWarning){
			foreach($msgWarning as $Msg){
			$message .= '<div class="margin-10 block alert alert-warning alert-dismissable width-80p" style="display:block!important; margin-right: auto; margin-left:auto;">
				 <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'. 
				 $Msg .'</div>';
			}
		}

		if($msgSuccess){
			foreach($msgSuccess as $Msg){
			$message .= '<div class="margin-10 block alert alert-success alert-dismissable width-80p" style="display:block!important; margin-right: auto; margin-left:auto;">
				 <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'. 
				 $Msg .'</div>';
			}
		}
		if($message) return $wrap_open.$message.$wrap_close;

	}
function get_settings(){
	$CI = &get_instance();
	return $CI->api_model->get_settings();
}
function get_settings_json(){
	$CI = &get_instance();
	$settings = $CI->api_model->get_settings();
	return json_encode($settings);
}
function curl_url($Url){
    // is cURL installed yet?
    if (!function_exists('curl_init')){
        die('Sorry cURL is not installed!');
    }
 
    // OK cool - then let's create a new cURL resource handle
    $ch = curl_init();
 
    // Now set some options (most are optional)
    // Set URL to download
    curl_setopt($ch, CURLOPT_URL, $Url);
 
    // Set a referer
    curl_setopt($ch, CURLOPT_REFERER, site_url());
 
    // User agent
    curl_setopt($ch, CURLOPT_USERAGENT, "MozillaXYZ/1.0");
 
    // Include header in result? (0 = yes, 1 = no)
    curl_setopt($ch, CURLOPT_HEADER, 0);
 
    // Should cURL return or print out the data? (true = return, false = print)
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
 
    // Timeout in seconds
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
 
    // Download the given URL, and return output
    $output = curl_exec($ch);
 
    // Close the cURL resource, and free system resources
    curl_close($ch);
 
    return $output;
}
function get_post(){
	$CI = &get_instance();
	$data = array();
	if(isset($_POST)){
		foreach($_POST as $key=>$value){
			$data[$key] = $CI->input->post($key, TRUE);
		}
	}
	
	if(isset($_GET)){
		foreach($_GET as $key=>$value){
			$data[$key] = $CI->input->get($key, TRUE);
		}
	}
	
	return $data;
}
function escape_str($string){
	if(empty($string)) return;
	$CI = &get_instance();
	return $CI->db->escape_str($string);
}
function escape($string){
	if(empty($string)) return false;
	$CI = &get_instance();
	return is_string($string) ? $CI->db->escape_str($string) : $CI->db->escape($string);
}
function valid_email($email){
    if(!preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $email)) {
    //Email is invalid;
        return false;
    } else {
        return true;
    }
}
function valid_telephone($string) {
if(!preg_match('/^\+?([0-9]{1,4})\)?[-. ]?([0-9]{10})$/', $string) ) {
 return FALSE;
 } else {
    $numberOfDigits = strlen($string);
	if ($numberOfDigits == 7 || $numberOfDigits == 9 || $numberOfDigits == 11 || $numberOfDigits == 13) {
			return TRUE;
		} else {
			return FALSE;
		}
	 }
}
function ipAddress() {
return $_SERVER['REMOTE_ADDR'];
}
function isWeekday($date) {
	$d = date('w', strtotime($date));
 
	if($d != 6 && $d != 0)
		return TRUE;
	else
		return FALSE;
}
function isWeekend($date) {
	$d = date('w', strtotime($date));
 
	if($d == 6 || $d == 0)
		return TRUE;
	else
		return FALSE;
}
function shortDate($date) {
	if(!is_date($date)) return false;
	return date('Y/m/d', strtotime($date));
}
function displayLongDate($date) {
	if(!is_date($date)) return false;
return date('D jS F, Y h:ia', strtotime($date));
}
function showShortDate($date) {
	if(!is_date($date)) return false;
	return date('d/m/Y', strtotime($date));
}
function showLongDate($date) {
	if(!is_date($date)) return false;
	return date('d/m/Y h:ia', strtotime($date));
}
function is_date($date){
	if(!$date || empty($date) || $date == '0000-00-00' || $date == '0000-00-00 00:00:00' || $date == '00/00/0000') return false;
	return true;
}
function no_date($date){
	if(!$date || empty($date) || $date == '0000-00-00' || $date == '0000-00-00 00:00:00' || $date == '00/00/0000') return true;
	return false;
}
function insert_datepicker($date = FALSE, $strict = FALSE){
	//input date dd/mm/yyyy
	//output yyyy-mm-dd
	if($strict && no_date($date)) return date("Y-m-d");
	if(!$strict && no_date($date)) return date("Y-m-d");
	$Date = explode('/', $date);
	if(empty($Date[0]) || empty($Date[1]) || empty($Date[2])) return date("Y-m-d");
	if((int)$date[0] == 0 && (int)$date[1]==0 && (int)$date[2]==0) return date("Y-m-d");
	return $Date[2] . '-' . $Date[1] . '-' . $Date[0];
}
function display_datepicker($date = FALSE, $strict = FALSE){
	//input yyyy-mm-dd
	//output date dd/mm/yyyy
	if($strict && no_date($date)) return date("d/m/Y");
	if(!$strict && no_date($date)) return '';
	if(strpos($date, '/') !== false) return $date;	
	$date = explode('-', $date);
	if((int)$date[0] == 0 && (int)$date[1]==0 && (int)$date[2]==0) return '';
	if(empty($date[0]) || empty($date[1]) || empty($date[2])) return date("d/m/Y");
	return $date[2] . '/' . $date[1] . '/' . $date[0];
}
function set_session($index = FALSE, $value = array()){
	$CI = &get_instance();
	if($index){
		if(is_string($index)){
			$_SESSION[$index] = $value;
			//$CI->session->set_userdata($index, $value);
			return TRUE;
		}
		if(is_array($index)){
			foreach($index as $key=>$data){
				$_SESSION[$key] = $data;
			}
			//$CI->session->set_userdata($index);
			return TRUE;
		}
	}
	return FALSE;
}
function get_session($key = false){
	$CI = &get_instance();
	if(empty($key)) return false;
	if($key && array_key_exists($key, $_SESSION)){
		return $_SESSION[$key];
	}
	
	return FALSE;
}
function delete_sesion($key = false){
	$CI = &get_instance();
	if(empty($key)) return false;
	if($key && array_key_exists($key, $_SESSION)){
		unset($_SESSION[$key]);
		return TRUE;
	}
	return FALSE;
}
function destroy_session(){
	$CI = &get_instance();
	session_destroy();
	return TRUE;
}
function php_file_upload_error($error_code){
	if($error_code === 0) return FALSE;
	$php_file_upload_error = array(
     0 => 'There is no error, the file uploaded with success',
     1 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini',
     2 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form',
     3 => 'The uploaded file was only partially uploaded',
     4 => 'No file was uploaded',
     6 => 'Missing a temporary folder',
     7 => 'Failed to write file to disk.',
     8 => 'A PHP extension stopped the file upload.',
 ); 
 return $php_file_upload_error[$error_code];
}
if(!function_exists('get_file_size')){
	function get_file_size($size = false) { 
	if (!$size<>'') return '0KB';
		$kb = 1; 
		$mb = 1024; 
		$gb = 1024 * $mb; 
		$tb = 1024 * $gb; 
			 
				if ($size < $kb) { 
					$file_size = $size . "Bytes"; 
				} elseif ($size < $mb) { 
					$final = round($size/$kb,2); 
					$file_size = $final . "KB"; 
				} elseif ($size < $gb) { 
					$final = round($size/$mb,2); 
					$file_size = $final . "MB"; 
				} elseif($size < $tb) { 
					$final = round($size/$gb,2); 
					$file_size = $final . "GB"; 
				} else { 
					$final = round($size/$tb,2); 
					$file_size = $final . "TB"; 
				} 
				return $file_size; 
	} 
}
function file_size_to_byte($file_size = false, $unit = 'mb') { 
	if ( !$file_size ) return '0';
		$unit = strtolower($unit);
		
		switch ( $unit ){
			case 'kb': return $file_size * 1024;  
			case 'mb': return $file_size * 1024 * 1024;  
			case 'gb': return $file_size * 1024 * 1024 * 1024;  
			case 'tb': return $file_size * 1024 * 1024 * 1024 * 1024;  
		}
		return $file_size; 
}
function get_extension($filename) {
	$x = explode('.', $filename);
		return '.'.strtolower(end($x));
	}
function unlink_files($files){
	if(!empty($files)){
		foreach($files AS $file){
			if(file_exists($file)){
				unlink($file);	
			}
		}	
	}
}
function get_banks($code = false){
	$banks = array(
		"044" => "Access Bank",
		"401" => "ASO Savings and Loans",
		"023" => "CitiBank",
		"551" => "Covenant Microfinance Bank",
		"063" => "Diamond Bank",
		"050" => "Ecobank Plc",
		"084" => "Enterprise Bank",
		"070" => "Fidelity Bank",
		"318" => "Fidelity Mobile",
		"011" => "First Bank of Nigeria",
		"214" => "First City Monument Bank",
		"601" => "FSDH Merchant Bank",
		"058" => "GTBank Plc",
		"030" => "Heritage",
		"301" => "JAIZ Bank",
		"082" => "Keystone Bank",
		"526" => "Parallex Microfinance Bank",
		"101" => "Providus Bank",
		"076" => "Skye Bank",
		"221" => "Stanbic IBTC Bank",
		"068" => "Standard Chartered Bank",
		"232" => "Sterling Bank",
		"100" => "SunTrust Bank",
		"032" => "Union Bank",
		"033" => "United Bank for Africa",
		"215" => "Unity Bank",
		"035" => "Wema Bank",
		"057" => "Zenith Bank",
		);
	if(empty($code)) return $banks;
	return array_key_exists($code, $banks) ? $banks[$code] : false;
}	
function convertAmountToWord($number, $naira = ' naira', $kobo = ' kobo'){
	$amount = explode(".", (string) $number);
	$integer = str_replace(',','', $amount[0]);
	$fraction = !empty($amount[1]) ? $amount[1] : 0;

    $output = "";

    if ($integer{0} == "-")
    {
        $output = "negative ";
        $integer    = ltrim($integer, "-");
    }
    else if ($integer{0} == "+")
    {
        $output = "positive ";
        $integer    = ltrim($integer, "+");
    }

    if ($integer{0} == "0")
    {
        $output .= "zero";
    }
    else
    {
        $integer = str_pad($integer, 36, "0", STR_PAD_LEFT);
        $group   = rtrim(chunk_split($integer, 3, " "), " ");
        $groups  = explode(" ", $group);

        $groups2 = array();
        foreach ($groups as $g)
        {
            $groups2[] = convertThreeDigit($g{0}, $g{1}, $g{2});
        }

        for ($z = 0; $z < count($groups2); $z++)
        {
            if ($groups2[$z] != "")
            {
                $output .= $groups2[$z] . convertGroup(11 - $z) . (
                        $z < 11
                        && !array_search('', array_slice($groups2, $z + 1, -1))
                        && $groups2[11] != ''
                        && $groups[11]{0} == '0'
                            ? " and "
                            : ", "
                    );
            }
        }

        $output = rtrim($output, ", ") . $naira;
    }

    if ($fraction > 0)
    {
        $output .= ",";
        for ($i = 0; $i < strlen($fraction); $i++)
        {
            $output .= " " . convertDigit($fraction{$i});
        }
		$output .= $kobo;
    }

    return $output;
}
function convertGroup($index){
    switch ($index)
    {
        case 11:
            return " decillion";
        case 10:
            return " nonillion";
        case 9:
            return " octillion";
        case 8:
            return " septillion";
        case 7:
            return " sextillion";
        case 6:
            return " quintrillion";
        case 5:
            return " quadrillion";
        case 4:
            return " trillion";
        case 3:
            return " billion";
        case 2:
            return " million";
        case 1:
            return " thousand";
        case 0:
            return "";
    }
}
function convertThreeDigit($digit1, $digit2, $digit3){
    $buffer = "";

    if ($digit1 == "0" && $digit2 == "0" && $digit3 == "0")
    {
        return "";
    }

    if ($digit1 != "0")
    {
        $buffer .= convertDigit($digit1) . " hundred";
        if ($digit2 != "0" || $digit3 != "0")
        {
            $buffer .= " and ";
        }
    }

    if ($digit2 != "0")
    {
        $buffer .= convertTwoDigit($digit2, $digit3);
    }
    else if ($digit3 != "0")
    {
        $buffer .= convertDigit($digit3);
    }

    return $buffer;
}
function convertTwoDigit($digit1, $digit2){
    if ($digit2 == "0")
    {
        switch ($digit1)
        {
            case "1":
                return "ten";
            case "2":
                return "twenty";
            case "3":
                return "thirty";
            case "4":
                return "forty";
            case "5":
                return "fifty";
            case "6":
                return "sixty";
            case "7":
                return "seventy";
            case "8":
                return "eighty";
            case "9":
                return "ninety";
        }
    } else if ($digit1 == "1")
    {
        switch ($digit2)
        {
            case "1":
                return "eleven";
            case "2":
                return "twelve";
            case "3":
                return "thirteen";
            case "4":
                return "fourteen";
            case "5":
                return "fifteen";
            case "6":
                return "sixteen";
            case "7":
                return "seventeen";
            case "8":
                return "eighteen";
            case "9":
                return "nineteen";
        }
    } else
    {
        $temp = convertDigit($digit2);
        switch ($digit1)
        {
            case "2":
                return "twenty-$temp";
            case "3":
                return "thirty-$temp";
            case "4":
                return "forty-$temp";
            case "5":
                return "fifty-$temp";
            case "6":
                return "sixty-$temp";
            case "7":
                return "seventy-$temp";
            case "8":
                return "eighty-$temp";
            case "9":
                return "ninety-$temp";
        }
    }
}
function convertDigit($digit){
    switch ($digit)
    {
        case "0":
            return "zero";
        case "1":
            return "one";
        case "2":
            return "two";
        case "3":
            return "three";
        case "4":
            return "four";
        case "5":
            return "five";
        case "6":
            return "six";
        case "7":
            return "seven";
        case "8":
            return "eight";
        case "9":
            return "nine";
    }
}
