<?php
defined('BASEPATH') or exit('No direct script access allowed');
$naira = '&#8358;';
$banks = get_banks();
?>
<!doctype html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <base href="<?php echo base_url(); ?>" />
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="shortcut icon" type="image/png" href="images/icon.png" />

  <!-- Designed by Prince Morpheus Productions (c) 2020. All rights reserved -->
  <meta name="Author" content="Prince Morpheus Prodctions Limited (Lagos, Nigeria)" />
  <meta name="Telephone" content="Tel: +234(0)8090956548, 08120820076, 08073648077" />
  <meta name="Email" content="prince@princemorpheus.net" />
  <meta name="AltEmail" content="princemorpheus@gmail.com" />
  <meta name="Website" content="http://www.princemorpheus.net" />

  <link rel="stylesheet" href="assets/css/font-awesome-4.7.0/css/font-awesome.css">
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" type="text/css" href="assets/bootstrap-4.3.1/css/bootstrap.min.css">
  <link rel="stylesheet" type="text/css" href="assets/bootstrap-4.3.1/css/bootstrap.theme.min.css">
  <link rel="stylesheet" href="assets/js/bootstrap-datepicker-1.6.4/css/bootstrap-datepicker.min.css" />
  <link href="assets/js/alertifyjs/css/alertify.min.css" rel="stylesheet">
  <link href="assets/js/alertifyjs/css/themes/default.min.css" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="assets/css/w3.css">
  <link rel="stylesheet" type="text/css" href="assets/css/utility.css">

  <title><?php echo _SUKUK_APP_TITLE; ?></title>
  <style type="text/css">
    ::selection {
      background-color: #E13300;
      color: white;
    }

    ::-moz-selection {
      background-color: #E13300;
      color: white;
    }

    body {
      background-color: #FCFCFC;
      margin: 0px;
      font: 14px/20px normal Helvetica, Arial, sans-serif;
      color: #4F5155;
    }

    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
      color: #F05A40;
    }

    h4 {
      color: #F05A40;
    }

    header {
      text-align: center;
    }

    #body {
      margin: 0 15px 0 15px;
    }

    p.footer {
      text-align: right;
      font-size: 11px;
      border-top: 1px solid #D0D0D0;
      line-height: 32px;
      padding: 0 10px 0 10px;
      margin: 20px 0 0 0;
    }

    #containerx {
      margin: 10px;
      border: 1px solid #D0D0D0;
      box-shadow: 0 0 8px #D0D0D0;
    }

    .topbar {
      background-color: #F05A40;
      min-height: 10px;
      width: 100%;
    }

    .mandatory {
      color: #FF0000;
      font-weight: bold;
    }

    .failed_validate {
      color: #FF0000;
      border-color: #FF0000;
    }

    .g-recaptcha>div {
      margin-left: auto;
      margin-right: auto;
    }
  </style>
</head>

<body>
  <div class="topbar mb-4"></div>
  <div id="container" class="container">
    <div class="row">
      <div class="col col-md-8 offset-md-2">
        <div id="coat-of-arms" class="w3-center mb-5"><img src="images/coat-of-arms.png" width="100" alt="" /></div>
        <header><?php echo get_form_title(); ?></header>
      </div>
    </div>
    <div id="body">
      <div class="row" style="display:nonex;">
        <!-- instruction-box -->
        <!-- Remove display: none for this element to be default -->
        <div class="instruction-box col col-md-8 offset-md-2" style="display:nonex;">
          <p class="text-center mb-4 size15">Applications must be made in accordance with the instructions set out below.
            Care must be taken to follow these instructions as applications that do not comply with the instructions may be rejected.
            Please consult your Financial or Legal Advisers for guidance before completing this Form.</p>
          <div class="mb-4" style="margin: auto; border-bottom: solid 1px #BDBDBD; width: 40%;"></div>
          <h3 class="text-center mt-4 mb-3">INSTRUCTIONS FOR COMPLETING THE APPLICATION FORM</h3>
          <ol>
            <li>Applications must be made only on the official form as prescribed by the FGN Roads Sukuk Company 1 Plc.</li>
            <li>Applications must be for a minimum of N10,000.00 and thereafter, in multiples of N1,000.00. The value of the Sukuk applied for should be entered in the appropriate box.</li>
            <li>The Application Form, when completed, should be lodged with the Financial Advisers or Placement Agents. Applications must be accompanied by full payment for the amount applied for, which must be paid to the Receiving Banks at the time of submission.</li>
            <li>Applicants should note that No Charges or Fees would be paid by investors.</li>
            <li>For the purpose of this application, residency classification refers to the country where the Applicant(s) permanently resides as at the time of filling the Application Form, Applicant(s) must indicate his/their residency classification in the appropriate box provided.</li>
            <li>For joint applications, information on the Applicants should be provided in the appropriate boxes. However, all correspondence will be addressed to the first named Applicant.</li>
            <li>An application form from a group of individuals should be made in the names of those individuals with no mention of the names of the group. </li>
            <li>An application by a firm, which is not registered under the Companies and Allied Matters Act, should be made either in the name of the proprietor or in the names of the individual partners. In neither case should the name of the firm be mentioned.</li>
            <li>An application from a corporation must bear the corporate body’s seal and be signed in accordance with the company’s signature mandate by duly authorized officials. A corporate stamp may be used where the corporate seal is not available.</li>
            <li>An application from a pension or provident fund must be in line with the guidelines of the National Pension Commission with regard to the custody of the pension assets.</li>
            <li>An application by an illiterate person should bear his right thumb print on the Subscription Form and be witnessed by an official of the Financial Adviser or Bank at which the application is lodged, who must first have explained the meaning and effect of the application to the illiterate person in his own language. The witness should indicate his name and signature in the appropriate box.</li>
            <li>The applicant should not print his signature. If he is unable to sign in the normal manner he should be treated for the purpose of this offer as an illiterate and his right thumb should be clearly impressed on the Subscription Form.</li>
            <li>The applicant should not print his signature. If he is unable to sign in the normal manner he should be treated for the purpose of this offer as an illiterate and his right thumb should be clearly impressed on the Subscription Form.</li>
          </ol>
          <div class="text-center mt-5">
            <button type="button" class="btn btn-danger btn-lg form-box-link">CLICK HERE TO APPLY</button>
          </div>
        </div>
        <!-- instruction-link-box -->
        <div class="instruction-link-box col col-md-8 offset-md-2 mt-4 mb-4" style="display:none;">
          <h6 class="text-center"><a class="instruction-link" href="#">INSTRUCTIONS FOR COMPLETING THE APPLICATION FORM</a></h6>
        </div>
      </div>

      <div class="row form-box" style="display:none;">
        <div class="col-md-10 offset-md-1">
          <form id="sukukForm" method="POST">
            <!-- Pre application -->
            <div id="PaymentMethod" class="row" style="display:nonex;">
              <div class="col col-md-8 offset-md-2">
                <div class="mb-4" style="margin: auto; border-bottom: solid 1px #BDBDBD; width: 40%;"></div>
                <h5 class="text-center mt-4 mb-3">PAYMENT METHOD</h5>
                <div class="row equalHeightBox">
                  <div class="col-sm-6">
                    <label class="cursor box d-block mb-3 px-5 py-4 w3-border w3-round-xlarge w3-hover-light-grey">
                      <input type="radio" value="deposit" name="payment_method" class="w3-radio payment_method mr-3" />
                      <h6>I already made a bank deposit</h6>
                      <p class="mt-3 size15">You will be required to upload a proof of payment and provide your payment reference</p>
                    </label>
                  </div>
                  <div class="col-sm-6">
                    <label class="cursor box d-block mb-3 px-5 py-4 w3-border w3-round-xlarge w3-hover-light-grey">
                      <input type="radio" value="online" name="payment_method" class="w3-radio payment_method mr-3" />
                      <h6>I will pay online</h6>
                      <p class="mt-3  size15">You will be able to make payment after completing this application</p>
                    </label>
                  </div>
                </div>
                <div class="text-center mt-5">
                  <button type="button" class="btn btn-danger btn-lg payment-select-confirm mb-5">PROCEED</button>
                </div>
              </div>
            </div>

            <!-- Payment proof upload -->
            <div id="PaymentProofForm" class="w3-content width500" style="max-width: 98%; display:none;">
              <h3 class="text-center mt-4 mb-3">UPLOAD PROOF OF PAYMENT</h3>
              <p class="text-center mb-4 size15">Please upload your proof of payment</p>
              <div class="form-group row">
                <label class="col-sm-4 col-form-label">Payment Receipt</label>
                <div class="col-sm-8">
                  <input name="payment_slip" type="file" id="payment_slip" class="form-control-file form-control-lg cursor w3-border w3-round-xxlarge">
                  <p>Bank teller/Online payment generated receipt</p>
                </div>
              </div>
              <div class="form-group row">
                <label class="col-sm-4 col-form-label">Transaction Reference</label>
                <div class="col-sm-8">
                  <input name="transaction_reference" type="text" id="transaction_reference" class="form-control form-control-lg">
                </div>
              </div>
              <div class="text-center my-5">
                <button type="button" class="btn btn-danger btn-lg w3-light-grey back-to-method">BACK</button>
                <button type="button" class="btn btn-danger btn-lg confirm-payment-proof">PROCEED</button>
              </div>
            </div>


            <div id="AppForm" style="display: none;">
              <p class="text-center col-md-10 offset-md-1">In response to the advertisement in both print and electronic media, I/We hereby offer my/our subscription for FGN Sukuk</p>
              <div id="responseBox" class="col-md-8 offset-md-2 p-5 mt-4 mb-4" style="display:none;"></div>
              <div class="card bg-light mb-5 w3-card-2">
                <div class="card-header w3-border-orange">
                  <h4 class="float-sm-left mr-3">Guide to Applications</h4>
                  <h4 class="float-sm-right"><span class="w3-text-grey font-weight-normal size15">Application Date:</span> <strong class=""><?php echo date("d/m/Y"); ?></strong></h4>
                </div>
                <div class="card-body w3-white">
                  <div class="form-row mb-0">
                    <div class="form-group col-md-7">
                      <label for="amount" class="size18">Value of Sukuk Applied for <span class="mandatory">*</span></label>
                      <div class="input-group mb-0 max-width350">
                        <div class="input-group-prepend">
                          <span class="input-group-text bold size30 " id="basic-addon1">‎<?php echo $naira; ?></span>
                        </div>
                        <input type="text" id="amount" name="InvestmentValue" placeholder="" maxlength="19" class="form-control form-control-lg w3-padding-large size30 currency validateAmount" aria-label="Amount" aria-describedby="basic-addon1">
                      </div>

                    </div>
                    <div class="form-group col-md-5">

                      <p class="mt-4 p-0 w3-text-orange size18" style="line-height: 24px;">
                        Minimum Value: <span class="font-weight-bold"><?php echo $naira . number_format($sukuk_min_amount, 2); ?></span><br>
                        Multiples thereafter: <span class="font-weight-bold"><?php echo $naira . number_format($sukuk_multiple, 2); ?></span>
                      </p>
                    </div>
                  </div>
                  <div class="spinner" style="display:none;"><img src="images/spinner.gif" width="40" alt="" /></div>
                  <div id="amount_in_words_box" class="form-row mb-0" style="display:none;">
                    <div class="form-group col">
                      <label for="amount_in_words">Amount in words</label>
                      <p id="amount_in_words_p" class="mt-0 mb-0 p-0 font-weight-bold w3-white size15"></p>
                      <input type="hidden" class="_amount_in_words" value="" name="_amount_in_words" id="amount_in_words" placeholder="">
                    </div>
                  </div>
                </div>
              </div>
              <div class="card bg-light mb-5 w3-card-2">
                <div class="card-header w3-border-orange">
                  <h4>E-allotment Details</h4>
                </div>
                <div class="card-body w3-white">
                  <div class="form-row">
                    <div class="form-group col-md-4 mb-0">
                      <label class="size13" for="S4_Custodian">Applicant’s S4/Custodian A/C No.</label>
                      <input type="text" class="form-control max-width250" id="S4_Custodian" name="S4_Custodian">
                    </div>
                    <div class="form-group col-md-4">
                      <label class="size13" for="CustodianAccount">Applicant’s CSCS A/C No.</label>
                      <input type="text" class="form-control max-width250" id="CustodianAccount" name="CustodianAccount">
                    </div>
                    <div class="form-group col-md-4">
                      <label class="size13" for="CHN">Applicant’s Clearing House No. (CHN)</label>
                      <input type="text" class="form-control max-width250" id="CHN" name="CHN">
                    </div>
                  </div>
                </div>
              </div>
              <div class="card bg-light mb-5 w3-card-2">
                <div class="card-header w3-border-orange">
                  <h4>Applicants Details</h4>
                </div>
                <div class="card-body w3-white">
                  <h5>Select an applicant type <span class="mandatory">*</span></h5>
                  <div class="form-row">
                    <div class="form-group col-md-4">
                      <input id="individual_applicant" name="AccountType" class="w3-radio applicant_type" type="radio" value="individual">
                      <label class="form-check-label cursor" for="individual_applicant">Individual Applicants</label>
                    </div>
                    <div class="form-group col-md-4">
                      <input id="joint_applicant" name="AccountType" class="w3-radio applicant_type" type="radio" value="joint">
                      <label class="form-check-label cursor" for="joint_applicant">Joint Applicants</label>
                    </div>
                    <div class="form-group col-md-4">
                      <input id="corporate_applicant" name="AccountType" class="w3-radio applicant_type" type="radio" value="corporate">
                      <label class="form-check-label cursor" for="corporate_applicant">Corporate Applicants</label>
                    </div>
                  </div>

                  <div class="mt-5 individual_applicant_tab" style="display:none;">
                    <h3 class="mb-4 individual_applicant_title" style="display:none;">Individual Applicant</h3>
                    <h3 class="mb-4 joint_applicant_title" style="display:none;">Joint Applicant</h3>
                    <h6 class="d-block mb-4 bold text-uppercase primary-applicant-title">Applicant Detail</h6>
                    <div class="p-4 border">
                      <div class="form-row">
                        <div class="form-group col-md-2">
                          <label for="Title">Title <span class="mandatory">*</span></label>
                          <input type="text" id="Title" name="Title" class="form-control declarer_name">
                        </div>
                        <div class="form-group col-md-10">
                          <div class="form-row">
                            <div class="form-group col-md-4">
                              <label for="Surname">Surname <span class="mandatory">*</span></label>
                              <input type="text" id="Surname" name="Surname" class="form-control validateRequired declarer_name">
                            </div>
                            <div class="form-group col-md-4">
                              <label for="FirstName">Firstname <span class="mandatory">*</span></label>
                              <input type="text" id="FirstName" name="FirstName" class="form-control validateRequired declarer_name">
                            </div>
                            <div class="form-group col-md-4">
                              <label for="OtherName">Othername</label>
                              <input type="text" id="OtherName" name="OtherName" class="form-control declarer_name">
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-4">
                          <label for="Occupation">Occupation</label>
                          <input type="text" id="Occupation" name="Occupation" class="form-control">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="Email">Email address <span class="mandatory">*</span></label>
                          <input type="email" id="Email" name="Email" class="form-control validateEmail">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="PhoneNo">Telephone <span class="mandatory">*</span></label>
                          <input type="text" id="PhoneNo" name="PhoneNo" class="form-control validateTelephone">
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-7">
                          <label for="Address">Address <span class="mandatory">*</span></label>
                          <input type="text" id="Address" name="Address" class="form-control">
                        </div>

                        <div class="form-group col-md-5">
                          <div class="form-row">
                            <div class="form-group col-md-6">
                              <label for="ID_Type" class="control-label">Identification Type</label>
                              <select id="ID_Type" name="ID_Type" class="form-control">
                                <option value=""></option>
                                <option value="Driver Licence">Driver's Licence</option>
                                <option value="Passport">International Passport</option>
                                <option value="National ID">National ID. Card</option>
                              </select>
                            </div>

                            <div class="form-group col-md-6">
                              <label for="IDNo">Identification No: </label>
                              <input type="text" id="IDNo" name="IDNo" class="form-control">
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-4">
                          <label for="NextOfKin">Next of Kin</label>
                          <input type="text" id="NextOfKin" name="NextOfKin" class="form-control">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="MotherMaidenName">Mother’s Maiden Name</label>
                          <input type="text" id="MotherMaidenName" name="MotherMaidenName" class="form-control">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="DOB">Date of Birth <span class="mandatory">*</span></label>
                          <?php echo date_field('DOB'); ?>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-4">
                          <label for="Bank">Bank name <span class="mandatory">*</span></label>
                          <select id="Bank" name="Bank" class="form-control validateRequired">
                            <option value=""></option>
                            <?php if (!empty($banks)) { ?>
                              <?php foreach ($banks as $code => $bank) { ?>
                                <option value="<?php echo $bank; ?>"><?php echo $bank; ?></option>
                              <?php } ?>
                            <?php } ?>
                          </select>
                        </div>
                        <div class="form-group col-md-4">
                          <label for="BankAccount">Bank Account No. <span class="mandatory">*</span></label>
                          <input type="text" id="BankAccount" name="BankAccount" class="form-control validateNumeric">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="BVN">BVN <span class="mandatory">*</span></label>
                          <input type="text" id="BVN" name="BVN" class="form-control validateNumeric">
                        </div>
                      </div>
                      <div class="form-group">
                        <h5 class="">Residency classification of Applicant </h5>
                        <div class="form-row">
                          <div class="form-group col-md-4">
                            <input id="residency_resident" name="Residency" class="w3-radio" type="radio" value="resident">
                            <label class="form-check-label cursor" for="residency_resident">Resident</label>
                          </div>
                          <div class="form-group col-md-4">
                            <input id="residency_nonresident" name="Residency" class="w3-radio" type="radio" value="non resident">
                            <label class="form-check-label cursor" for="residency_nonresident">Non-Resident</label>
                          </div>
                        </div>
                        <p>(Residency classification of Applicant must be indicated)</p>
                      </div>
                    </div>
                  </div>

                  <div class="mt-5 joint_applicant_tab" style="display:none;">
                    <h6 class="mb-4 bold text-uppercase">Joint Applicant Detail</h6>
                    <div class="p-4 border">
                      <div class="form-row">
                        <div class="form-group col-md-2">
                          <label for="ja_title">Title <span class="mandatory">*</span></label>
                          <input type="text" id="ja_title" name="_ja_title" class="form-control">
                        </div>
                        <div class="form-group col-md-10">
                          <div class="form-row">
                            <div class="form-group col-md-4">
                              <label for="ja_surname">Surname <span class="mandatory">*</span></label>
                              <input type="text" id="ja_surname" name="_ja_surname" class="form-control validateRequiredJoint">
                            </div>
                            <div class="form-group col-md-4">
                              <label for="ja_firstname">Firstname <span class="mandatory">*</span></label>
                              <input type="text" id="ja_firstname" name="_ja_firstname" class="form-control validateRequiredJoint">
                            </div>
                            <div class="form-group col-md-4">
                              <label for="ja_otherName">Othername</label>
                              <input type="text" id="ja_otherName" name="_ja_otherName" class="form-control">
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-4">
                          <label for="Occupation2">Occupation</label>
                          <input type="text" id="Occupation2" name="Occupation2" class="form-control">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="EmailAddress2">Email address <span class="mandatory">*</span></label>
                          <input type="email" id="EmailAddress2" name="EmailAddress2" class="form-control validateEmailJoint">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="Phone_No2">Telephone <span class="mandatory">*</span></label>
                          <input type="text" id="Phone_No2" name="Phone_No2" class="form-control validateTelephoneJoint">
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-7">
                          <label for="Address2">Address <span class="mandatory">*</span></label>
                          <input type="text" id="Address2" name="Address2" class="form-control">
                        </div>
                        <div class="form-group col-md-5">
                          <div class="form-row">
                            <div class="form-group col-md-6">
                              <label for="ID_Type2" class="control-label">Identification Type</label>
                              <select id="ID_Type2" name="ID_Type2" class="form-control">
                                <option value=""></option>
                                <option value="Driver Licence">Driver's Licence</option>
                                <option value="Passport">International Passport</option>
                                <option value="National ID">National ID. Card</option>
                              </select>
                            </div>

                            <div class="form-group col-md-6">
                              <label for="IDNo2">Identification No: </label>
                              <input type="text" id="IDNo2" name="IDNo2" class="form-control">
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-4">
                          <label for="ja_next_of_kin">Next of Kin</label>
                          <input type="text" id="ja_next_of_kin" name="_ja_next_of_kin" class="form-control">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="MotherMaidName2">Mother’s Maiden Name</label>
                          <input type="text" id="MotherMaidName2" name="MotherMaidName2" class="form-control">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="DOB2">Date of Birth <span class="mandatory">*</span></label>
                          <?php echo date_field('DOB2'); ?>
                          <!--<div class="input-group max-width150">
                      <div class="input-group-prepend">
                        <span class="input-group-text">‎<i class="fa fa-calendar"></i></span>
                      </div>
                      <input type="text" id="DOB2" name="DOB2" class="form-control date-picker validateRequiredJoint">
                    </div>-->
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-4">
                          <label for="Bank2">Bank name <span class="mandatory">*</span></label>
                          <select id="Bank2" name="Bank2" class="form-control validateRequiredJoint">
                            <option value=""></option>
                            <?php if (!empty($banks)) { ?>
                              <?php foreach ($banks as $code => $bank) { ?>
                                <option value="<?php echo $bank; ?>"><?php echo $bank; ?></option>
                              <?php } ?>
                            <?php } ?>
                          </select>
                        </div>
                        <div class="form-group col-md-4">
                          <label for="BankAccount2">Bank Account No. <span class="mandatory">*</span></label>
                          <input type="text" id="BankAccount2" name="BankAccount2" class="form-control validateNumericJoint">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="BVN2">BVN <span class="mandatory">*</span></label>
                          <input type="text" id="BVN2" name="BVN2" class="form-control">
                        </div>
                        <?php /*?> <div class="form-group col-md-4">
                    <label for="ja_signature">Usual Signature <span class="size12">(Upload your signature)</span> <span class="mandatory">*</span></label>
                    <input type="file" id="ja_signature" name="ja_signature" class="form-control validateRequiredJoint">
                 </div><?php */ ?>
                      </div>
                      <div class="form-group">
                        <h5 class="">Residency classification of Applicant </h5>
                        <div class="form-row">
                          <div class="form-group col-md-4">
                            <input id="ja_residency_resident" name="_ja_residency" class="w3-radio" type="radio" value="resident">
                            <label class="form-check-label cursor" for="ja_residency_resident">Resident</label>
                          </div>
                          <div class="form-group col-md-4">
                            <input id="ja_residency_nonresident" name="_ja_residency" class="w3-radio" type="radio" value="non resident">
                            <label class="form-check-label cursor" for="ja_residency_nonresident">Non-Resident</label>
                          </div>
                        </div>
                        <p>(Residency classification of Applicant must be indicated)</p>
                      </div>
                    </div>
                  </div>

                  <div class="mt-5 corporate_applicant_tab" style="display:none;">
                    <h3 class="d-inline-block mb-4">Corporate Applicant</h3>
                    <div class="p-4 border">
                      <div class="form-group">
                        <label for="Company_Name">Company name <span class="mandatory">*</span></label>
                        <input type="text" id="Company_Name" name="Company_Name" class="form-control validateRequiredCompany">
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-8">
                          <label for="Type_of_Business">Type of Business</label>
                          <input type="text" id="Type_of_Business" name="Type_of_Business" class="form-control">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="RC_No">RC. No.</label>
                          <input type="text" id="RC_No" name="RC_No" class="form-control">
                        </div>
                      </div>
                      <div class="form-group">
                        <label for="company_address">Address <span class="mandatory">*</span></label>
                        <input type="text" id="company_address" name="_company_address" class="form-control">
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-4">
                          <label for="Contact_Person">Contact Person <span class="mandatory">*</span></label>
                          <input type="text" id="Contact_Person" name="Contact_Person" class="form-control declarer_name">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="company_email">Email address <span class="mandatory">*</span></label>
                          <input type="email" id="company_email" name="_company_email" class="form-control validateEmailCompany">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="company_telephone">Telephone <span class="mandatory">*</span></label>
                          <input type="text" id="company_telephone" name="_company_telephone" class="form-control validateTelephoneCompany">
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="form-group col-md-4">
                          <label for="company_bank_name">Bank name <span class="mandatory">*</span></label>
                          <select id="company_bank_name" name="_company_bank_name" class="form-control validateRequiredCompany">
                            <option value=""></option>
                            <?php if (!empty($banks)) { ?>
                              <?php foreach ($banks as $code => $bank) { ?>
                                <option value="<?php echo $bank; ?>"><?php echo $bank; ?></option>
                              <?php } ?>
                            <?php } ?>
                          </select>
                        </div>
                        <div class="form-group col-md-4">
                          <label for="company_bank_account_no">Bank Account No. <span class="mandatory">*</span></label>
                          <input type="text" id="company_bank_account_no" name="_company_bank_account_no" class="form-control validateNumericCompany">
                        </div>
                        <div class="form-group col-md-4">
                          <label for="company_bvn">BVN <span class="mandatory">*</span></label>
                          <input type="text" id="company_bvn" name="_company_bvn" class="form-control validateNumericCompany">
                        </div>
                        <?php /*?><div class="form-group col-md-4">
                    <label for="company_signature">Signature <span class="mandatory">*</span></label>
                    <input type="file" id="company_signature" name="company_signature" class="form-control validateRequiredCompany">
                 </div><?php */ ?>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div id="investCat" class="card bg-light mb-5 w3-card-2" style="display:none;">
                <div class="card-header w3-border-orange">
                  <h4 class="f">For rental payment purpose</h4>
                </div>
                <div class="card-body w3-white">
                  <h3 class="card-title">Investor Category of Applicant</h3>
                  <div class="card-text mt-3">
                    <div class="form-row">
                      <div class="form-group col-md-6">
                        <div class="form-group mr-3">
                          <input id="invcat_Retail" name="InvestorCategory" class="w3-radio InvestorCategory" type="radio" value="Individual">
                          <label class="form-check-label cursor" for="invcat_Retail">Individual</label>
                        </div>
                        <div class="form-group mr-3">
                          <input id="invcat_Insurance" name="InvestorCategory" class="w3-radio InvestorCategory" type="radio" value="Bank">
                          <label class="form-check-label cursor" for="invcat_Insurance">Bank</label>
                        </div>
                        <div class="form-group mr-3">
                          <input id="invcat_DepositMoneyBanks" name="InvestorCategory" class="w3-radio InvestorCategory" type="radio" value="Corporate">
                          <label class="form-check-label cursor" for="invcat_DepositMoneyBanks">Corporate</label>
                        </div>
                        <div class="form-group mr-3">
                          <input id="invcat_FundManagersNonBankFinancialInstitution" name="InvestorCategory" class="w3-radio InvestorCategory" type="radio" value="Co-operative Society">
                          <label class="form-check-label cursor" for="invcat_FundManagersNonBankFinancialInstitution">Co-operative Society</label>
                        </div>
                        <div class="form-group mr-3">
                          <input id="invcat_ForeignInvestor" name="InvestorCategory" class="w3-radio InvestorCategory" type="radio" value="Foreign Investor">
                          <label class="form-check-label cursor" for="invcat_ForeignInvestor">Foreign Investor</label>
                        </div>

                      </div>
                      <div class="form-group col-md-6">
                        <div class="form-group mr-3">
                          <input id="invcat_GovernmentAgencies" name="InvestorCategory" class="w3-radio InvestorCategory" type="radio" value="Government Agencies">
                          <label class="form-check-label cursor" for="invcat_GovernmentAgencies">Government Agencies</label>
                        </div>
                        <div class="form-group mr-3">
                          <input id="invcat_PensionFunds" name="InvestorCategory" class="w3-radio InvestorCategory" type="radio" value="Staff Scheme">
                          <label class="form-check-label cursor" for="invcat_PensionFunds">Staff Scheme</label>
                        </div>
                        <div class="form-group mr-3">
                          <input id="invcat_EthicalFundManagersNoninterestBanks" name="InvestorCategory" class="w3-radio InvestorCategory" type="radio" value="Non-Bank Financial Institution">
                          <label class="form-check-label cursor" for="invcat_EthicalFundManagersNoninterestBanks">Non-Bank Financial Institution</label>
                        </div>

                        <div class="form-group mr-3">
                          <input id="invcat_OthersInstitutions" name="InvestorCategory" class="w3-radio InvestorCategory" type="radio" value="Others">
                          <label class="form-check-label cursor" for="invcat_OthersInstitutions">Others</label>
                          <div class="form-group ml-5">
                            <label for="InvestorCategoryOrder">Specify</label>
                            <input type="text" id="InvestorCategoryOrder" name="InvestorCategoryOrder" class="form-control mt-2">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div id="submitFormBox" class="text-center" style="display:none;">
                <div class="row">
                  <div class="col mb-5">
                    <div class="mb-2 w3-card-2 w3-light-grey w3-padding-large">
                      <h5 class="bold underline mb-4">DECLARATION AND SIGNATURE</h5>
                      <p>I<span id="declarer_comma" class="" style="display:none;">, </span><span id="declarer" class="bold"></span> declare that the information I have given in this application is truthful, complete and correct.</p>
                      <p>I understand that any error in completing the application form may result in the rejection of my application. I agree that any false information or misrepresentation may constitute an offence under applicable laws in Nigeria</p>
                      <p>I agree that by checking the signature box below, I am electronically signing my application. I absolve the Issuer and its advisers of any defect or liability arising from this electronic superscription hereof</p>
                      <label for="agree" class="size16 bold cursor">
                        <input id="agree" class="w3-check mb-2" type="checkbox" name="agree">
                        I AGREE AND SIGN
                      </label>
                    </div>
                  </div>
                </div>
                <?php if (_SUKUK_ENABLE_CAPTCHA) { ?>
                  <div class="g-recaptcha mb-3" data-sitekey="<?php echo _SUKUK_RECAPTCHA_KEY; ?>"></div>
                <?php } ?>
                <button type="submit" class="btn btn-danger btn-lg">SUBMIT APPLICATION</button>
              </div>
            </div>
          </form>
        </div>

      </div>
    </div>

    <div id="footer"><?php echo get_footer(); ?></div>
  </div>
  <div class="topbar mb-0"></div>
  <script src="assets/js/jquery-3.4.1.min.js"></script>
  <?php if (_SUKUK_ENABLE_CAPTCHA) { ?>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
  <?php } ?>
  <script src="assets/js/num-to-words.js"></script>
  <script src="assets/bootstrap-4.3.1/js/bootstrap.min.js"></script>
  <script src="assets/js/jquery.format-currency-1.4.0/jquery.format-currency-1.4.0.js"></script>
  <script src="assets/js/bootstrap-datepicker-1.6.4/js/bootstrap-datepicker.min.js"></script>
  <script src="assets/js/alertifyjs/alertify.min.js"></script>
  <script src="assets/js/js.js"></script>
  <?php $_SUKUK_MAX_UPLOAD_SIZE = defined('_SUKUK_MAX_UPLOAD_SIZE') ? _SUKUK_MAX_UPLOAD_SIZE : 2; ?>;
  <script>
    var maxUploadSize = <?php echo $_SUKUK_MAX_UPLOAD_SIZE; ?>;

    function equalHeightBox() {
      let isMobile = window.matchMedia('only screen and (max-width: 760px)').matches
      if (!isMobile) {
        $('.equalHeightBox').each(function() {
          var highestBox = 0
          $('.box', this).each(function() {
            if ($(this).height() > highestBox) {
              highestBox = $(this).height()
            }
          })
          $('.box', this).height(highestBox)
        })
      }
    }

    $(".confirm-payment-proof").on("click", function(e) {
      e.preventDefault();
      var payment_slip = $("#payment_slip")[0].files[0]
      var transaction_reference = $("#transaction_reference").val()

      if (typeof payment_slip === "undefined") {
        error("Please select proof of payment for upload")
        return
      }
      if (payment_slip.size > file_size_to_byte(maxUploadSize)) {
        error("File should not be greater than " + maxUploadSize + "mb")
        return
      }
      var allowedFile = ["image/jpeg", "image/png", "application/pdf"]
      if (!allowedFile.includes(payment_slip.type)) {
        error("Only image and PDF files can be uploaded")
        return
      }
      if (!transaction_reference) {
        error("Please provide transaction reference of payment")
        return
      }
      $("#PaymentProofForm").hide()
      $("#AppForm").fadeIn();
    });
    $(".payment-select-confirm").on("click", function(e) {
      e.preventDefault();
      var method = $(".payment_method:checked").val()
      if (!method) {
        error("Please select your method of payment")
        return
      }
      if (method === 'online') {
        $("#PaymentMethod").hide()
        $("#AppForm").fadeIn();
      } else {
        $("#PaymentMethod").hide()
        $("#PaymentProofForm").fadeIn()
      }
    });
    $(".back-to-method").on("click", function() {
      $("#PaymentMethod").fadeIn()
      $("#PaymentProofForm").hide()
      $("#AppForm").hide();
    })

    function isNumeric(n) {
      return !isNaN(parseFloat(n)) && isFinite(n);
    }
    $('.date-picker').datepicker({
      format: "dd/mm/yyyy",
      autoclose: true,
      todayBtn: false,
      todayHighlight: true
    });
    $(".form-box-link").on("click", function(e) {
      e.preventDefault();
      $(".instruction-box").hide();
      $(".instruction-link-box").show();
      $(".form-box").fadeIn();
      // $("#PaymentMethod").fadeIn()
      equalHeightBox()
    });
    $(".instruction-link").on("click", function(e) {
      e.preventDefault();
      $(".instruction-box").fadeIn();
      $(".instruction-link-box").hide();
      $(".form-box").hide();
      $("#PaymentMethod").hide()
    });

    $(".declarer_name").on("change", update_declarer);

    function update_declarer() {
      var Declarer = '';
      var Names = [];

      if ($("#Title").val() !== '') Names.push($("#Title").val());
      if ($("#Surname").val() !== '') Names.push($("#Surname").val());
      if ($("#FirstName").val() !== '') Names.push($("#FirstName").val());
      if ($("#OtherName").val() !== '') Names.push($("#OtherName").val());

      if (Names.length > 0) Declarer = Names.join(' ');

      if ($(".applicant_type:checked").val() === 'corporate') Declarer = $("#Contact_Person").val();
      if (Declarer !== '') {
        $("#declarer_comma").show();
        Declarer = Declarer.toUpperCase();
      }
      $("#declarer").html(Declarer);
    }
    $(".applicant_type").on("change", function() {
      var value = $(this).val();
      var individual_tab = $(".individual_applicant_tab");
      var joint_tab = $(".joint_applicant_tab");
      var corporate_tab = $(".corporate_applicant_tab");
      var individual_applicant_title = $(".individual_applicant_title");
      var joint_applicant_title = $(".joint_applicant_title");
      if (value === 'individual') {
        if (!individual_tab.is(":visible")) individual_tab.fadeIn();
        joint_tab.hide();
        corporate_tab.hide();
        individual_applicant_title.show();
        joint_applicant_title.hide();
        $(".primary-applicant-title").html("Applicant Detail");
      } else if (value === 'joint') {
        if (!individual_tab.is(":visible")) individual_tab.fadeIn();
        if (!joint_tab.is(":visible")) joint_tab.fadeIn();
        corporate_tab.hide();
        individual_applicant_title.hide();
        joint_applicant_title.show();
        $(".primary-applicant-title").html("Primary Applicant Detail");
      } else if (value === 'corporate') {
        individual_tab.hide();
        joint_tab.hide();
        if (!corporate_tab.is(":visible")) corporate_tab.fadeIn();
        individual_applicant_title.hide();
        joint_applicant_title.hide();
      }
      update_declarer();
      $("#investCat").fadeIn();
      $("#submitFormBox").fadeIn();
    });
    $("#amount").on("change", function() {
      var amount = $(this).asNumber();
      $("#amount_in_words").val('');
      $("#amount_in_words_p").html('');
      $("#amount_in_words_box").hide();
      if (amount === '') return false;

      $(".spinner").show();
      $.ajax({
        url: "<?php echo site_url('api/amount_in_words'); ?>",
        type: 'GET',
        dataType: "html",
        contentType: false,
        processData: false,
        async: true,
        data: "amount=" + amount,
        error: function(response) {
          hideIndicator();
          error("An error occurred. Check your internet connection.");
        },
        success: function(data) {
          hideIndicator();
          console.log(data);
          var Data = parseFromApi(data);
          if (Data) {
            var words = Data.result;
            $(".spinner").hide();
            $("#amount_in_words").val(words);
            $("#amount_in_words_p").html(words);
            $("#amount_in_words_box").show();
          }
        }
      });
    });
    $("#sukukForm").on("submit", function(e) {
      e.preventDefault();
      var AccountType = $(".applicant_type:checked").val();

      if (!($("#agree").is(":checked"))) {
        error("You must agree to the form declaration");
        return;
      }
      var min_amount = parseFloat(<?php echo $sukuk_min_amount; ?>);

      var amount = $("#amount").asNumber();
      if (amount < min_amount) {
        error("Value of Sukuk Applied for must be minimum of N<?php echo number_format($sukuk_min_amount, 2); ?>");
        return;
      };
      if (amount % parseFloat(<?php echo $sukuk_multiple; ?>) > 0) {
        error("Value of Sukuk Applied for must be in multiples of <?php echo number_format($sukuk_multiple, 2); ?>");
        return;
      };
      if (amount === '') {
        error("Please enter Value of Sukuk Applied for");
        return;
      }
      if (AccountType === 'individual' || AccountType === 'joint') {
        var Title = $("#Title").val();
        var Surname = $("#Surname").val();
        var FirstName = $("#FirstName").val();
        var Email = $("#Email").val();
        var PhoneNo = $("#PhoneNo").val();
        var Address = $("#Address").val();
        var DOB_dd = $("#DOB_dd").val();
        var DOB_mm = $("#DOB_mm").val();
        var DOB_yy = $("#DOB_yy").val();

        if (DOB_dd === '') {
          error("Applicant's Day of birth is required");
          return;
        }
        if (DOB_mm === '') {
          error("Applicant's Month of birth is required");
          return;
        }
        if (DOB_yy === '') {
          error("Applicant's Year of birth is required");
          return;
        }

        var DOB = DOB_yy + '-' + DOB_mm + '-' + DOB_dd;

        var Bank = $("#Bank").val();
        var BankAccount = $("#BankAccount").val();
        var BVN = $("#BVN").val();

        if (Title === '') {
          error("Title is required");
          return;
        }
        if (Surname === '') {
          error("Applicant's Surname is required");
          return;
        }
        if (FirstName === '') {
          error("Applicant's Firstname is required");
          return;
        }
        if (Email === '') {
          error("Applicant's email address is required");
          return;
        }
        if (PhoneNo === '') {
          error("Applicant's Telephone number is required");
          return;
        }
        if (Address === '') {
          error("Applicant's Address is required");
          return;
        }
        if (Bank === '') {
          error("Applicant's Bank name is required");
          return;
        }
        if (BankAccount === '' || !isNumeric(BankAccount) || BankAccount.length !== 10) {
          error("Applicant's Bank Account is invalid. Must be 10 digits");
          return;
        }
        if (BVN === '' || !isNumeric(BVN) || BVN.length !== 11) {
          error("Applicant's BVN is invalid. Must be 11 digits");
          return;
        }

        if (AccountType === 'joint') {
          var Title2 = $("#ja_title").val();
          var Surname2 = $("#ja_surname").val();
          var FirstName2 = $("#ja_firstname").val();
          var Email2 = $("#EmailAddress2").val();
          var PhoneNo2 = $("#Phone_No2").val();
          var Address2 = $("#Address2").val();
          var DOB2 = $("#DOB2").val();
          var Bank2 = $("#Bank2").val();
          var BankAccount2 = $("#BankAccount2").val();
          var BVN2 = $("#BVN2").val();


          if (DOB2_dd === '') {
            error("Joint Applicant's Day of birth is required");
            return;
          }
          if (DOB2_mm === '') {
            error("Applicant's Month of birth is required");
            return;
          }
          if (DOB2_yy === '') {
            error("Applicant's Year of birth is required");
            return;
          }

          var DOB2 = DOB2_yy + '-' + DOB2_mm + '-' + DOB2_dd;

          if (Title2 === '') {
            error("Joint Applicant's Title is required");
            return;
          }
          if (Surname2 === '') {
            error("Joint Applicant's Surname is required");
            return;
          }
          if (FirstName2 === '') {
            error("Joint Applicant's Firstname is required");
            return;
          }
          if (Email2 === '') {
            error("Joint Applicant's Email address is required");
            return;
          }
          if (PhoneNo2 === '') {
            error("Joint Applicant's Telephone number is required");
            return;
          }
          if (Address2 === '') {
            error("Joint Applicant's Address is required");
            return;
          }
          if (Bank2 === '') {
            error("Joint Applicant's Bank name is required");
            return;
          }
          if (BankAccount2 === '' || !isNumeric(BankAccount2) || BankAccount2.length !== 10) {
            error("Joint Applicant's Bank Account is invalid. Must be 10 digits");
            return;
          }
          if (BVN2 === '' || !isNumeric(BVN2) || BVN2.length !== 11) {
            error("Joint Applicant's BVN is invalid. Must be 11 digits");
            return;
          }
        }
      } else if (AccountType === 'corporate') {
        var Company_Name = $("#Company_Name").val();
        var Contact_Person = $("#Contact_Person").val();
        var company_email = $("#company_email").val();
        var company_telephone = $("#company_telephone").val();
        var company_address = $("#company_address").val();

        var company_bank_name = $("#company_bank_name").val();
        var company_bank_account_no = $("#company_bank_account_no").val();
        var company_bvn = $("#company_bvn").val();

        if (Company_Name === '') {
          error("Company name is required");
          return;
        }
        if (Contact_Person === '') {
          error("Company Contact Person's name is required");
          return;
        }
        if (company_email === '') {
          error("Company email is required");
          return;
        }
        if (company_telephone === '') {
          error("Company Telephone number is required");
          return;
        }
        if (company_address === '') {
          error("Company address is required");
          return;
        }
        if (company_bank_name === '') {
          error("Company Bank name is required");
          return;
        }
        if (company_bank_account_no === '' || !isNumeric(company_bank_account_no) || company_bank_account_no.length !== 10) {
          error("Company Bank Account is invalid. Must be 10 digits");
          return;
        }
        if (company_bvn === '' || !isNumeric(company_bvn) || company_bvn.length !== 11) {
          error("Company BVN is invalid. Must be 11 digits");
          return;
        }

      }
      var form = $(this);
      var formData = new FormData(form[0]);
      showIndicator();

      $.ajax({
        url: "<?php echo site_url('api/submit_application'); ?>",
        type: 'POST',
        dataType: "html",
        contentType: false,
        processData: false,
        data: formData,
        error: function(response) {
          hideIndicator();
          error("An error occurred. Check your internet connection.");
        },
        success: function(data) {
          var Data = parseJSON(data);
          if (Data) {
            if (Data.status === 'success') {
              var app_ref = Data.result.Comment
              var ApplicationID = Data.result.ApplicationID
              /* app_ref or applicationID is returned from API */
              var enable_payment = <?php echo _SUKUK_ENABLE_PAYMENT ? 'true' : 'false'; ?>;
              if (enable_payment) {
                window.location = '<?php echo site_url('prepayment'); ?>/' + app_ref;
              } else {
                window.location = '<?php echo site_url('success'); ?>/' + app_ref;
              }
            } else if (Data.status === 'error') {
              hideIndicator();
              <?php if (_SUKUK_ENABLE_CAPTCHA) { ?>
                grecaptcha.reset();
              <?php } ?>
              error(Data.result);
            } else {
              hideIndicator();
              <?php if (_SUKUK_ENABLE_CAPTCHA) { ?>
                grecaptcha.reset();
              <?php } ?>
              error(Data.result);
            }
          } else {
            hideIndicator();
            <?php if (_SUKUK_ENABLE_CAPTCHA) { ?>
              grecaptcha.reset();
            <?php } ?>
            error(data);
          }
        }
      });

    });
  </script>
</body>

</html>