<?php
defined('BASEPATH') or exit('No direct script access allowed');

use Dompdf\Dompdf;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

if (_ENV == 'localhost')
	require_once 'assets/dompdf/vendor/autoload.php';
else require_once 'assets/dompdf/autoload.inc.php';

require 'assets/PHPMailer/vendor/autoload.php';
class Sukuk extends CI_Controller
{

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/sukuk
	 *	- or -
	 * 		http://example.com/index.php/sukuk/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	private $post_form_to_api = _SUKUK_POST_TO_API;
	private $continue_on_api_error = _SUKUK_CONTINUE_ON_API_ERROR;
	private $merchantid = _SUKUK_MERCHANT_ID;
	private $ws_username = _SUKUK_WS_USERNAME;
	private $ws_password = _SUKUK_WS_PASSWORD;
	private $globalpay_api_url = _SUKUK_GLOBALPAY_API_URL;
	private $max_retry = _SUKUK_MAX_RETRY;

	public function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('string');
		$this->load->helper('date');
		$this->load->helper('app');
		$this->load->model("api_model");
		force_ssl();
	}
	public function index()
	{

		$payment_gateways = [];
		if (defined('_PAYMENT_GATEWAYS')) {
			$Gateways = _PAYMENT_GATEWAYS;
			$paymentGateways = is_array($Gateways) ? implode(',', $Gateways) : $Gateways;
		}
		if (!empty($paymentGateways)) {
			$GateWy = explode(',', $paymentGateways);
			foreach ($GateWy as $pg) {
				$payment_gateways[] = trim($pg);
			}
		}
		$data['payment_gateways'] = implode(',', $payment_gateways);
		if (_SUKUK_ENABLE_APPLICATION) {
			$data['Trxref'] = !empty($_GET['trxref']) ? $_GET['trxref'] : '';
			$data['uuid'] = uuid();
			$data['minAmount'] = defined('_SUKUK_MIN_AMOUNT') ? _SUKUK_MIN_AMOUNT : '10';
			$data['titles'] = defined('_NAME_TITLE') ? _NAME_TITLE : [];
			$this->load->view('sukuk-application-intro', $data);
		} else {
			$this->closed();
		}
	}
	public function apply($uuid = false)
	{
		$data['uuid'] = $uuid;
		$data['sukuk_min_amount'] = defined('_SUKUK_MIN_AMOUNT') && _SUKUK_MIN_AMOUNT > 0 ? _SUKUK_MIN_AMOUNT : 1000;
		$data['sukuk_multiple'] = defined('_SUKUK_MULTIPLE') && _SUKUK_MULTIPLE > 0 ? _SUKUK_MULTIPLE : 1000;

		if (_SUKUK_ENABLE_APPLICATION) {
			if (empty($uuid)) {
				$this->_app_error("Invalid request! Application ID missing");
				return;
			}
			$query = $this->db->where('txnref', $uuid)->get('transactions');
			$payment = $query->row_array();
			if (empty($payment)) {
				$this->_app_error("We cannot find proof of payment for this application. Please contact us");
				return;
			}
			if ($payment['payment_method'] != 'deposit' && $payment['status'] != 'successful') {
				$transQuery = $this->db->where('app_ref', $payment['app_ref'])->where('status', 'successful')->get('transactions');
				$trans = $transQuery->row_array();
				if (!empty($trans)) {
					redirect(site_url('apply/' . $trans['txnref']));
					return;
				}
				$error = "Payment for this application was not successful.";
				$this->_app_error($error);
				return;
			}
			$transQuery = $this->db->where('LCASE(Comment)', $payment['app_ref'])->get('applications');
			$trans = $transQuery->row_array();
			if (!empty($trans)) {
				$error[] = "You have already submitted an application with this payment";
				$error[] = '<a href="' . site_url() . '" class="w3-button w3-white w3-border w3-round-xxlarge px-5 mt-4">Click here to start a new application</a>';
				// $this->_app_error($error);
				// return;
			}
			$data['InvestmentValue'] = $payment['InvestmentValue'];
			$data['Title'] = $payment['title'];
			$data['Firstname'] = $payment['firstname'];
			$data['Othername'] = $payment['othername'];
			$data['Surname'] = $payment['surname'];

			$Fullname = [];
			if (!empty($data['Title'])) $Fullname[] = $data['Title'];
			if (!empty($data['Firstname'])) $Fullname[] = $data['Firstname'];
			if (!empty($data['Othername'])) $Fullname[] = $data['Othername'];
			if (!empty($data['Surname'])) $Fullname[] = $data['Surname'];
			$data['Fullname'] = implode(' ', $Fullname);
			$data['Email'] = $payment['email_address'];
			$data['Telephone'] = $payment['phone_number'];
			$data['minAmount'] = defined('_SUKUK_MIN_AMOUNT') ? _SUKUK_MIN_AMOUNT : '10';
			$data['titles'] = defined('_NAME_TITLE') ? _NAME_TITLE : [];
			$this->load->view('sukuk-application', $data);
		} else {
			$this->closed();
		}
	}
	public function _app_error($error)
	{
		$this->load->view('sukuk-application-error', ['error' => $error]);
	}
	public function closed()
	{
		$data = [];
		$this->load->view('sukuk-closed', $data);
	}
	public function status($txnref = false)
	{
	}
	public function success($app_ref = false)
	{
		if (empty($app_ref)) {
			$data['status'] = 'error';
			$data['error'] = "Invalid request! Application reference not sent";
			$this->load->view('sukuk-application-success', $data);
			return false;
		}
		$app = $this->api_model->get_application($app_ref);

		if (empty($app)) {
			$data['status'] = 'error';
			$data['error'] = "Application not found";
			$this->load->view('sukuk-application-success', $data);
			return false;
		}
		$data['status'] = 'wsdl_success';
		$data['app'] = $app;
		$this->load->view('sukuk-application-success', $data);
	}
	public function receipt($txnref = false)
	{
		if (empty($txnref)) {
			$data['status'] = 'error';
			$data['error'] = "Invalid request! Transaction reference not sent";
			$this->load->view('sukuk-application-receipt', $data);
			return false;
		}
		$query = $this->db->where("LCASE(txnref)", strtolower($this->db->escape_str($txnref)))->get('transactions');
		$trans = $query->row_array();

		if (empty($trans)) {
			$data['status'] = 'error';
			$data['error'] = "Transaction not found";
			$this->load->view('sukuk-application-receipt', $data);
			return false;
		}
		if ($trans['payment_status'] == 'pending' && $trans['processed'] == '1') {
			redirect(site_url('payment/' . $txnref));
			return true;
		}
		$data['status'] = 'wsdl_success';
		$data['txnref'] = $txnref;
		$data['trans'] = $trans;
		$this->load->view('sukuk-application-receipt', $data);
	}
	public function xml2array($xmlObject = false, $out = [])
	{
		foreach ((array) $xmlObject as $index => $node)
			$out[$index] = (is_object($node)) ? $this->xml2array($node) : $node;
		return $out;
	}

	public function payment($txnref = false)
	{
		if (!empty($_GET['txnref'])) $txnref = $_GET['txnref'];
		if (empty($txnref)) {
			$data['status'] = 'error';
			$data['error'] = "Invalid request! Transaction reference not sent";
			$this->load->view('sukuk-application-payment', $data);
			return false;
		}
		$data['txnref'] =  $txnref;
		$data['max_retry'] = $this->max_retry;
		$query = $this->db->where("LCASE(txnref)", strtolower($this->db->escape_str($txnref)))->get('transactions');
		$Trans = $query->row_array();

		if (empty($Trans)) {
			$data['status'] = 'error';
			$data['error'] = "Transaction not found";
			$this->load->view('sukuk-application-payment', $data);
			return false;
		}

		$app = $this->api_model->get_application($Trans['app_ref']);
		$ApplicationID = $app['ApplicationID'];

		if ($Trans['payment_status'] == 'successful') {
			redirect(site_url('receipt/' . $txnref)); // DEBUGGER - UNCOMMENT
			return true; // DEBUGGER - UNCOMMENT
		}
		if ($Trans['checks'] > $this->max_retry && $Trans['payment_status'] == 'failed') {
			redirect(site_url('receipt/' . $txnref));
			return true;
		}
		if ($Trans['checks'] > $this->max_retry) {
			$data['status'] = 'wsdl_success';
			$data['trans'] = $Trans;
			$this->load->view('sukuk-application-payment', $data);
			return false;
		}
		//error_reporting (E_ALL ^ E_DEPRECATED);
		ini_set('soap.wsdl_cache_enabled', 0);
		include('lib/nusoap.php');

		$client = new nusoap_client(_SUKUK_GLOBALPAY_WSDL_URL, true);
		$soapaction = _SUKUK_GLOBALPAY_SOAP_ACTION;
		$namespace = _SUKUK_GLOBALPAY_SOAP_NAMESPACE;
		$client->soap_defencoding = 'UTF-8';

		$channel = "";
		$merchantID = $this->merchantid;
		$start_date = "";
		$end_date = "";
		$uid = $this->ws_username;
		$pwd = $this->ws_password;
		$payment_status = "";

		$err = $client->getError();
		if ($err) {
			$data['status'] = 'error';
			$data['error'] = $err;
			$this->load->view('sukuk-application-payment', $data);
			return false;
		}
		// Doc/lit parameters get wrapped
		$MethodToCall =  "getTransactions";

		$param = array(
			'merch_txnref' => $txnref,
			'channel' => $channel,
			'merchantID' => $this->merchantid,
			'start_date' => $start_date,
			'end_date' => $end_date,
			'uid' => $this->ws_username,
			'pwd' => $this->ws_password,
			'payment_status' => $payment_status
		);
		$result = $client->call(
			'getTransactions',
			array('parameters' => $param),
			$namespace,
			$soapaction,
			false,
			true
		);
		// Check for a fault
		if ($client->fault) {
			$data['status'] = 'error';
			$data['error'] = $result;
			$this->load->view('sukuk-application-payment', $data);
			return false;
		}
		// Check for errors
		$err = $client->getError();
		if ($err) {
			$data['status'] = 'error';
			$data['error'] = $err;
			$this->load->view('sukuk-application-payment', $data);
			return false;
		}

		//This gives getTransactionsResult
		$WebResult = $MethodToCall . "Result";

		if (empty($result[$WebResult])) {
			$data['status'] = 'error';
			$data['error'] = 'Transaction not fount';
			$this->load->view('sukuk-application-payment', $data);
			return false;
		}
		// Pass the result into XML
		$xml = simplexml_load_string($result[$WebResult]);

		$amount         = !empty($xml->record->amount) ? $this->xml2array($xml->record->amount) : '';
		$txn_date       = !empty($xml->record->payment_date) ? $this->xml2array($xml->record->payment_date) : '';
		$channel	      = !empty($xml->record->channel) ? $this->xml2array($xml->record->channel) : '';
		$pmt_status     = !empty($xml->record->payment_status) ? $this->xml2array($xml->record->payment_status) : '';
		$pmt_txnref     = !empty($xml->record->txnref) ? $xml->record->txnref : '';
		$currency       = !empty($xml->record->field_values->field_values->field[2]->currency) ? $this->xml2array($xml->record->field_values->field_values->field[2]->currency) : '';
		$trans_status   = !empty($xml->record->payment_status_description) ? $this->xml2array($xml->record->payment_status_description) : '';

		//Get information from your database
		$InvestmentValue = $Trans['InvestmentValue'];
		$names = $Trans['names'];
		$phone_number  = $Trans['phone_number'];
		$email_address  = $Trans['email_address'];


		$checks = $Trans['checks'];
		$checks++;
		$Trans['checks'] = $checks;
		if (!empty($amount)) $Trans['amount'] = $amount[0];
		if (!empty($pmt_method)) $Trans['payment_method'] = $pmt_method;
		if (!empty($channel)) $Trans['channel'] = $channel[0];
		if (!empty($txn_date)) $Trans['payment_date'] = $txn_date[0];
		if (!empty($trans_status)) $Trans['payment_status_description'] = $trans_status[0];
		if (!empty($currency)) $Trans['currency'] = $currency[0];

		$data['status'] = 'wsdl_success';
		if ($pmt_status[0] == 'successful') {
			if ($Trans['amount'] >= $Trans['InvestmentValue']) {
				if (!empty($ApplicationID)) {
					$sukuktopup = sukukTopup($Trans['app_ref']);
					if ($sukuktopup) {
						$UpdateData['topup_updated'] = $sukuktopup['topup_updated'];
						$UpdateData['topup_response'] = $sukuktopup['topup_response'];
					}
					//UPDATE APPLICATION
					$updateSukuk = updateSukuk($ApplicationID, array("Status" => 'Awaiting Fincon Review', "Extra2" => $txnref));

					if ($updateSukuk) {
						$UpdateData['Extra2'] = $txnref;
						$UpdateData['status_updated'] = $updateSukuk['status_updated'];
					}
				}

				$Trans['payment_status'] = 'successful';
				$Trans['status'] = 'successful';
				$UpdateData['Status'] = 'Awaiting Fincon Review';
				$this->db->update("transactions", $Trans, array("txnref" => $txnref));
				$this->db->update("applications", $UpdateData, array("Comment" => $app['Comment']));
				payment_success_email($app, $Trans);
				redirect(site_url('receipt/' . $txnref));
				return true;
			} else {
				$Trans['payment_status'] = 'successful';
				$Trans['status'] = 'invalid_amount';
				$update = $this->db->update("transactions", $Trans, array("txnref" => $txnref));
				redirect(site_url('receipt/' . $txnref));
				return true;
			}
		} else {

			if ($pmt_status == 'pending') {
				$update = $this->db->update("transactions", $Trans, array("txnref" => $txnref));
			} else {
				$Trans['payment_status'] = 'failed';
				$Trans['status'] = 'failed';
				$update = $this->db->update("transactions", $Trans, array("txnref" => $txnref));
				redirect(site_url('receipt/' . $txnref));
				return true;
			}
		}

		$data['trans'] = $Trans;
		$this->load->view('sukuk-application-payment', $data);
	}
	public function prepayment($app_ref = false)
	{
		$app = [];
		if (!empty($app_ref)) {
			$app = $this->api_model->get_application($app_ref);
			if (!empty($app)) {
				$Fullname = [];
				if ($app['AccountType'] != 'corporate') {
					if (!empty($app['Title'])) $Fullname[] = $app['Title'];
					if (!empty($app['Surname'])) $Fullname[] = $app['Surname'];
					if (!empty($app['FirstName'])) $Fullname[] = $app['FirstName'];
					if (!empty($app['OtherName'])) $Fullname[] = $app['OtherName'];
					$names = implode(' ', $Fullname);
				} else {
					$names = $app['Company_Name'];
				}

				$Query = $this->db->select("txnref")->where("LCASE(app_ref)", strtolower($this->db->escape_str($app_ref)))->where("status", "successful")->get('transactions');
				$successful = $Query->row_array();
				if (!empty($successful)) {
					$txnref = $successful['txnref'];
					redirect(site_url('receipt/' . $txnref));
					return true;
				}

				$txnref = generate_randomID();
				$query = $this->db->select("txnref")->where("LCASE(app_ref)", strtolower($this->db->escape_str($app_ref)))->where("processed", "0")->get('transactions');
				$result = $query->row_array();
				if (!empty($result)) $txnref = $result['txnref'];

				$data['app_id'] = $app['id'];
				$data['ApplicationID'] = $app['ApplicationID'];
				$data['app_ref'] = strtolower($app_ref);
				$data['txnref'] = $txnref;
				$data['names'] = $names;
				$data['email_address'] = $app['Email'];
				$data['phone_number'] = $app['PhoneNo'];
				$data['InvestmentValue'] = $app['InvestmentValue'];
				$data['amount'] = 0;
				$data['payment_method'] = '';
				$data['channel'] = '';
				$data['payment_date'] = '';
				$data['payment_status'] = 'pending';
				$data['payment_status_description'] = '';
				$data['currency'] = 'NGN';
				$data['checks'] = 0;
				$data['processed'] = '0';

				if (empty($result)) $insert = $this->db->insert("transactions", $data);

				$data['merchantid'] = $this->merchantid;
				$data['globalpay_api_url'] = $this->globalpay_api_url;
			}
		}
		$data['application'] = $app;
		$this->load->view('sukuk-application-prepayment', $data);
	}
}
