<?php
defined('BASEPATH') or exit('No direct script access allowed');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, DELETE, PUT');
header('Access-Control-Allow-Headers: token, Content-Type');
header('Access-Control-Max-Age: 1728000');
header('Content-Type: application/json');

use Dompdf\Dompdf;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

if (_ENV == 'localhost')
	require_once 'assets/dompdf/vendor/autoload.php';
else require_once 'assets/dompdf/autoload.inc.php';

require 'assets/PHPMailer/vendor/autoload.php';

class Api extends CI_Controller
{

	private $post_form_to_api = _SUKUK_POST_TO_API;
	private $continue_on_api_error = _SUKUK_CONTINUE_ON_API_ERROR;
	private $recaptcha_secret = _SUKUK_RECAPTCHA_SECRET;
	private $merchantid = _SUKUK_MERCHANT_ID;
	private $ws_username = _SUKUK_WS_USERNAME;
	private $ws_password = _SUKUK_WS_PASSWORD;
	private $max_retry = _SUKUK_MAX_RETRY;

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->helper('url');
		$this->load->helper('string');
		$this->load->helper('date');
		$this->load->helper('app');
		$this->load->model("api_model");

		$this->smsapi_senderID = '';
		$this->smsapi_username = '';
		$this->smsapi_password = '';

		$this->server = _SERVER;
		$this->mediapath = $this->server . '/media';
		$this->signatureFiles = $this->server . '/images/signatures';
	}
	public function index()
	{
		die("Oops! Catch yah!! Cheating!!!");
	}
	public function check_internet()
	{
		_return_success();
	}
	public function amount_in_words()
	{
		$amount = $this->input->get('amount');
		if (empty($amount)) _return_error("Amount not specified");
		_return_success(strtoupper(convertAmountToWord($amount)) . ' ONLY');
	}
	public function PaymentProofNotificationMessage($data)
	{
		$align = defined('_SUKUK_EMAIL_BODY_ALIGN') && _SUKUK_EMAIL_BODY_ALIGN == 'center' ? 'center' : 'left';
		extract($data);
		ob_start();
		$Fullname = [];
		if (!empty($data['title'])) $Fullname[] = $data['title'];
		if (!empty($data['firstname'])) $Fullname[] = $data['firstname'];
		if (!empty($data['othername'])) $Fullname[] = $data['othername'];
		if (!empty($data['surname'])) $Fullname[] = $data['surname'];
		$Name = implode(' ', $Fullname);
?>
		<div style="max-width: 640px; <?php if ($align == 'center') echo 'margin: auto;'; ?>">
			<table style="width: 100%" border="0" cellspacing="0" cellpadding="0">
				<tbody>
					<tr>
						<td style="padding: 5px; text-align:left; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">
							Dear <?php echo $Name; ?>.
							<h4>Thank you for using our online Sukuk form</h4>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;">Your proof of payment notification has been received</p>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;">Below is the detail of your payment submitted.</p>

							<table style="margin-bottom: 20px;">
								<tr>
									<td align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Name </td>
									<td style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $Name; ?></td>
								</tr>
								<tr>
									<td align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Email Address</td>
									<td style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $email_address; ?></td>
								</tr>
								<tr>
									<td align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Telephone</td>
									<td style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $phone_number; ?></td>
								</tr>
								<tr>
									<td align="left" style="padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Amount to Invest</td>
									<td style="padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo '&#8358;' . number_format($InvestmentValue, 2); ?></td>
								</tr>
								<tr>
									<td align="left" style="padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Payment Reference</td>
									<td style="padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $tellerNo; ?></td>
								</tr>
							</table>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;">Please note that you can start your application using the link below if you have not already done so</p>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;"><a href="<?php echo site_url("apply/" . $txnref); ?>" style="font-size:16px; color: #ff0000; font-family: Gotham, Helvetica, Arial, sans-serif;">Proceed to Apply</a></p>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;">You can contact us at <?php echo _SUKUK_CONTACT_EMAIL; ?> to learn about our products and services.</p>
							<p style="margin-top: 25px;">Kind regards</p>
						</td>
					</tr>

				</tbody>
			</table>
		</div>
	<?php
		$content = ob_get_contents();
		ob_end_clean();
		return $content;
	}
	public function SaveProofOfPayment()
	{
		$allowed_types = ["image/jpeg", "application/pdf"];
		$max_upload_size = _SUKUK_MAX_UPLOAD_SIZE; // MB
		$input = $this->input->post();
		extract($input);
		$amount = str_replace(',', '', $InvestmentValue);
		if (empty($uuid)) _return_error("Invalid request");
		if (empty($names)) _return_error("Please enter your full name");
		if (empty($amount)) _return_error("Please enter your investment amount");
		if (empty($email_address)) _return_error("Please enter your email address");
		if (empty($phone_number)) _return_error("Please enter your phone number");
		// if (empty($tellerNo)) _return_error("Please provide teller number or transaction reference");
		if (empty($_FILES['slip']['name'])) _return_error("Please select a receipt file to upload");

		$sukuk_min_amount = defined('_SUKUK_MIN_AMOUNT') && _SUKUK_MIN_AMOUNT > 0 ? _SUKUK_MIN_AMOUNT : 1000;
		$sukuk_multiple = defined('_SUKUK_MULTIPLE') && _SUKUK_MULTIPLE > 0 ? _SUKUK_MULTIPLE : 1000;

		if ($amount < $sukuk_min_amount) _return_error("Value of Sukuk Applied for must be minimum of N" . number_format($sukuk_min_amount, 2));
		if ($amount %  $sukuk_multiple > 0) _return_error("Value of Sukuk Applied for must be in multiples of " . number_format($sukuk_multiple, 2));


		// PROOF OF PAYMENT
		$ProofOfPayment = '';
		if (!empty($_FILES['slip']['name'])) {
			if (!in_array($_FILES['slip']['type'], $allowed_types)) _return_error("Invalid file type uploaded for Applicant slip. Only JPES image and PDF payment receipt can be uploaded");
			if ($_FILES['slip']['size'] > file_size_to_byte($max_upload_size, 'mb')) _return_error("Uploaded file should not be greated than " . $max_upload_size . "MB");
			$ext = get_extension($_FILES['slip']['name']);
			$ProofOfPayment = 'slip-' . $uuid . $ext;
			if (!move_uploaded_file($_FILES['slip']['tmp_name'], 'slips/' . $ProofOfPayment)) _return_error("File upload failed. Please try again");
		}

		$Trans['txnref'] = $uuid;
		$Trans['app_id'] = '';
		$Trans['ApplicationID'] = '';
		$Trans['app_ref'] = 'web-' . $uuid;
		$Trans['names'] = $names;
		$Trans['title'] = $title;
		$Trans['firstname'] = $firstname;
		$Trans['surname'] = $surname;
		$Trans['othername'] = $othername;
		$Trans['email_address'] = $email_address;
		$Trans['phone_number'] = $phone_number;
		$Trans['InvestmentValue'] = $amount;
		$Trans['amount'] = 0;
		$Trans['tellerNo'] = $tellerNo;
		$Trans['teller'] = $ProofOfPayment;
		$Trans['payment_method'] = $option;
		$Trans['gateway'] = '';
		$Trans['channel'] = '';
		$Trans['payment_date'] = todayDateTime();
		$Trans['payment_status'] = 'approved';
		$Trans['status'] = 'approved';
		$Trans['payment_status_description'] = '';
		$Trans['response'] = '';
		$Trans['responseData'] = '';
		$Trans['currency'] = 'NGN';
		$Trans['checks'] = 0;
		$Trans['processed'] = 0;

		if (!empty($tellerNo)) {
			$query = $this->db->where('txnref', $uuid)->or_where('teller', $tellerNo)->get('transactions');
			$tellerData = $query->row_array();
		}
		if (!empty($tellerData)) {
			$queryApp = $this->db->where('LCASE(Comment)', 'web-' . $uuid)->get('applications');
			$App = $queryApp->row_array();
			if (!empty($App)) _return_error("You have already submitted an application with this payment reference. Please contact us for further inquiry");
		} else {
			$this->db->insert('transactions', $Trans);
		}
		$emailMessage['attachments'] = ['slips/' . $ProofOfPayment];
		$emailMessage['subject'] = "Sovereign Sukuk Subscription Payment Notification";
		$emailMessage['message'] = $this->PaymentProofNotificationMessage($Trans);
		sendWithPHPMailer($email_address, $emailMessage);
		_return_success($Trans);
	}
	public function MakePayment($gateway = 'paystack')
	{
		$input = (array) json_decode(file_get_contents("php://input"));
		extract($input);
		$amount = str_replace(',', '', $InvestmentValue);
		if (empty($uuid)) _return_error("Invalid request");
		if (empty($names)) _return_error("Please enter your full name");
		if (empty($amount)) _return_error("Please enter your investment amount");
		if (empty($email_address)) _return_error("Please enter your email address");
		if (empty($phone_number)) _return_error("Please enter your phone number");

		$sukuk_min_amount = defined('_SUKUK_MIN_AMOUNT') && _SUKUK_MIN_AMOUNT > 0 ? _SUKUK_MIN_AMOUNT : 1000;
		$sukuk_multiple = defined('_SUKUK_MULTIPLE') && _SUKUK_MULTIPLE > 0 ? _SUKUK_MULTIPLE : 1000;

		if ($amount < $sukuk_min_amount) _return_error("Value of Sukuk Applied for must be minimum of N" . number_format($sukuk_min_amount, 2));
		if ($amount %  $sukuk_multiple > 0) _return_error("Value of Sukuk Applied for must be in multiples of " . number_format($sukuk_multiple, 2));

		$query = $this->db->where('txnref', $txnref)->get('transactions');
		$payment = $query->row_array();
		if (!empty($payment)) {
			if ($payment['status'] == 'successful') _return_error('<h4 class="w3-center">This transaction is successful.</h4><a class="w3-button w3-round-xxlarge mt-2 mb-2 w3-border px-5 py-1 w3-red no-underline" href="' . site_url('apply/' . $txnref) . '">Please click here to proceed to the application</a>');
			_return_error("Duplicate");
		}

		$Trans['txnref'] = $txnref;
		$Trans['app_id'] = '';
		$Trans['ApplicationID'] = '';
		$Trans['app_ref'] = 'web-' . $txnref;
		$Trans['names'] = $names;
		$Trans['title'] = $title;
		$Trans['firstname'] = $firstname;
		$Trans['surname'] = $surname;
		$Trans['othername'] = $othername;
		$Trans['email_address'] = $email_address;
		$Trans['phone_number'] = $phone_number;
		$Trans['InvestmentValue'] = $amount;
		$Trans['amount'] = 0;
		$Trans['payment_method'] = $option;
		$Trans['tellerNo'] = '';
		$Trans['teller'] = '';
		$Trans['gateway'] = $gateway;
		$Trans['mode'] = _SUKUK_PAYMENT_MODE;
		$Trans['channel'] = '';
		$Trans['payment_date'] = '';
		$Trans['payment_status'] = 'pending';
		$Trans['status'] = 'pending';
		$Trans['payment_status_description'] = '';
		$Trans['response'] = '';
		$Trans['responseData'] = '';
		$Trans['currency'] = 'NGN';
		$Trans['checks'] = 0;
		$Trans['processed'] = 0;

		$this->db->insert("transactions", $Trans);
		$Trans['amount'] = $amount;
		$Trans['PAYSTACK_DEMO_KEY'] = _PAYSTACK_DEMO_PUBLICKEY;
		$Trans['PAYSTACK_KEY'] = _PAYSTACK_PUBLICKEY;
		$Trans['PAYMENT_MODE'] = _SUKUK_PAYMENT_MODE;
		_return_success($Trans);
	}
	public function PaymentNotificationMessage($data)
	{
		$align = defined('_SUKUK_EMAIL_BODY_ALIGN') && _SUKUK_EMAIL_BODY_ALIGN == 'center' ? 'center' : 'left';
		extract($data);
		ob_start();
		$Fullname = [];
		if (!empty($data['title'])) $Fullname[] = $data['title'];
		if (!empty($data['firstname'])) $Fullname[] = $data['firstname'];
		if (!empty($data['othername'])) $Fullname[] = $data['othername'];
		if (!empty($data['surname'])) $Fullname[] = $data['surname'];
		$Name = implode(' ', $Fullname);
	?>
		<div style="max-width: 640px; <?php if ($align == 'center') echo 'margin: auto;'; ?>">
			<table style="width: 100%" border="0" cellspacing="0" cellpadding="0">
				<tbody>
					<tr>
						<td style="padding: 5px; text-align:left; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">
							Dear <?php echo $Name; ?>.
							<h4>Thank you for using our online Sukuk form</h4>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;">Your payment has been received</p>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;">Below is the detail of your payment submitted.</p>
							<table style="margin-bottom: 20px;">
								<tr>
									<td align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Name </td>
									<td style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $Name; ?></td>
								</tr>
								<tr>
									<td align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Email Address</td>
									<td style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $email_address; ?></td>
								</tr>
								<tr>
									<td align="left" style="border-bottom: 1px solid #C1C1C1; padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Telephone</td>
									<td style="border-bottom: 1px solid #C1C1C1; padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $phone_number; ?></td>
								</tr>
								<tr>
									<td align="left" style="padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Transaction Amount</td>
									<td style="padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo '&#8358;' . number_format($InvestmentValue, 2); ?></td>
								</tr>
								<tr>
									<td align="left" style="padding: 5px; font-size:14px; font-family: Gotham, Helvetica, Arial, sans-serif;">Payment Reference</td>
									<td style="padding: 5px; text-align:left; font-size:14px; font-weight:bold; font-family: Gotham, Helvetica, Arial, sans-serif;"><?php echo $txnref; ?></td>
								</tr>
							</table>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;">Please note that you can start your application using the link below if you have not already done so</p>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;"><a href="<?php echo site_url("apply/" . $txnref); ?>" style="font-size:16px; color: #ff0000; font-family: Gotham, Helvetica, Arial, sans-serif;">Proceed to Apply</a></p>
							<p style="font-size:14px; margin-bottom: 20px; font-family: Gotham, Helvetica, Arial, sans-serif;">You can contact us at <?php echo _SUKUK_CONTACT_EMAIL; ?> to learn about our products and services.</p>
							<p style="margin-top: 25px;">Kind regards</p>
						</td>
					</tr>

				</tbody>
			</table>
		</div>
		<?php
		$content = ob_get_contents();
		ob_end_clean();
		return $content;
	}

	public function sukuk_payment($txnref = false)
	{
		$trx = get_sukuk_transaction($txnref);
		if (empty($trx)) _return_error(['message' => "Transaction not found", 'payment' => [], 'transaction' => []]);
		$payment = verify_payment($txnref, $trx['mode'], $trx['gateway']);
		if (!empty($payment['result']['payment'])) {
			$this->db->update('transactions', [
				"status" => $payment['result']['payment']['status'] == 'success' ? 'successful' : $payment['result']['payment']['status'],
				"payment_status" => $payment['result']['payment']['status'] == 'success' ? 'successful' : $payment['result']['payment']['status'],
				"amount" => $payment['result']['payment']['amount'],
				"payment_date" => $payment['result']['payment']['payment_date'],
				'channel' => $payment['result']['payment']['channel'],
				"response" => $payment['result']['payment']['response'],
				"responseData" => $payment['result']['payment']['responseData'],
			], ['txnref' => $txnref]);
		}

		$transaction = get_sukuk_transaction($txnref);
		$message = !empty($payment['result']['message']) ? $payment['result']['message'] : '';
		if ($payment['status'] == 'error') {
			_return_error(['message' => $message, 'payment' => $payment['result']['payment'], 'transaction' => $transaction]);
		} else {
			// SEND EMAIL
			$emailMessage['subject'] = "Sovereign Sukuk Subscription Payment";
			$emailMessage['message'] = $this->PaymentNotificationMessage($transaction);
			sendWithPHPMailer($transaction['email_address'], $emailMessage);
			_return_success(['message' => $message, 'payment' => $payment['result']['payment'], 'transaction' => $transaction]);
		}
	}
	public function prepayment($print = false)
	{
		if (!empty($_POST)) extract($_POST);
		$names = $this->input->post('names');
		$amount = str_replace(',', '', $this->input->post('amount'));
		$email_address = $this->input->post('email_address');
		$phone_number = $this->input->post('phone_number');
		$currency = $this->input->post('currency');
		$txnref = $this->input->post('merch_txnref');
		$merchantid = $this->input->post('merchantid');
		$app_ref = $this->input->post('app_ref');

		$app = $this->api_model->get_application($app_ref);
		if (empty($app)) _return_error("Application was not found or may have been deleted");

		$Trans['app_id'] = $app['id'];
		$Trans['ApplicationID'] = $app['ApplicationID'];
		$Trans['app_ref'] = $app_ref;
		$Trans['names'] = $names;
		$Trans['email_address'] = $email_address;
		$Trans['phone_number'] = $phone_number;
		$Trans['InvestmentValue'] = $amount;
		$Trans['amount'] = 0;
		$Trans['payment_method'] = '';
		$Trans['channel'] = '';
		$Trans['payment_date'] = '';
		$Trans['payment_status'] = 'pending';
		$Trans['payment_status_description'] = '';
		$Trans['currency'] = $currency;
		$Trans['checks'] = 0;
		$Trans['processed'] = 1;

		$query = $this->db->where("LCASE(txnref)", strtolower($this->db->escape_str($txnref)))->get('transactions');
		$result = $query->row_array();

		if (empty($result)) {
			$txnref = generate_randomID();
			$Trans['txnref'] = $txnref;
			$insert = $this->db->insert("transactions", $Trans);
		} else {
			if ($result['processed'] == '1') {
				$txnref = generate_randomID();
				$Trans['txnref'] = $txnref;
				$insert = $this->db->insert("transactions", $Trans);
			} else {
				$update = $this->db->update("transactions", array("processed" => "1"), array("txnref" => $txnref));
			}
		}
		_return_success($txnref);
	}
	public function submit_application($print = false)
	{
		if (!_SUKUK_ENABLE_APPLICATION) _return_error("Sorry! Application is closed");
		if (!empty($_POST)) extract($_POST);
		$AccountType = !empty($AccountType) ? $AccountType : '';
		if (empty($agree)) _return_error("You must agree to the form declaration");
		if (_SUKUK_ENABLE_CAPTCHA) {
			if (empty($_POST['g-recaptcha-response'])) {
				_return_error('Are you a robot?');
			} else {
				$verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret=' . $this->recaptcha_secret . '&response=' . $_POST['g-recaptcha-response']);
				$recaptcha = json_decode($verifyResponse);

				if (!$recaptcha->success) {
					_return_error('Robot verification failed, please try again.');
				}
			}
		}
		$query = $this->db->where('txnref', $uuid)->get('transactions');
		$payment = $query->row_array();
		if (empty($payment)) _return_error("We cannot find proof of payment for this application. Please contact us");

		$_Fullname = array();
		$_Firstname = array();
		$_jFullname = array();

		$InvestorCategory = $this->input->post('InvestorCategory');
		$amount_in_words = $this->input->post('_amount_in_words');
		$InvestmentValue = str_replace(',', '', $this->input->post('InvestmentValue'));

		$sukuk_min_amount = defined('_SUKUK_MIN_AMOUNT') && _SUKUK_MIN_AMOUNT > 0 ? _SUKUK_MIN_AMOUNT : 1000;
		$sukuk_multiple = defined('_SUKUK_MULTIPLE') && _SUKUK_MULTIPLE > 0 ? _SUKUK_MULTIPLE : 1000;

		if (empty($InvestmentValue)) _return_error("Please enter the Value of Sukuk to applied for");
		if ($InvestmentValue < $sukuk_min_amount) _return_error("Value of Sukuk Applied for must be minimum of N" . number_format($sukuk_min_amount, 2));
		if ($InvestmentValue %  $sukuk_multiple > 0) _return_error("Value of Sukuk Applied for must be in multiples of " . number_format($sukuk_multiple, 2));

		if ($AccountType == 'individual' || $AccountType == 'joint') {
			if (empty($Title)) _return_error("Applicant Title is required");
			if (empty($Surname)) _return_error("Applicant Surname is required");
			if (empty($FirstName)) _return_error("Applicant Fistname is required");
			if (empty($Email)) _return_error("Email address is required");
			if (empty($PhoneNo)) _return_error("Telephone is required");
			if (empty($Address)) _return_error("Address is required");

			if (empty($DOB_dd)) _return_error("Applicant's Day of birth is required");
			if (empty($DOB_mm)) _return_error("Applicant's Month of birth is required");
			if (empty($DOB_yy)) _return_error("Applicant's Year of birth is required");
			$DOB = $DOB_yy . '-' . $DOB_mm . '-' . $DOB_dd;

			if (empty($Bank)) _return_error("Bank name is required");
			if (!empty($BVN) && strlen($BVN) != 11) _return_error("BVN is invalid! Must be 11 digits");
			if (!empty($BankAccount) && strlen($BankAccount) != 10) _return_error("Bank account no. is invalid! Must be 10 digits");

			if (!validEmail($Email)) _return_error("Email address is invalid");

			if (!empty($Title)) $_Fullname[] = $Title;
			if (!empty($Surname)) $_Fullname[] = $Surname;
			if (!empty($FirstName)) $_Fullname[] = $FirstName;
			if (!empty($OtherName)) $_Fullname[] = $OtherName;

			if (!empty($FirstName)) $_Firstname[] = $FirstName;
			if (!empty($OtherName)) $_Firstname[] = $OtherName;

			if ($AccountType == 'joint') {
				if (empty($_ja_title)) _return_error("Joint Applicant Title is required");
				if (empty($_ja_surname)) _return_error("Joint Applicant Surname is required");
				if (empty($_ja_firstname)) _return_error("Joint Applicant Firstname is required");

				if (empty($EmailAddress2)) _return_error("Joint Applicant Email address is required");
				if (empty($Phone_No2)) _return_error("Joint Applicant Telephone is required");
				if (empty($Address2)) _return_error("Joint Applicant Address is required");

				if (empty($DOB2_dd)) _return_error("Joint Applicant's Day of birth is required");
				if (empty($DOB2_mm)) _return_error("Joint Applicant's Month of birth is required");
				if (empty($DOB2_yy)) _return_error("Joint Applicant's Year of birth is required");
				$DOB2 = $DOB2_yy . '-' . $DOB2_mm . '-' . $DOB2_dd;

				if (empty($Bank2)) _return_error("Joint Applicant Bank name is required");
				if (!empty($BVN2) && strlen($BVN2) != 11) _return_error("Joint Applicant BVN is invalid! Must be 11 digits");
				if (!empty($BankAccount2) && strlen($BankAccount2) != 10) _return_error("Joint Applicant Bank account no. is invalid! Must be 10 digits");

				if (!validEmail($EmailAddress2)) _return_error("Joint Applicant Email address is invalid");

				if (!empty($_ja_title)) $_jFullname[] = $_ja_title;
				if (!empty($_ja_surname)) $_jFullname[] = $_ja_surname;
				if (!empty($_ja_firstname)) $_jFullname[] = $_ja_firstname;
				if (!empty($_ja_otherName)) $_jFullname[] = $_ja_otherName;
			}

			$trxFullname = implode(' ', $_Fullname);
			$trxDeclarername = $trxFullname;
			$trxEmail = $Email;
			$trxPhoneNo = $PhoneNo;
		} else if ($AccountType == 'corporate') {
			if (empty($Company_Name)) _return_error("Company Name is required");
			if (empty($Contact_Person)) _return_error("Contact Person's Name is required");
			if (empty($_company_email)) _return_error("Company Email address is required");
			if (empty($_company_telephone)) _return_error("Company Telephone is required");
			if (empty($_company_address)) _return_error("Company address is required");
			if (empty($_company_bank_name)) _return_error("Company Bank name is required");
			if (!empty($_company_bvn) && strlen($_company_bvn) != 11) _return_error("Company BVN is invalid! Must be 11 digits");
			if (!empty($_company_bank_account_no) && strlen($_company_bank_account_no) != 10) _return_error("Company Bank account no. is invalid! Must be 10 digits");

			$trxFullname = $Company_Name;
			$trxDeclarername = $Contact_Person;
			$trxEmail = $_company_email;
			$trxPhoneNo = $_company_telephone;
		}

		if ($AccountType == 'individual') {
			$ID_Type2 = '';
			$IDNo2 = '';
			$Occupation2 = '';
			$EmailAddress2 = '';
			$Phone_No2 = '';
			$Address2 = '';
			$MotherMaidName2 = '';
			$DOB2 = '';
			$Bank2 = '';
			$BankAccount2 = '';
			$BVN2 = '';
			$Company_Name = '';
			$Type_of_Business = '';
			$RC_No = '';
			$_company_address = '';
			$Contact_Person = '';
		} else if ($AccountType == 'joint') {
			$Company_Name = '';
			$Type_of_Business = '';
			$RC_No = '';
			$Contact_Person = '';
		} else if ($AccountType == 'corporate') {
			$Address = $_company_address;
			$Email = $_company_email;
			$PhoneNo = $_company_telephone;
			$Bank = $_company_bank_name;
			$BankAccount = $_company_bank_account_no;
			$BVN = $_company_bvn;

			$_jFullname = array();
			$_Fullname = array();
			$Title = '';
			$Surname = '';
			$FirstName = '';
			$OtherName = '';
			$Occupation = '';
			$ID_Type = '';
			$ID_Type2 = '';
			$IDNo = '';
			$IDNo2 = '';
			$NextOfKin = '';
			$MotherMaidenName = '';
			$DOB = '';
			$Residency = '';
			$Occupation2 = '';
			$EmailAddress2 = '';
			$Phone_No2 = '';
			$Address2 = '';
			$MotherMaidName2 = '';
			$DOB2 = '';
			$Bank2 = '';
			$BankAccount2 = '';
			$BVN2 = '';
		}

		$_InvestorCategory = $InvestorCategory;
		if (!empty($InvestorCategory) && $InvestorCategory == 'Others Institutions') {
			$_InvestorCategory = $InvestorCategory . ' - ' . $InvestorCategoryOrder;
		}

		$Sukuk_Type = '';
		$UnitPrice = 0;
		$setupGroup = sukukSetup();
		if (!empty($setupGroup)) {
			$Sukuk_Type = $setupGroup['Description'];
			$UnitPrice = str_replace(',', '', $setupGroup['Unit_Price']);
		}

		$app_title = get_app_title();
		$ref_id = 'WEB-' . $uuid;
		$data['Comment'] = $ref_id;
		$data['Surname'] = $Surname;
		$data['FirstName'] = $FirstName;
		$data['OtherName'] = $OtherName;
		$data['Full_Name2'] = implode(' ', $_jFullname);
		$data['InvestmentValue'] = str_replace(',', '', str_replace(' ', '', $InvestmentValue));
		$data['S4_Custodian'] = $S4_Custodian;
		$data['CustodianAccount'] = $CustodianAccount;
		$data['CHN'] = $CHN;
		$data['AccountType'] = $AccountType;
		$data['Title'] = $Title;
		$data['Occupation'] = $Occupation;
		$data['Email'] = $Email;
		$data['PhoneNo'] = $PhoneNo;
		$data['Address'] = $Address;
		$data['ID_Type'] = $ID_Type;
		$data['ID_Type2'] = $ID_Type2;
		$data['IDNo'] = $IDNo;
		$data['IDNo2'] = $IDNo2;
		$data['NextOfKin'] = $NextOfKin;
		$data['MotherMaidenName'] = $MotherMaidenName;
		$data['DOB'] = !empty($DOB) ? $DOB : date("Y-m-d");
		$data['Bank'] = $Bank;
		$data['BankAccount'] = $BankAccount;
		$data['BVN'] = $BVN;

		$data['Residency'] = !empty($Residency) ? $Residency : '';
		$data['Occupation2'] = $Occupation2;
		$data['EmailAddress2'] = $EmailAddress2;
		$data['Phone_No2'] = $Phone_No2;
		$data['Address2'] = $Address2;
		$data['MotherMaidName2'] = $MotherMaidName2;
		$data['DOB2'] = !empty($DOB2) ? $DOB2 : date("Y-m-d");
		$data['Bank2'] = $Bank2;
		$data['BankAccount2'] = $BankAccount2;
		$data['BVN2'] = $BVN2;
		$data['Company_Name'] = $Company_Name;
		$data['Type_of_Business'] = $Type_of_Business;
		$data['RC_No'] = $RC_No;
		$data['Contact_Person'] = $Contact_Person;
		$data['InvestorCategory'] = !empty($InvestorCategory) ? $_InvestorCategory : '';
		$data['Application_Date'] = date("Y-m-d");
		$data['ApplicationID'] = 0;
		$data['Authorised_Dealer'] = "";
		$data['BD_Date'] = date("Y-m-d");
		$data['BD_User_ID'] = "";
		$data['DataEntryDate'] = date("Y-m-d");
		$data['Status'] = $payment['payment_method'] == 'online' ? "Awaiting Fincon Review" : "Awaiting BD Review";

		$serial_no = generate_serial_no();
		$data['Extra'] = $serial_no;
		$data['Extra1'] = date("Y-m-d H:i:s");
		$data['Extra2'] = $payment['payment_method'] == 'online' ? $payment['txnref'] : "";
		$data['Extra3'] = "";
		$data['Extra4'] = "";
		$data['FIncon_Date'] = date("Y-m-d");
		$data['Fincon_User_ID'] = "";
		$data['Reject_Comment'] = "";
		$data['Sukuk_Type'] = $Sukuk_Type;
		$data['UnitQuantity'] = $UnitPrice > 0 ? $InvestmentValue / $UnitPrice : 0;
		$data['USSD_Duration'] = 0;
		$data['Receiving_Bank'] = _SUKUK_RECEIVING_BANK;

		$signature = $Signature = false;
		$_ja_signature = $_Ja_signature = false;
		$_company_signature = $_Company_signature = false;

		$proof_of_payment = $payment['payment_method'] == 'deposit' ? 'slips/' . $payment['teller'] : false;

		$allowed_types = array('image/jpeg', 'image/png');
		$max_upload_size = _SUKUK_MAX_UPLOAD_SIZE; // MB
		if (!empty($_FILES['signature']['name'])) {
			if (!in_array($_FILES['signature']['type'], $allowed_types)) _return_error("Invalid image type uploaded for Applicant signature");
			if ($_FILES['signature']['size'] > file_size_to_byte($max_upload_size, 'mb')) _return_error("Applicant signature image is greated than " . $max_upload_size . "MB allowed");
			$ext = get_extension($_FILES['signature']['name']);
			$Signature = 'signature-' . mt_rand(10000000000, 999999999999) . $ext;
			$sign_file = 'images/signatures/' . $Signature;
			if (!move_uploaded_file($_FILES['signature']['tmp_name'], $sign_file)) _return_error("Applicant Signature upload error");
		}
		if (!empty($_FILES['ja_signature']['name'])) {
			if (!in_array($_FILES['ja_signature']['type'], $allowed_types)) _return_error("Invalid image type uploaded for Joint account signature");
			if ($_FILES['ja_signature']['size'] > file_size_to_byte($max_upload_size, 'mb')) _return_error("Joint Applicant signature image is greated than " . $max_upload_size . "MB allowed");
			$ext = get_extension($_FILES['ja_signature']['name']);
			$_Ja_signature = 'signature-' . mt_rand(10000000000, 999999999999) . $ext;
			$sign_file = 'images/signatures/' . $_Ja_signature;
			if (!move_uploaded_file($_FILES['ja_signature']['tmp_name'], $sign_file)) _return_error("Joint Applicant Signature upload error");
		}
		if (!empty($_FILES['company_signature']['name'])) {
			if (!in_array($_FILES['company_signature']['type'], $allowed_types)) _return_error("Invalid image type uploaded for Corporate account signature");
			if ($_FILES['company_signature']['size'] > file_size_to_byte($max_upload_size, 'mb')) _return_error("Corporate account signature image is greated than " . $max_upload_size . "MB allowed");
			$ext = get_extension($_FILES['company_signature']['name']);
			$_Company_signature = 'signature-' . mt_rand(10000000000, 999999999999) . $ext;
			$sign_file = 'images/signatures/' . $_Company_signature;
			if (!move_uploaded_file($_FILES['company_signature']['tmp_name'], $sign_file)) _return_error("Corporate account Signature upload error");
		}

		if ($Signature) $signature = 'images/signatures/' . $Signature;
		if ($_Ja_signature) $_ja_signature = 'images/signatures/' . $_Ja_signature;
		if ($_Company_signature) $_company_signature = 'images/signatures/' . $_Company_signature;

		// INSERT DATA TO LOCAL DATABASE
		$this->db->insert("applications", $data);
		$insert_id = $this->db->insert_id();
		if ($this->post_form_to_api) {
			$Message = postSukuk($data, $insert_id, [$signature, $_ja_signature, $_company_signature]);
		} else {
			$Message['Message'] = 'success';
		}

		if ($Message['Message'] != 'success') {
			if ($this->continue_on_api_error) {
				$Message['Message'] = 'success';
				unlink_files([$signature, $_ja_signature, $_company_signature]);
			} else {
				unlink_files([$signature, $_ja_signature, $_company_signature]);
				_return_error('An Error was encountered white submitting your application. Please try again.  ' . $Message['Message']);
			}
		}
		if ($Message['Message'] == 'success') {
			//POST PAYMENT IF ONLINE
			$payment['ApplicationID'] = $Message['ApplicationID'];
			if ($payment['payment_method'] == 'online') {
				$sukuktopup = sukukTopup($payment['app_ref']);
				if ($sukuktopup && $sukuktopup['response']['Success']) {
					$this->db->update("transactions", ["processed" => "1", "completed" => "1"], ["txnref" => $payment['txnref']]);
					$UpdateData = [
						'status_updated' => '1',
						'topup_updated' => $sukuktopup['topup_updated'],
						'topup_response' => $sukuktopup['topup_response']
					];
					$this->db->update("applications", $UpdateData, ["id" => $insert_id]);
				} else {
					$this->db->delete("applications", ["id" => $insert_id]);
					_return_error('An Error was encountered white submitting your application. Please try again.');
				}
			} else {
				$payment['channel'] = 'Deposit';
				$this->db->update("applications", ['status_updated' => '1'], ["id" => $insert_id]);
			}


			$naira = '<span class="dlt">N</span>';
			$check_mark = 'images/check.png';
			$checked  = ' <strong>[X]</strong> ';
			$logo = 'images/coat-of-arms.png';
			$stamp = 'images/stamp.png';

			$recipient_email = $Email;
			if ($AccountType == 'individual') {
				$_ja_signature = false;
				$_company_signature = false;

				$ID_Type2 = '';
				$IDNo2 = '';
				$Occupation2 = '';
				$EmailAddress2 = '';
				$Phone_No2 = '';
				$Address2 = '';
				$MotherMaidName2 = '';
				$DOB2 = '';
				$Bank2 = '';
				$BankAccount2 = '';
				$BVN2 = '';
				$_ja_title = '';
				$_ja_surname = '';
				$_ja_firstname = '';
				$_ja_otherName = '';
				$_ja_next_of_kin = '';
				$_ja_residency = '';

				$Company_Name = '';
				$Type_of_Business = '';
				$RC_No = '';
				$_company_address = '';
				$Contact_Person = '';
				$_company_email = '';
				$_company_telephone = '';
				$_company_bank_name = '';
				$_company_bank_account_no = '';
				$_company_bvn = '';
			} else if ($AccountType == 'joint') {
				$_company_signature = false;
				$_company_address = '';
				$Contact_Person = '';
				$_company_email = '';
				$_company_telephone = '';
				$_company_bank_name = '';
				$_company_bank_account_no = '';
				$_company_bvn = '';
			} else if ($AccountType == 'corporate') {
				$signature = false;
				$_ja_signature = false;
				$_jFullname = array();
				$_Fullname = array();
				$Title = '';
				$Surname = '';
				$FirstName = '';
				$OtherName = '';
				$Occupation = '';
				$Email = '';
				$PhoneNo = '';
				$Address = '';
				$ID_Type = '';
				$ID_Type2 = '';
				$IDNo = '';
				$IDNo2 = '';
				$NextOfKin = '';
				$MotherMaidenName = '';
				$DOB = '';
				$Bank = '';
				$BankAccount = '';
				$BVN = '';
				$Residency = '';
				$Occupation2 = '';
				$EmailAddress2 = '';
				$Phone_No2 = '';
				$Address2 = '';
				$MotherMaidName2 = '';
				$DOB2 = '';
				$Bank2 = '';
				$BankAccount2 = '';
				$BVN2 = '';
				$_ja_title = '';
				$_ja_surname = '';
				$_ja_firstname = '';
				$_ja_otherName = '';
				$_ja_next_of_kin = '';
				$_ja_residency = '';
			}

			$dompdf = new Dompdf();

			ob_start();
		?>
			<style>
				.dlt {
					text-decoration: line-through;
					text-decoration-style: double;
				}

				.pdf td,
				.font {
					font-family: 'roboto condensed';
					line-height: 90% !important;
				}

				.dbb {
					border-bottom: 1px dashed #DBDBDB;
					padding-top: 5px;
					padding-bottom: 5px;
					height: 15px !important;
				}

				.dashed {
					border-bottom: 1px dashed #DBDBDB;
					padding-top: 5px;
					padding-bottom: 5px;
				}

				.value {
					font-family: 'normal Helvetica', Arial, sans-serif !important;
				}

				.formvalue {
					font-family: 'normal Helvetica', Arial, sans-serif !important;
					line-height: 25px !important;
					font-size: 13px !important;
				}

				.formvalue.box {
					width: 15px;
					height: 22px;
					text-align: center;
					font-size: 13px !important;
					font-weight: bold !important;
					/*line-height: 18px!important;*/
				}

				.formvalue.smallbox {
					width: 15px;
					height: 18px;
					text-align: center;
					line-height: 12px !important;
					padding: 2px !important;
					font-size: 13px !important;
					font-weight: bold !important;
				}

				.formdata td {
					font-size: 13px !important;
				}

				.size9 {
					font-size: 9px !important;
				}

				.size10 {
					font-size: 10px !important;
				}

				.size11 {
					font-size: 11px !important;
				}

				.size12 {
					font-size: 12px !important;
				}

				.size13 {
					font-size: 13px !important;
				}

				.size14 {
					font-size: 14px !important;
				}

				.size15 {
					font-size: 15px !important;
				}

				.size16 {
					font-size: 16px !important;
				}

				.size18 {
					font-size: 18px !important;
				}

				.size20 {
					font-size: 20px !important;
				}

				.bold {
					font-weight: bold !important;
				}

				.green {
					color: #00A44B;
				}

				.brown {
					color: #C45911;
				}

				.lineHeightNormal {
					line-height: 90% !important;
				}

				.lineHeight {
					line-height: 140% !important;
				}

				.border {
					border: 1px solid #DBDBDB;
				}

				.bt {
					border-top: 1px solid #DBDBDB;
				}

				.br {
					border-right: 1px solid #DBDBDB;
				}

				.bb {
					border-bottom: 1px solid #DBDBDB;
				}

				.bl {
					border-left: 1px solid #DBDBDB;
				}

				.pt {
					padding-top: 5px !important;
				}

				.pr {
					padding-right: 12px !important;
				}

				.pb {
					padding-bottom: 5px !important;
				}

				.pl {
					padding-left: 12px !important;
				}

				.mt {
					margin-top: 10px !important;
				}

				.mr {
					margin-right: 12px !important;
				}

				.mb {
					margin-bottom: 10px !important;
				}

				.ml {
					margin-left: 12px !important;
				}

				.relative {
					position: relative;
				}

				.absolute {
					position: absolute;
				}

				.text-center {
					text-align: center;
				}

				.formvalue1 {
					font-family: 'normal Helvetica', Arial, sans-serif !important;
					line-height: 25px !important;
					font-size: 13px !important;
				}

				.formvalue1 {
					width: 15px;
					height: 22px;
					text-align: center;
					font-size: 13px !important;
					font-weight: bold !important;
				}

				.formvalue1 {
					width: 15px;
					height: 18px;
					text-align: center;
					line-height: 12px !important;
					padding: 2px !important;
					font-size: 13px !important;
					font-weight: bold !important;
				}

				.square {
					width: 25px;
					height: 25px;
					border: 1px solid #ddd;
				}
			</style>
			<table class="pdf" style="page-break-after: always;" width="740px" border="0" cellspacing="0" cellpadding="0">
				<tbody>
					<tr>
						<td>
							<table width="100%" border="0" cellspacing="0" cellpadding="0">
								<tbody>
									<tr>
										<td width="40%" class="size13 lineHeightNormal">To:<br>
											FGN Roads Sukuk Company 1 Plc.,<br>
											Debt Management Office,<br>
											Abuja<br></td>
										<td width="25%" align="center"><img src="<?php echo $logo; ?>" width="68" height="58" alt="" /></td>
										<td width="40%" align="right" valign="top">
											<table width="140" border="0" align="right" cellpadding="0" cellspacing="0">
												<tbody>
													<tr align="left" valign="top">
														<td>No:</td>
														<td width="120">
															<table width="120" border="0" cellpadding="0" cellspacing="0">
																<tbody>
																	<tr>
																		<td align="center" class="bt bl bb formvalue box">&nbsp;</td>
																		<td align="center" class="bt bl bb formvalue box">&nbsp;</td>
																		<td align="center" class="bt bl bb formvalue box">&nbsp;</td>
																		<td align="center" class="bt bl bb formvalue box">&nbsp;</td>
																		<td align="center" class="bt bl bb formvalue box">&nbsp;</td>
																		<td align="center" class="bt bl bb formvalue box">&nbsp;</td>
																		<td align="center" class="bt bl bb br formvalue box">&nbsp;</td>
																	</tr>
																</tbody>
															</table>
															<div class="text-center size12">Official use only</div>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
					<tr>
						<td style="padding: 0px!important;">
							<div align="center" style="width: 100%; padding: 10px; margin-top: 5px; margin-bottom: 5px; border: 1px solid #000; border-radius: 15px;">
								<div style="width: 100%;" class="green size20 bold lineHeightNormal"><?php echo strtoupper($app_title); ?> ON BEHALF OF THE FEDERAL GOVERNMENT OF NIGERIA</div>
								<div style="width: 100%;" class="size11 lineHeightNormal">Applications must be made in accordance with the instructions set out on the back of this application form. Care must be taken to follow these instructions as applications that do not comply with the instructions may be rejected. Please consult your Financial or Legal Advisers for guidance before completing this Form</div>
							</div>
						</td>
					</tr>
					<tr>
						<td align="center" class="size12 text-center" style="padding-bottom: 5px;">
							In response to the advertisement in both print and electronic media, I/We hereby offer my/our subscription for FGN Sukuk</td>
					</tr>
					<tr>
						<td align="center" valign="top">
							<table width="98%" border="0" cellspacing="0" cellpadding="0">
								<tbody>
									<tr>
										<td width="73%" align="left" valign="top">
											<table width="100%" border="0" cellspacing="0" cellpadding="0">
												<tbody>
													<tr>
														<td width="5%" align="right" class="pr"><span class="size14 bold">A</span></td>
														<td width="95%" align="left" valign="top">
															<table width="100%" border="0" cellspacing="0" cellpadding="0">
																<tbody>
																	<tr>
																		<td width="42%" align="left" valign="top" nowrap="nowrap" class="bt bl pl pt pb">
																			<div class="brown size14 bold ">Guide to Application </div>
																		</td>
																		<td width="58%" align="left" valign="top" nowrap="nowrap" class="size14 bt bl pl pt pb">
																			<table width="140" border="0" cellpadding="0" cellspacing="0">
																				<tbody>
																					<tr>
																						<td class="pr"><span class="size13">Date:</span></td>
																						<td width="140" class="pt">
																							<table width="140" border="0" cellpadding="0" cellspacing="0">
																								<tbody>
																									<?php $arr = str_split(date("dmY")); ?>
																									<tr>
																										<?php foreach ($arr as $value) { ?>
																											<td align="center" class="bt bl bb br formvalue box"><?php echo $value; ?></td>
																										<?php } ?>
																									</tr>
																								</tbody>
																							</table>
																						</td>
																					</tr>
																				</tbody>
																			</table>
																		</td>
																	</tr>
																	<tr>
																		<td align="left" valign="top" nowrap="nowrap" class="bt bl pt pl">
																			<span class="bold size13">Minimum Value:</span> <?php echo '&#8358;'; ?>10,000.00<br>
																			<span class="bold size13">Multiple thereafter:</span> <?php echo '&#8358;'; ?>1,000.00
																		</td>
																		<td align="left" valign="top" nowrap="nowrap" class="bt bl pt pl">
																			<div class="bold size13 mb">Value of Sukuk Applied for in <?php echo '&#8358;'; ?></div>
																			<div class="size20 value mb"><?php echo '&#8358;' . number_format(str_replace(',', '', str_replace(' ', '', $InvestmentValue)), 2); ?></div>
																		</td>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
													<tr>
														<td align="right" class=" pr"><span class="size14 bold">B</span></td>
														<td align="left" valign="top" class="bt bl bb pt pl">
															<span class="brown bold size14">Amount in Words</span>
															<div class="size14 bold value mt mb"><?php echo $amount_in_words; ?></div>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
										<td width="27%" valign="top" class="border">
											<table width="100%" border="0" cellspacing="0" cellpadding="0">
												<tbody>
													<tr>
														<td align="left" valign="top" class="pt pr pl bb">
															<div class="size14 bold brown">E-allotment Details</div>
															<div class="size12">Applicant's S4/Custodian A/C No.</div>
															<table width="140" border="0" cellpadding="0" cellspacing="0" class="mb">
																<tbody>
																	<?php $_S4_Custodian = str_split($S4_Custodian); ?>
																	<tr>
																		<?php for ($i = 0; $i < 12; $i++) { ?>
																			<td align="center" class="bt bl bb br formvalue box"><?php echo array_key_exists($i, $_S4_Custodian) ? $_S4_Custodian[$i] : '&nbsp;'; ?></td>
																		<?php } ?>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
													<tr>
														<td align="left" valign="top" class="pr pl">
															<div class="size12">Applicant's CSCC A/C No.</div>
															<table width="140" border="0" cellpadding="0" cellspacing="0">
																<tbody>
																	<?php $_CustodianAccount = str_split($CustodianAccount); ?>
																	<tr>
																		<?php for ($i = 0; $i < 8; $i++) { ?>
																			<td align="center" class="bt bl bb br formvalue box"><?php echo array_key_exists($i, $_CustodianAccount) ? $_CustodianAccount[$i] : '&nbsp;'; ?></td>
																		<?php } ?>
																	</tr>
																</tbody>
															</table>
															<div class="size12">Applicant's Clearing House No. (CHN)</div>
															<table width="140" border="0" cellpadding="0" cellspacing="0" class="mb">
																<tbody>
																	<?php $_CHN = str_split($CHN); ?>
																	<tr>
																		<?php for ($i = 0; $i < 8; $i++) { ?>
																			<td align="center" class="bt bl bb br formvalue box"><?php echo array_key_exists($i, $_CHN) ? $_CHN[$i] : '&nbsp;'; ?></td>
																		<?php } ?>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
					<tr>
						<td align="center" class="pt">
							<table width="100%" border="0" cellspacing="0" cellpadding="0">
								<tbody>
									<tr>
										<td width="50%">
											<div class="green mb size14 bold">1. Individual Applicants (to be completed in block letters)</div>
										</td>
										<td width="50%">
											<div class="green mb size14 bold">2. Joint Applicants (to be completed in block letters)</div>
										</td>
									</tr>
									<tr valign="top">
										<td width="50%" align="left" class="pl" style="padding-right: 5px;">
											<table class="formdata pt pb" width="100%" border="0" cellspacing="0" cellpadding="0">
												<tbody>
													<tr>
														<td colspan="2" align="left" valign="top" class="dbb relative">
															Full Name (Surname first)&nbsp;&nbsp;&nbsp;&nbsp;
															<div style="left: 140px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper(implode(' ', $_Fullname)); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" align="center" nowrap="nowrap" class="dbb formvalue">&nbsp;</td>
													</tr>
													<tr>
														<td colspan="2" align="center" valign="top" nowrap="nowrap">(State titles if any e.g. Mr. Mrs. Miss)</td>
													</tr>
													<tr>
														<td colspan="2" nowrap="nowrap" class="dbb">
															Occupation&nbsp;&nbsp;&nbsp;&nbsp;<span class="bold formvalue"><?php echo strtoupper($Occupation); ?></span>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Phone No.: <div style="left: 60px; top: 3px" class="bold absolute">
																<table border="0" cellpadding="2" cellspacing="0" class="">
																	<tbody>

																		<?php $_PhoneNo = str_split($PhoneNo); ?>
																		<tr>
																			<?php for ($i = 0; $i < 14; $i++) { ?>
																				<?php if ($i == 3) { ?><td align="center" class="bl ">&nbsp;</td><?php } ?>
																				<td align="center" class="bt bl bb br formvalue smallbox"><?php echo array_key_exists($i, $_PhoneNo) ? $_PhoneNo[$i] : '&nbsp;'; ?></td>
																			<?php } ?>
																		</tr>
																	</tbody>
																</table>
															</div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">
															Address&nbsp;&nbsp;&nbsp;&nbsp;
															<div style="left: 60px; top: -5px; height: 50px; max-height: 50px; overflow:hidden;" class="bold formvalue absolute"><?php echo strtoupper($Address); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb ">&nbsp;</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Passport/Driving License/National ID No: <div style="left: 220px; top: -5px" class="bold formvalue absolute"><?php echo $IDNo; ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" style="padding: 0px!important;">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="">
																<tr>
																	<td width="40%" class="dbb relative">Date of Birth <div style="left: 70px; top: -5px" class="bold formvalue absolute"><?php echo $DOB; ?></div>
																	</td>
																	<td width="60%" class="dbb relative">Mother's Maiden Name<div style="left: 125px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($MotherMaidenName); ?></div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>

													<tr>
														<td colspan="2" class="dbb relative">Email Address<div style="left: 80px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($Email); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Next of Kin:<div style="left: 80px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($NextOfKin); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Name of Bank <div style="left: 90px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($Bank); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Bank Account No.: <div style="left: 90px; top: 3px" class="bold absolute">
																<table border="0" cellpadding="0" cellspacing="0" class="">
																	<tbody>
																		<?php $_BankAccount = str_split($BankAccount); ?>
																		<tr>
																			<?php for ($i = 0; $i < 10; $i++) { ?>
																				<td align="center" class="bt bl bb br formvalue smallbox"><?php echo array_key_exists($i, $_BankAccount) ? $_BankAccount[$i] : '&nbsp;'; ?></td>
																			<?php } ?>
																		<tr>
																	</tbody>
																</table>
															</div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">BVN:
															<div style="left: 90px; top: 3px" class="bold absolute">
																<table border="0" cellpadding="0" cellspacing="0" class="">
																	<tbody>
																		<?php $_BVN = str_split($BVN); ?>
																		<tr>
																			<?php for ($i = 0; $i < 11; $i++) { ?>
																				<td align="center" class="bt bl bb br formvalue smallbox"><?php echo array_key_exists($i, $_BVN) ? $_BVN[$i] : '&nbsp;'; ?></td>
																			<?php } ?>
																		<tr>
																	</tbody>
																</table>
															</div>
														</td>
													</tr>
													<tr>
														<td colspan="2" align="center" class=" relative pt pb"><strong class="brown">(*Must be completed)</strong><br>
															<strong>For rental payment purpose</strong>
														</td>
													</tr>
													<tr>
														<td colspan="2" style="padding: 0px!important;">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="">
																<tr>
																	<?php /*?><td width="60%" class="dbb relative">Usual Signature: <div style="left: 90px; top: 0px" class="bold formvalue absolute"><?php if($signature){ ?><img src="<?php echo $signature; ?>" width="100" height="30" alt=""/><?php } ?></div></td><?php */ ?>
																	<td colspan="2" class="dbb relative">Date: <div style="left: 50px; top: -5px" class="bold formvalue absolute"><?php if ($AccountType == 'individual' || $AccountType == 'joint') echo date("d/m/Y"); ?></div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="pt">Residency classification of Applicant (tick the Appropriate box)<br>
															<table border="0" cellpadding="2" cellspacing="0" class="">
																<tbody>
																	<tr>
																		<?php $Residency = !empty($Residency) ? $Residency : false; ?>
																		<td nowrap="nowrap" style="height: 20px;">Resident</td>
																		<td align="center" class="bt bl bb br formvalue smallbox"><?php echo $Residency == 'resident' ? $checked : '&nbsp;'; ?></td>
																		<td align="center" nowrap="nowrap" style="height: 20px;">&nbsp;&nbsp;&nbsp;Non-Resident</td>
																		<td align="center" class="bt bl bb br formvalue smallbox"><?php echo $Residency == 'non resident' ? $checked : '&nbsp;'; ?></td>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
										<td width="50%" align="left" style="padding-left: 5px;">
											<table class="formdata pt pb" width="100%" border="0" cellspacing="0" cellpadding="0">
												<tbody>
													<tr>
														<td colspan="2" align="left" valign="top" class="dbb relative">
															Full Name (Surname first)&nbsp;&nbsp;&nbsp;&nbsp;
															<div style="left: 140px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper(implode(' ', $_jFullname)); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" align="center" nowrap="nowrap" class="dbb formvalue">&nbsp;</td>
													</tr>
													<tr>
														<td colspan="2" align="center" valign="top" nowrap="nowrap">(State titles if any e.g. Mr. Mrs. Miss)</td>
													</tr>
													<tr>
														<td colspan="2" nowrap="nowrap" class="dbb">
															Occupation&nbsp;&nbsp;&nbsp;&nbsp;<span class="bold formvalue"><?php echo strtoupper($Occupation2); ?></span>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Phone No.: <div style="left: 60px; top: 3px" class="bold absolute">
																<table border="0" cellpadding="2" cellspacing="0" class="">
																	<tbody>

																		<?php $_Phone_No2 = str_split($Phone_No2); ?>
																		<tr>
																			<?php for ($i = 0; $i < 14; $i++) { ?>
																				<?php if ($i == 3) { ?><td align="center" class="bl ">&nbsp;</td><?php } ?>
																				<td align="center" class="bt bl bb br formvalue smallbox"><?php echo array_key_exists($i, $_Phone_No2) ? $_Phone_No2[$i] : '&nbsp;'; ?></td>
																			<?php } ?>
																		</tr>
																	</tbody>
																</table>
															</div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">
															Address&nbsp;&nbsp;&nbsp;&nbsp;
															<div style="left: 60px; top: -5px; height: 50px; max-height: 50px; overflow:hidden;" class="bold formvalue absolute"><?php echo strtoupper($Address2); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb ">&nbsp;</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Passport/Driving License/National ID No: <div style="left: 220px; top: -5px" class="bold formvalue absolute"><?php echo $IDNo2; ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" style="padding: 0px!important;">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="">
																<tr>
																	<td width="40%" class="dbb relative">Date of Birth <div style="left: 70px; top: -5px" class="bold formvalue absolute"><?php echo $DOB2; ?></div>
																	</td>
																	<td width="60%" class="dbb relative">Mother's Maiden Name<div style="left: 125px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($MotherMaidName2); ?></div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>

													<tr>
														<td colspan="2" class="dbb relative">Email Address<div style="left: 80px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($EmailAddress2); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Next of Kin:<div style="left: 80px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($_ja_next_of_kin); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Name of Bank <div style="left: 90px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($Bank2); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Bank Account No.: <div style="left: 90px; top: 3px" class="bold absolute">
																<table border="0" cellpadding="0" cellspacing="0" class="">
																	<tbody>
																		<?php $_BankAccount2 = str_split($BankAccount2); ?>
																		<tr>
																			<?php for ($i = 0; $i < 10; $i++) { ?>
																				<td align="center" class="bt bl bb br formvalue smallbox"><?php echo array_key_exists($i, $_BankAccount2) ? $_BankAccount2[$i] : '&nbsp;'; ?></td>
																			<?php } ?>
																		<tr>
																	</tbody>
																</table>
															</div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">BVN:
															<div style="left: 90px; top: 3px" class="bold absolute">
																<table border="0" cellpadding="0" cellspacing="0" class="">
																	<tbody>
																		<?php $_BVN2 = str_split($BVN2); ?>
																		<tr>
																			<?php for ($i = 0; $i < 11; $i++) { ?>
																				<td align="center" class="bt bl bb br formvalue smallbox"><?php echo array_key_exists($i, $_BVN2) ? $_BVN2[$i] : '&nbsp;'; ?></td>
																			<?php } ?>
																		<tr>
																	</tbody>
																</table>
															</div>
														</td>
													</tr>
													<tr>
														<td colspan="2" align="center" class=" relative pt pb"><strong class="brown">(*Must be completed)</strong><br>
															<strong>For rental payment purpose</strong>
														</td>
													</tr>
													<tr>
														<td colspan="2" style="padding: 0px!important;">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="">
																<tr>
																	<?php /*?><td width="60%" class="dbb relative">Usual Signature: 
                                <div style="left: 90px; top: 0px" class="bold formvalue absolute"><?php if($_ja_signature){ ?><img src="<?php echo $_ja_signature; ?>" width="100" height="30" alt=""/><?php } ?></div>
                                </td><?php */ ?>
																	<td colspan="2" class="dbb relative">Date: <div style="left: 50px; top: -5px" class="bold formvalue absolute"><?php if ($AccountType == 'joint') echo date("d/m/Y"); ?></div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="pt">Residency classification of Applicant (tick the Appropriate box)<br>
															<table border="0" cellpadding="2" cellspacing="0" class="">
																<tbody>
																	<tr>
																		<?php $_ja_residency = !empty($_ja_residency) ? $_ja_residency : false; ?>
																		<td nowrap="nowrap" style="height: 20px;">Resident</td>
																		<td align="center" class="bt bl bb br formvalue smallbox"><?php echo $_ja_residency == 'resident' ? $checked : '&nbsp;'; ?></td>
																		<td align="center" nowrap="nowrap" style="height: 20px;">&nbsp;&nbsp;&nbsp;Non-Resident</td>
																		<td align="center" class="bt bl bb br formvalue smallbox"><?php echo $_ja_residency == 'non resident' ? $checked : '&nbsp;'; ?></td>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
								</tbody>
							</table>
							<table width="100%" border="0" cellspacing="0" cellpadding="0">
								<tbody>
									<tr align="left" valign="top">
										<td width="50%">
											<div class="green mt mb size14 bold">3. Corporate Applicants (to be completed in block letters)</div>
											<table class="formdata ml" width="100%" border="0" cellspacing="0" cellpadding="0">
												<tbody>
													<tr>
														<td class="dbb relative" colspan="2">Company Name&nbsp;&nbsp;&nbsp;&nbsp;
															<div style="left: 100px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($Company_Name); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" style="padding: 0px!important;">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="">
																<tr>
																	<td width="70%" class="dbb relative">Type of Business
																		<div style="height: 25px; overflow:hidden; left: 100px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($Type_of_Business); ?></div>
																	</td>
																	<td width="30%" class="dbb relative">R/C No:
																		<div style="left: 50px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($RC_No); ?></div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative"> Address&nbsp;&nbsp;&nbsp;&nbsp;
															<div style="left: 50px; top: -5px; height: 50px; max-height: 50px; overflow:hidden;" class="bold formvalue absolute"><?php echo strtoupper($_company_address); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb ">&nbsp;</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Email Address
															<div style="left: 80px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($_company_email); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Contact Person:
															<div style="left: 90px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($Contact_Person); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Phone No.:
															<div style="left: 60px; top: 3px" class="bold absolute">
																<table border="0" cellpadding="2" cellspacing="0" class="">
																	<tbody>
																		<?php $__company_telephone = str_split($_company_telephone); ?>
																		<tr>
																			<?php for ($i = 0; $i < 14; $i++) { ?>
																				<?php if ($i == 3) { ?><td align="center" class="bl ">&nbsp;</td><?php } ?>
																				<td align="center" class="bt bl bb br formvalue smallbox"><?php echo array_key_exists($i, $__company_telephone) ? $__company_telephone[$i] : '&nbsp;'; ?></td>
																			<?php } ?>
																		</tr>
																	</tbody>
																</table>
															</div>
														</td>
													</tr>
													<?php /*?><tr>
						  <td colspan="2" style="padding-top: 8px; padding-bottom: 8px;" class="dbb relative">Signature:
                          <div style="left: 80px; top: 0px" class="bold formvalue absolute"><?php if($_company_signature){ ?><img src="<?php echo $_company_signature; ?>" width="100" height="30" alt=""/><?php } ?></div>
						 </td>
						</tr><?php */ ?>
													<tr>
														<td colspan="2" class="dbb relative">Name of Bank
															<div style="left: 90px; top: -5px" class="bold formvalue absolute"><?php echo strtoupper($_company_bank_name); ?></div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">Bank Account No.:
															<div style="left: 100px; top: 3px" class="bold absolute">
																<table border="0" cellpadding="0" cellspacing="0" class="">
																	<tbody>
																		<?php $__company_bank_account_no = str_split($_company_bank_account_no); ?>
																		<tr>
																			<?php for ($i = 0; $i < 10; $i++) { ?>
																				<td align="center" class="bt bl bb br formvalue smallbox"><?php echo array_key_exists($i, $__company_bank_account_no) ? $__company_bank_account_no[$i] : '&nbsp;'; ?></td>
																			<?php } ?>
																	</tbody>
																</table>
															</div>
														</td>
													</tr>
													<tr>
														<td colspan="2" class="dbb relative">BVN:
															<div style="left: 100px; top: 3px" class="bold absolute">
																<table border="0" cellpadding="0" cellspacing="0" class="">
																	<tbody>
																		<?php $__company_bvn = str_split($_company_bvn); ?>
																		<tr>
																			<?php for ($i = 0; $i < 11; $i++) { ?>
																				<td align="center" class="bt bl bb br formvalue smallbox"><?php echo array_key_exists($i, $__company_bvn) ? $__company_bvn[$i] : '&nbsp;'; ?></td>
																			<?php } ?>
																		<tr>
																	</tbody>
																</table>
															</div>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
										<td width="50%" align="left" style="padding-left: 5px;">
											<table class="formdata bt br bb bl pt pr pb pl" width="100%" border="0" cellspacing="0" cellpadding="0">
												<tbody>
													<tr>
														<td colspan="2">
															<table width="100%" border="0" cellspacing="0" cellpadding="0">
																<tbody>
																	<tr>
																		<td width="10%" height="40" align="center" valign="middle" class="formdata size16 brown br bb">C</td>
																		<td width="90%" align="left" valign="middle" class="formdata size16 brown bb pl bold">Thumb print of illiterate applicant</td>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="2" align="left" valign="top" class="">
															<div class="pt pb pl formvalue"> <strong>Witness: </strong><br>
																<br>
																I……………………………………………have given detailed explanation to this applicant in the language understood by him and consequently the applicant has a clear understanding of the transaction he/she has entered into.<br>
																<br>
																<br>
																Signature: ……………………………………....
															</div>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>
								</tbody>
							</table>
							<table width="100%" border="0" cellspacing="0" cellpadding="0" class="mt bt">
								<tbody>
									<tr align="left" valign="top">
										<td align="center" class="pt size12"> Page 1 of 2 - <?php echo $ref_id; ?>/<?php echo $serial_no; ?></td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
			<table class="pdf" width="740px" border="0" cellspacing="0" cellpadding="0">
				<tbody>
					<tr>
						<td align="center" class="pt">
							<table width="100%" border="0" cellspacing="0" cellpadding="0">
								<tbody>
									<tr valign="top">
										<td width="50%" align="left" style="padding-right: 5px;">
											<table class="formdata bt br bb bl pt pr pb pl" width="100%" border="0" cellspacing="0" cellpadding="0">
												<tbody>
													<tr>
														<td colspan="2">
															<table width="100%" border="0" cellspacing="0" cellpadding="0">
																<tbody>
																	<tr>
																		<td width="10%" height="40" align="center" valign="middle" class="formdata size16 brown br bb">D</td>
																		<td width="90%" align="left" valign="middle" class="formdata size16 brown bb pl bold">Financial Adviser</td>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="2" align="left" valign="top" class="">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="">
																<tr>
																	<td height="25" align="left" valign="top" class="pt pl">NAME:</td>
																</tr>
																<tr>
																	<td height="18" align="left" valign="middle" class="pl relative">CODE:
																		<div style="left: 270px; top: -5px" class="bold formvalue absolute"></div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</tbody>
											</table>
											<table class="formdata bt br bb bl pt pr pb pl" width="100%" border="0" cellspacing="0" cellpadding="0">
												<tbody>
													<tr>
														<td colspan="2">
															<table width="100%" border="0" cellspacing="0" cellpadding="0">
																<tbody>
																	<tr>
																		<td align="center" valign="middle" bgcolor="#000000" class="formdata size16 brown br bb pt pb size15" style="color: #fff;">OFFICE USE ONLY</td>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="2" align="left" valign="top" class="">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="">
																<tr>
																	<td width="50%" align="center" valign="top" class="pt font">
																		<p>Stamp of Financial <br>
																			Adviser/Placement <br>
																			Agent</p>
																		<p>&nbsp;</p>
																	</td>
																	<td align="left" valign="top" class="">
																		<table width="100%" border="0" cellspacing="3" cellpadding="0">
																			<tbody>
																				<tr>
																					<td align="left" valign="top" class="bt br bb bl pt pl font">Amount Applied for (N)
																						<p>&nbsp;</p>
																					</td>
																				</tr>
																				<tr>
																					<td align="left" valign="top" class="bt br bb bl pt pl font">Amount Allotted (N)
																						<p>&nbsp;</p>
																					</td>
																				</tr>
																			</tbody>
																		</table>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
										<td width="50%" align="left" style="padding-left: 5px;">
											<table class="formdata bt br bb bl pt pr pb pl" width="100%" border="0" cellspacing="0" cellpadding="0">
												<tbody>
													<tr>
														<td colspan="2">
															<table width="100%" border="0" cellspacing="0" cellpadding="0">
																<tbody>
																	<tr>
																		<td width="10%" height="40" align="center" valign="middle" class="formdata size16 brown br bb">E</td>
																		<td width="90%" align="left" valign="middle" class="formdata size16 brown bb pl bold">Investor Category of Applicant (tick the appropriate box)</td>
																	</tr>
																</tbody>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="2" align="left" valign="top" class="pt pb bb pl">
															<table width="100%" border="0" cellpadding="2" cellspacing="0" class="mt mr">
																<tbody>
																	<tr>
																		<td colspan="2" class="bb size13"><?php echo $InvestorCategory == 'Individual' ? $checked : '&nbsp;'; ?> Individual</td>
																	</tr>
																	<!-- <tr>
																		<td colspan="2" class="bb size13"><?php echo $InvestorCategory == 'Bank' ? $checked : '&nbsp;'; ?> Bank</td>
																	</tr> -->
																	<tr>
																		<td colspan="2" class="bb size13"><?php echo $InvestorCategory == 'Corporate' ? $checked : '&nbsp;'; ?> Corporate </td>
																	</tr>
																	<!-- <tr>
																		<td colspan="2" class="bb size13"><?php echo $InvestorCategory == 'Co-operative Society' ? $checked : '&nbsp;'; ?> Co-operative Society </td>
																	</tr> -->
																	<tr>
																		<td colspan="2" class="bb size13"><?php echo $InvestorCategory == 'Institutional' ? $checked : '&nbsp;'; ?> Institutional </td>
																	</tr>
																	<tr>
																		<td colspan="2" class="bb size13"><?php echo $InvestorCategory == 'Foreign Investor' ? $checked : '&nbsp;'; ?> Foreign Investor </td>
																	</tr>
																	<!-- <tr>
																		<td colspan="2" class="bb size13"><?php echo $InvestorCategory == 'Government Agencies' ? $checked : '&nbsp;'; ?> Government Agencies</td>
																	</tr>
																	<tr>
																		<td colspan="2" class="bb size13"><?php echo $InvestorCategory == 'Staff Scheme' ? $checked : '&nbsp;'; ?> Staff Scheme </td>
																	</tr>
																	<tr>
																		<td colspan="2" class="bb size13"><?php echo $InvestorCategory == 'Non-Bank Financial Institution' ? $checked : '&nbsp;'; ?> Non-Bank Financial Institution </td>
																	</tr>
																	<tr>
																		<td width="17%" class="size13"><?php echo $InvestorCategory == 'Others' ? $checked : '&nbsp;'; ?> Others</td>
																		<td class=""><?php echo $InvestorCategory == 'Others' ? $InvestorCategoryOrder : '&nbsp;'; ?></td>
																	</tr> -->

																</tbody>
															</table>
														</td>
													</tr>
													<tr>
														<td colspan="2" align="center" valign="top" class="pt">
															<div class="font size14 bold pt">Please affix company seal and write RC Number</div>
															<p>&nbsp;</p>
															<p>&nbsp;</p>
														</td>
													</tr>
												</tbody>
											</table>
										</td>
									</tr>



								</tbody>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
			<table class="pdf" width="740px" border="0" cellspacing="0" cellpadding="0">
				<tbody>
					<tr>
						<td align="center" class="pt">
							<div style="margin-bottom: 80px; padding: 15px 25px; border: 1px solid #C1C1C1; background-color:#EFEFEF; font-size:14px;">
								<h3 style="text-decoration:underline; font-weight:bold;">DECLARATION AND SIGNATURE</h3>
								<p>I, <strong style="font-size: 130%;"><?php echo strtoupper($trxDeclarername); ?></strong>, declare that the information I have given in this application is truthful, complete and correct.</p>
								<p>I understand that any error in completing the application form may result in the rejection of my application. I agree that any false information or misrepresentation may constitute an offence under applicable laws in Nigeria</p>
								<p>I agree that by checking the signature box below, I have electronically signed my application. I absolve the Issuer and its advisers of any defect or liability arising from this electronic superscription hereof</p>
								<div style="padding: 0px; font-weight:bold; line-height: 24px; vertical-align:middle;"> <img src="images/checkbox-clipart-free.png" style="display: inline-block; height: 24px; vertical-align: middle; margin: 0px;" alt="" /> I AGREED AND SIGNED</div>
							</div>
						</td>
					</tr>
				</tbody>
			</table>

			<table style="margin-top: 50px; " width="740px" border="0" cellspacing="0" cellpadding="0" class="mt">
				<tbody>
					<tr align="left" valign="top">
						<td align="center" class="pt bt size12"> Page 2 of 2 - <?php echo $ref_id; ?>/<?php echo $serial_no; ?></td>
					</tr>
				</tbody>
			</table>
<?php
			$form = ob_get_contents();
			ob_end_clean();
			$info['ref_id'] = $ref_id;
			$info['InvestmentValue'] = $InvestmentValue;
			$info['trxFullname'] = $trxFullname;
			$info['AccountType'] = $AccountType;
			$info['trxEmail'] = $trxEmail;
			$info['trxPhoneNo'] = $trxPhoneNo;
			$payment['AccountType'] = $AccountType;
			$subj = 'FGN SUKUK 4: Your Application has been Received!';
			$payment_message = success_email($payment);
			$dompdf->loadHtml($form);
			$dompdf->setPaper('legal', 'A4');
			$dompdf->render();
			$rand = rand();
			$file_name = 'sukuk-' . strtolower($ref_id) . '.pdf';
			$file = $dompdf->output();
			file_put_contents($file_name, $file);

			$mail = new PHPMailer(true);
			try {
				$mail->isMail();
				$mail->Mailer = "mail";                    // Send using MAIL or SMTP
				$mail->Host       = '';                    // Set the SMTP server to send through
				$mail->SMTPAuth   = true;                   // Enable SMTP authentication
				$mail->Username   = '';                     // SMTP username
				$mail->Password   = '';                               // SMTP password
				$mail->Port       = 465;           // TCP port to connect to
				$mail->setFrom(_SUKUK_EMAIL_SENDER, _SUKUK_EMAIL_SENDER_NAME);

				$bcc = defined('_SUKUK_EMAIL_RECIPIENT') ? _SUKUK_EMAIL_RECIPIENT : false;
				$bcc_email = !empty($bcc) ? explode(',', $bcc) : array();
				if (!empty($bcc_email)) {
					foreach ($bcc_email as $bcc_address) {
						$mail->addAddress(trim($bcc_address)); //$mail->addCC(trim($bcc_address))
					}
				}
				$mail->addAttachment($file_name); // Add attachments
				if ($proof_of_payment) $mail->addAttachment($proof_of_payment); // Add attachments
				$mail->isHTML(true); // Set email format to HTML
				$mail->Subject = $subj;
				$mail->Body    = $payment_message . get_footer('open', 'left', 'email');
				$mail->AltBody = $subj;

				// $mail->send();
				// $mail->clearAddresses();
				// $mail->clearAttachments();

				$mail->addAddress($recipient_email); 	// Name is optional
				$mail->send();
				$this->db->update("applications", array("email_sent" => "1"), array("id" => $insert_id));
			} catch (Exception $e) {
				// unlink_files([$signature, $_ja_signature, $_company_signature, $file_name]);
				// if ($proof_of_payment) unlink_files([$proof_of_payment]);
			}
			unlink_files([$signature, $_ja_signature, $_company_signature, $file_name]);
			if ($proof_of_payment) unlink_files([$proof_of_payment]);


			_return_success($data);
		}
	}
	//END CONTROLLER
}
