<?php
/*
 * --------------------------------------------------------------------
 * CUSTOM CONFIG BY PRINCE MORPHEUS
 * --------------------------------------------------------------------
 *
*/
$Localhost = array(
    'localhost',
    '127.0.0.1',
    '192.168.43.108',
    '192.168.43.1',
    '192.168.15.5',
    '192.168.15.1',
    '::1'
);
define('_ENV', in_array($_SERVER['HTTP_HOST'], $Localhost) ? 'localhost' : 'remote');
$url =  in_array($_SERVER['HTTP_HOST'], $Localhost) ? 'localhost/sukuk' : 'lotuscapitallimited.com/sukuk';
define('_PROTOCOL', ((isset($_SERVER['HTTPS']) && (($_SERVER['HTTPS'] == 'on') || ($_SERVER['HTTPS'] == '1'))) || getenv('SSL_PROTOCOL_VERSION')) ? 'https://' : 'http://');
define('_APIURL', _PROTOCOL . $url . '/api');
define('_MEDIAPATH', _PROTOCOL . $url . '/media');
define('_SERVER', _PROTOCOL . $url);
define('_BASEURL', $url);
define('_BASEDIR', FCPATH);
define('_VIEWDIR', _BASEDIR . '\application\views');

define('_SUKUK_ENABLE_APPLICATION', true);
define('_SUKUK_ENABLE_PAYMENT', false);
define('_SUKUK_POST_TO_API', true);
define('_SUKUK_CONTINUE_ON_API_ERROR', false);
define('_SUKUK_ENABLE_CAPTCHA', true);
define('_SUKUK_PAYMENT_MODE', 'demo'); //demo, live
define('_PAYMENT_GATEWAYS', ['paystack', 'globalpay']); //'paystack', 'globalpay'

//GLOBALPAY API SETTINGS
$_SUKUK_GLOBALPAY_API_URL = _SUKUK_PAYMENT_MODE == 'demo' ? 'https://demo.globalpay.com.ng/globalpay_demo/Paymentgatewaycapture.aspx' : 'https://www.globalpay.com.ng/GlobalPayAPI/Paymentgatewaycapture.aspx';
$_SUKUK_GLOBALPAY_WSDL_URL = _SUKUK_PAYMENT_MODE == 'demo' ? 'https://demo.globalpay.com.ng/GlobalpayWebService_demo/service.asmx?wsdl' : 'https://www.globalpay.com.ng/globalpaywebservice/service.asmx?wsdl';
$_SUKUK_GLOBALPAY_SOAP_ACTION = _SUKUK_PAYMENT_MODE == 'demo' ? 'http://www.eazypaynigeria.com/globalpay_demo/getTransactions' : 'https://www.eazypaynigeria.com/globalpay/getTransactions';
$_SUKUK_GLOBALPAY_SOAP_NAMESPACE = _SUKUK_PAYMENT_MODE == 'demo' ? 'http://www.eazypaynigeria.com/globalpay_demo/' : 'https://www.eazypaynigeria.com/globalpay/';
$_SUKUK_MERCHANT_ID = _SUKUK_PAYMENT_MODE == 'demo' ? '17770' : '3328';
define('_SUKUK_GLOBALPAY_DEMO_MID', '17770');
define('_SUKUK_GLOBALPAY_LIVE_MID', '3328');

define('_SUKUK_GLOBALPAY_API_URL', $_SUKUK_GLOBALPAY_API_URL);
define('_SUKUK_GLOBALPAY_WSDL_URL', $_SUKUK_GLOBALPAY_WSDL_URL);
define('_SUKUK_GLOBALPAY_SOAP_ACTION', $_SUKUK_GLOBALPAY_SOAP_ACTION);
define('_SUKUK_GLOBALPAY_SOAP_NAMESPACE', $_SUKUK_GLOBALPAY_SOAP_NAMESPACE);
define('_SUKUK_GLOBALPAY_CALLBACK_URL', 'https://lotuscapitallimited.com/sukuk/index.php/payment/');
define('_SUKUK_MERCHANT_ID', $_SUKUK_MERCHANT_ID);
define('_SUKUK_WS_USERNAME', 'lo_ws_user');
define('_SUKUK_WS_PASSWORD', 'lo_ws_password');
define('_SUKUK_MAX_RETRY', 50);
define('_SUKUK_MIN_AMOUNT', 10000); // 10000
define('_SUKUK_MULTIPLE', 1000);
define('_SUKUK_EMAIL_BODY_ALIGN', 'left'); // '

define('_PAYSTACK_VERIFYURL', 'https://api.paystack.co/transaction/verify/');
/* DEMO MERCHANT KEYS*/
define('_PAYSTACK_DEMO_PUBLICKEY', 'pk_test_1db0bd1aeabc26334f95d276710aa3290fb48591');
define('_PAYSTACK_DEMO_SECRETKEY', 'sk_test_d0bd04a3dacda3397f12f5cd42a7ef7f06189398');

/* LIVE MERCHANT KEYS*/
define('_PAYSTACK_PUBLICKEY', 'pk_live_1525008a6a50293abad6e8f3d380b41e9a0f452e');
define('_PAYSTACK_SECRETKEY', 'sk_live_032becf8bf31ab8697ccfa577793ef73e6c4b705');

define('_API_BASEURL', 'http://integration.lotuscapitallimited.com:5030/api');

//SUKUK API SETTINGS
define('_SUKUK_CUSTOMER_API_URL', _API_BASEURL . '/SukukCustomer');
define('_SUKUK_SETUP_API_URL', _API_BASEURL . '/SukukSetup');
// define('_SUKUK_TOPUP_API_URL', 'http://197.255.63.195:8089/api/Investment/postPaymentRef');
define('_SUKUK_TOPUP_API_URL', _API_BASEURL . '/Investment/postPaymentRef');
define('_SUKUK_TOPUP_APIKEY', 'apiKey: lotus_2018');
define('_SUKUK_RECAPTCHA_KEY', '6LeW0LAUAAAAAIxn43-JZYC15i5QnVxN9o8rFqTr');
define('_SUKUK_RECAPTCHA_SECRET', '6LeW0LAUAAAAAEoY0qPlQ5KGKDP-cDHgthYLVEnd');
define('_SUKUK_MAX_UPLOAD_SIZE', 2); // in MB
define('_SUKUK_RECEIVING_BANK', 'Zenith Bank');

//SUKUK SETTINGS
define('_SUKUK_SUBJECT_PREFIX', 'FGN SUKUK 3 Issuance');
define('_SUKUK_APP_TITLE', 'Sovereign Sukuk Subscription Form - Up to N150 Billion 7-Year Ijarah Sukuk Due 2027');
define('_SUKUK_COMPANY_NAME', 'Lotus Financial Services Limited');
define('_SUKUK_ADDRESS', '1B Udi Street Osborne Foreshore Estate, Osborne Road Ikoyi, Lagos Nigeria');
define('_SUKUK_CONTACT_EMAIL', ' fgnsukuk2021@lotuscapitallimited.com');
define('_SUKUK_CONTACT_TELEPHONE', '(+234)0908-705-8406, 0807-709-9553');
define('_SUKUK_PRIVACY_POLICY', 'https://lotuscapitallimited.com/privacy-policy');
define('_SUKUK_EMAIL_SENDER', ' fgnsukuk2021@lotuscapitallimited.com');
define('_SUKUK_EMAIL_SENDER_NAME', 'Lotus Financial Services Limited');
define('_SUKUK_EMAIL_RECIPIENT', ' fgnsukuk2021@lotuscapitallimited.com,itsupport@lotuscapitallimited.com');
