<?php
defined('BASEPATH') or exit('No direct script access allowed');
?>
<!doctype html>
<html lang="en">

<head>
  <?php require('__head.php'); ?>
</head>

<body>
  <div class="topbar mb-4"></div>
  <div id="container" class="container">
    <div class="row">
      <div class="col col-md-8 offset-md-2">
        <div id="coat-of-arms" class="w3-center mb-5"><img src="images/coat-of-arms.png" width="100" alt="" /></div>
        <header><?php echo get_form_title(); ?></header>
      </div>
    </div>
    <div id="body">
      <div class="row">
        <div class="col col-md-8 offset-md-2 instruction-box">

          <?php if ($status == 'wsdl_success') { ?>
            <?php if (!empty($trans)) { ?>
              <table class="table mb-5 border" width="100%" border="0" cellspacing="0" cellpadding="0">
                <tbody>
                  <tr>
                    <td colspan="2" class="w3-center w3-light-grey bold size18">
                      <div class="bold mb-2">Your Payment Transaction Status</div>
                      <div class="size18 bold <?php echo $trans['payment_status'] == 'successful' ? 'w3-green' : 'w3-red'; ?> p-3"><?php echo $trans['payment_status'] != 'successful' ? 'FAILED' : 'SUCCESSFUL'; //strtoupper($trans['payment_status']); 
                                                                                                                                    ?></div>
                    </td>
                  </tr>
                  <tr>
                    <td class="w3-right-align">Amount </td>
                    <td class="bold"><?php echo $naira . number_format($trans['InvestmentValue'], 2); ?></td>
                  </tr>
                  <tr>
                    <td class="w3-right-align">Status </td>
                    <td class="bold <?php echo $trans['payment_status'] == 'successful' ? 'w3-text-green' : 'w3-text-red'; ?>"><?php echo strtoupper($trans['payment_status']); ?></td>
                  </tr>
                  <tr>
                    <td class="w3-right-align">Narratives </td>
                    <td class="bold"><?php echo !empty($trans['payment_status_description']) ? ucwords($trans['payment_status_description']) : '-'; ?></td>
                  </tr>
                  <tr>
                    <td class="w3-right-align">Transaction Reference</td>
                    <td class="bold txnref"><?php echo $trans['txnref']; ?></td>
                  </tr>
                  <tr>
                    <td class="w3-right-align">Transaction Date </td>
                    <td class="bold"><?php echo !empty($trans['payment_date']) ? $trans['payment_date'] : '-'; ?></td>
                  </tr>
                  <tr>
                    <td class="w3-right-align">Payment Method</td>
                    <td class="bold"><?php echo !empty($trans['payment_method']) ? $trans['payment_method'] : '-'; ?></td>
                  </tr>
                  <tr>
                    <td class="w3-right-align">Currency</td>
                    <td class="bold"><?php echo !empty($trans['currency']) ? $trans['currency'] : '-'; ?></td>
                  </tr>
                  <tr>
                    <td width="50%" class="w3-right-align">Full name</td>
                    <td class="bold"><?php echo $trans['names']; ?></td>
                  </tr>
                  <tr>
                    <td width="50%" class="w3-right-align">Email</td>
                    <td class="bold"><?php echo $trans['email_address']; ?></td>
                  </tr>
                  <tr>
                    <td class="w3-right-align">Telephone</td>
                    <td class="bold"><?php echo $trans['phone_number']; ?></td>
                  </tr>
                </tbody>
              </table>
              <p class="text-center mb-4 size15">
                <?php if (!empty($trans) && !($trans['checks'] > $max_retry)) { ?>
                  <button class="PaymentButton w3-button w3-orange size15 bold" type="button" style="padding: 10px 20px;">VERIFY TRANSACTION</button>
                <?php } ?>
                <?php if (!empty($trans['app_ref']) && $trans['app_ref'] != 'successful') { ?>
                  <button class="retryPayment w3-button w3-green size15 bold" type="button" style="padding: 10px 20px;">RETRY PAYMENT</button>
                <?php } ?>
              </p>
            <?php } ?>
          <?php } else if ($status == 'error') { ?>
            <div class="w3-center margin-bottom-50" style="margin-top: 50px; margin-bottom: 150px;">
              <h2 class="w3-text-red">Error!</h2>
              <p><?php echo $error; ?></p>
            </div>
            <?php if (!empty($trans) && !($trans['checks'] > $max_retry)) { ?>
              <p class="text-center mb-4 size15">
                <button class="PaymentButton w3-button w3-orange size15 bold" type="button" style="padding: 10px 20px;">RETRY TRANSACTION</button>
              <?php } ?>
              <?php if (!empty($trans['app_ref']) && $trans['app_ref'] != 'successful') { ?>
                <button class="retryPayment w3-button w3-green size15 bold" type="button" style="padding: 10px 20px;">RETRY PAYMENT</button>
              </p>
            <?php } ?>
          <?php } else { ?>
            <div class="w3-center margin-bottom-50" style="margin-top: 70px; margin-bottom: 150px;">
              <h22 class="w3-text-red">Invalid request</h2>
            </div>
          <?php } ?>
        </div>
      </div>
    </div>



    <div id="footer"><?php echo get_footer(); ?></div>
  </div>
  <div class="topbar mb-0"></div>
  <script src="assets/js/jquery-3.4.1.min.js"></script>
  <script src="assets/bootstrap-4.3.1/js/bootstrap.min.js"></script>
  <script src="assets/js/jquery.format-currency-1.4.0/jquery.format-currency-1.4.0.js"></script>
  <script src="assets/js/alertifyjs/alertify.min.js"></script>
  <script src="assets/js/js.js"></script>

  <script>
    <?php if (!empty($txnref)) { ?>
      $(".PaymentButton").on("click", function(e) {
        e.preventDefault();
        showIndicator();
        window.location = '<?php echo site_url('payment/' . $txnref) ?>';
      });
    <?php } ?>
    <?php if (!empty($trans['app_ref'])) { ?>
      $(".retryPayment").on("click", function(e) {
        e.preventDefault();
        showIndicator();
        window.location = '<?php echo site_url('prepayment/' . $trans['app_ref']) ?>';
      });
    <?php } ?>
  </script>
</body>

</html>