<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<!doctype html>
<html lang="en">

<head>
    <?php require('__head.php'); ?>
    <title>Payment : <?php echo _SUKUK_APP_TITLE; ?></title>
</head>

<body>
    <div class="topbar mb-4"></div>
    <div id="container" class="container" style="min-height: 98vh;">
        <div class="w3-content width800 w3-animate-opacity mb-5">
            <div id="coat-of-arms" class="w3-center mb-5"><img src="images/coat-of-arms.png" width="100" alt="" /></div>
            <header><?php echo get_form_title(); ?></header>
        </div>
        <div id="App" v-cloak>
            <div class="w3-content width800 w3-animate-opacity" v-if="View === 'intro'">
                <p class="text-center mb-4 size15">Applications must be made in accordance with the instructions set out below.
                    Care must be taken to follow these instructions as applications that do not comply with the instructions may be rejected.
                    Please consult your Financial or Legal Advisers for guidance before completing this Form.</p>
                <div class="mb-4" style="margin: auto; border-bottom: solid 1px #BDBDBD; width: 40%;"></div>
                <div class="w3-content px-4">
                    <?php echo SukukInstruction(); ?>
                </div>
                <div class="text-center mt-5">
                    <button type="button" @click.prevent="MoveToOptions" class="btn btn-danger btn-lg">CLICK HERE TO APPLY</button>
                </div>
                <!-- instruction-link-box -->
                <div class="instruction-link-box col col-md-8 offset-md-2 mt-4 mb-4" style="display:none;">
                    <h6 class="text-center"><a class="instruction-link" href="#">INSTRUCTIONS FOR COMPLETING THE APPLICATION FORM</a></h6>
                </div>
            </div>

            <div v-if="View === 'paymentOptions'" class="w3-content width800 w3-animate-opacity px-4">
                <h5 class="text-center mb-5 bold">CHOOSE YOUR PAYMENT METHOD</h5>
                <div class="form-row">

                </div>
                <div class="row mb-4">
                    <div class="form-group col-md-2">
                        <label for="title">Title <span class="mandatory">*</span></label>
                        <select id="title" v-model="PaymentForm.title" class="custom-select declarer_name">
                            <option value=""></option>
                            <?php if (!empty($titles)) { ?>
                                <?php foreach ($titles as $title) { ?>
                                    <option value="<?php echo $title; ?>"><?php echo $title; ?></option>
                                <?php } ?>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="form-group col-md-10">
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="Surname">Surname <span class="mandatory">*</span></label>
                                <input id="Surname" type="text" v-model="PaymentForm.surname" class="form-control">
                            </div>
                            <div class="form-group col-md-4">
                                <label for="firstname">Firstname <span class="mandatory">*</span></label>
                                <input id="firstname" type="text" v-model="PaymentForm.firstname" class="form-control">
                            </div>
                            <div class="form-group col-md-4">
                                <label for="othername">Othername</label>
                                <input id="othername" type="text" v-model="PaymentForm.othername" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-sm-8">
                        <label class="mb-2 label w3-block">Email Address <span class="w3-text-red">*</span></label>
                        <input v-model="PaymentForm.email_address" type="text" class="form-control form-control-lg mb-3 size16">
                    </div>
                    <div class="form-group col-sm-4">
                        <label class="mb-2 label w3-block">Phone Number <span class="w3-text-red">*</span></label>
                        <input v-model="PaymentForm.phone_number" type="text" class="form-control form-control-lg mb-3 size16">
                    </div>
                </div>
                <div class="row mb-5">
                    <div class="form-group col-sm-4 offset-sm-4">
                        <label class="mb-2 label w3-block w3-center">Value of Sukuk Applied for <span class="w3-text-red">*</span></label>
                        <div class="input-group input-group-lg mb-3">
                            <span class="input-group-text w3-white">&#8358;</span>
                            <input @focus="FormatInputOn.Focus" @blur="FormatInputOn.Blur" v-model="PaymentForm.InvestmentValue" type="text" class="form-control form-control-lg w3-right-align size16 py-4">
                        </div>
                    </div>
                </div>
                <div class="row equalHeightBox">
                    <div class="col-sm-6">
                        <label class="cursor box d-block mb-3 px-5 py-4 w3-border w3-round-xlarge w3-hover-light-grey">
                            <input type="radio" value="online" v-model="PaymentForm.option" class="w3-radio payment_method mr-3 mb-3" />
                            <h6 class="bold">I want to pay online</h6>
                            <p class="mt-3  size15">You will be able to make payment after completing this application</p>
                        </label>
                    </div>
                    <div class="col-sm-6">
                        <label class="cursor box d-block mb-3 px-5 py-4 w3-border w3-round-xlarge w3-hover-light-grey">
                            <input type="radio" value="deposit" v-model="PaymentForm.option" class="w3-radio payment_method mr-3 mb-3" />
                            <h6 class="bold">I already made a bank deposit/transfer</h6>
                            <p class="mt-3 size15">You will be required to upload a proof of payment and provide your payment reference</p>
                        </label>
                    </div>
                </div>
                <div class="text-center mt-5">
                    <button @click.prevent="View = 'intro'" type="button" class="w3-button w3-white w3-border w3-hover-orange px-5 m-2"><i class="fas fa-arrow-left"></i></button>
                    <button v-else @click.prevent="MoveToPayment" type="button" class="w3-button w3-red w3-hover-orange px-5">PROCEED <i class="fas fa-arrow-right"></i></button>
                </div>
            </div>
            <!-- Payment proof upload -->
            <div v-if="View === 'receipt'" class="w3-content width800 px-4">
                <h3 class="text-center mt-4 mb-3">UPLOAD PROOF OF PAYMENT</h3>
                <p class="text-center mb-4 size15">Please upload your proof of payment</p>
                <div class="form-group row">
                    <label class="col-sm-4 col-form-label">Payment Receipt</label>
                    <div class="col-sm-8">
                        <input ref="ReceiptFile" type="file" class="form-control-file form-control-lg cursor w3-border w3-round-xxlarge">
                        <p>Copy of Bank teller or generated receipt for online payment</p>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-sm-4 col-form-label">Transaction Reference</label>
                    <div class="col-sm-8">
                        <input v-model="PaymentForm.tellerNo" type="text" class="form-control form-control-lg mb-3 max-width300">
                        <p>Teller number or transaction reference</p>
                    </div>
                </div>
                <div class="text-center my-5">
                    <button @click.prevent="MoveToOptions" type="button" class="w3-button w3-white w3-border w3-hover-orange px-5 m-2"><i class="fas fa-arrow-left"></i></button>
                    <button v-else @click.prevent="UploadPayment" type="button" class="w3-button w3-red w3-hover-orange px-5">PROCEED <i class="fas fa-arrow-right"></i></button>
                </div>
            </div>

            <div v-if="View === 'online'" class="w3-content width600 px-4">
                <h3 class="text-center mt-4 mb-5">MAKE PAYMENT</h3>
                <div class="form-group row w3-border-bottom">
                    <label class="col-sm-4 col-form-label">Name</label>
                    <div class="col-sm-8 bold">{{ PaymentForm.title ? PaymentForm.title + ' ' : '' }}{{PaymentForm.firstname ? PaymentForm.firstname + ' ' : ''}}{{PaymentForm.othername ? PaymentForm.othername + ' ' : ''}}{{PaymentForm.surname}}</div>
                </div>
                <div class="form-group row w3-border-bottom">
                    <label class="col-sm-4 col-form-label">Email Address</label>
                    <div class="col-sm-8 bold">{{ PaymentForm.email_address }}</div>
                </div>
                <div class="form-group row w3-border-bottom">
                    <label class="col-sm-4 col-form-label">Telephone</label>
                    <div class="col-sm-8 bold">{{ PaymentForm.phone_number }}</div>
                </div>
                <div class="form-group row w3-border-bottom">
                    <label class="col-sm-4 col-form-label">Transaction Reference</label>
                    <div class="col-sm-8 bold">{{ PaymentForm.txnref }}</div>
                </div>
                <div class="form-group row w3-border-bottom">
                    <label class="col-sm-4 col-form-label">Amount</label>
                    <div class="col-sm-8 bold"><?PHP echo $naira; ?>{{ formatCurrency(PaymentForm.InvestmentValue) }}</div>
                </div>
                <div class="text-center my-5">
                    <h4 v-if="PaymentGateways.length > 1" class="margin-top-30 margin-bottom-20">Choose your preferred payment option:</h4>
                    <template v-if="PaymentGateways.length > 1">
                        <img v-if="PaymentGateways.includes('paystack')" @click="Gateway = 'paystack'" title="Pay with Paystack" style="border-width: 2px!important;" class="margin-right-15 cursor w3-border" :class="[Gateway === 'paystack' ? 'w3-border-red' : 'w3-grayscale-max w3-opacity']" src="images/paystack.png" height="40" alt="Pay with Paystack" />
                        <img v-if="PaymentGateways.includes('globalpay')" @click="Gateway = 'globalpay'" title="Pay with GlobalPay" style="border-width: 2px!important;" class="cursor w3-border" :class="[Gateway === 'globalpay' ? 'w3-border-red' : 'w3-grayscale-max w3-opacity']" src="images/globalpay.png" height="40" alt="Pay with GlobalPay" />
                    </template>
                    <h4 class="margin-top-30 margin-bottom-20">Declaration</h4>
                    <p class="mb-4">By clicking the "<strong>{{ Gateway === 'globalpay' ? 'Proceed to Payment' : 'Pay Now' }} </strong>" button, I declare that to the best of my knowledge, the information supplied in this form and as displayed above is true and complete.</p>
                    <button @click.prevent="MoveToOptions" type="button" class="w3-button w3-white w3-border w3-hover-orange px-5 m-2"><i class="fas fa-arrow-left"></i></button>
                    <button v-if="PaymentGateways.length > 0" v-else @click.prevent="MakePayment" type="button" class="w3-button w3-red w3-hover-orange px-5">
                        PAY NOW
                        <i class="fas fa-arrow-right"></i></button>
                </div>
            </div>
            <form id="GlobalPay" method="post" action="<?php echo _SUKUK_GLOBALPAY_API_URL; ?>">
                <input type="hidden" class="merch_txnref" name="merch_txnref" v-model="PaymentRef">
                <input type="hidden" class="amount" name="amount" v-model="Amount">
                <input type="hidden" class="names" name="names" v-model="PaymentForm.names">
                <input type="hidden" class="email_address" name="email_address" v-model="PaymentForm.email_address">
                <input type="hidden" class="phone_number" name="phone_number" v-model="PaymentForm.phone_number">
                <input type="hidden" class="app_ref" name="app_ref" v-model="PaymentForm.uuid">
                <input type="hidden" class="currency" name="currency" value="NGN">
                <input type="hidden" class="merchantid" name="merchantid" value="<?php echo _SUKUK_MERCHANT_ID; ?>">
                <input type="hidden" class="redirect_url" name="redirect_url" value="<?php echo site_url(); ?>">
            </form>
        </div>

        <div id="footer"><?php echo get_footer(); ?></div>
    </div>
    <div class="topbar mb-0"></div>
    <?php require('__foot.php'); ?>
    <?php $_SUKUK_MAX_UPLOAD_SIZE = defined('_SUKUK_MAX_UPLOAD_SIZE') ? _SUKUK_MAX_UPLOAD_SIZE : 2; ?>;
    <script src="https://js.paystack.co/v1/inline.js"></script>
    <script src="assets/js/vue@3.0.9/vue.global.prod.js"></script>
    <script type="module">
        import {
            Spinner,
            isEmpty,
            FormatInputOn,
            formatCurrency,
            uuid as UUID,
            queryParameter,
            Util,
        } from './vue/composables/utilities.js'
        const {
            ref,
            onBeforeMount,
            onMounted,
            computed,
            watchEffect,
            nextTick
        } = Vue
        const App = {
            components: {},
            setup() {
                const ApiUrl = '<?php echo site_url('api'); ?>';
                const PaymentMode = '<?php echo _SUKUK_PAYMENT_MODE; ?>';
                const minAmount = parseFloat('<?php echo $minAmount; ?>');
                const title = ref('Bequest')
                const View = ref('intro') // 'intro', 'form', 'preview'
                const activeBox = ref('receipt') // 'receipt', 'online'
                const Gateway = ref('paystack')
                const payment_gateways = '<?php echo $payment_gateways; ?>';
                const PaymentGateways = payment_gateways.split(',')
                const Amount = ref(0)
                const PaymentRef = ref('')
                const Trxref = '<?php echo $Trxref; ?>';
                const Transaction = ref({})
                const Initialized = ref(false)
                const uuid = '<?php echo $uuid; ?>';
                const Errors = ref({})
                const ShowErrors = ref(false)
                const PaymentForm = ref({
                    option: "online",
                    uuid: uuid,
                    txnref: "",
                    tellerNo: "",
                    InvestmentValue: "0.00",
                    title: '',
                    names: "",
                    firstname: '',
                    othername: '',
                    surname: '',
                    email_address: "",
                    phone_number: ""
                })
                const UUID = () => {
                    const date = new Date()
                    const randomNum = Math.floor(Math.random() * 1000)
                    return date.getFullYear().toString() + date.getMonth().toString() + date.getDate().toString() +
                        '-' + date.getHours().toString() + date.getMinutes().toString() + date.getSeconds().toString() +
                        '-' + randomNum.toString()
                }
                var maxUploadSize = <?php echo $_SUKUK_MAX_UPLOAD_SIZE; ?>;

                const equalHeightBox = () => {
                    let isMobile = window.matchMedia('only screen and (max-width: 760px)').matches
                    if (!isMobile) {
                        $('.equalHeightBox').each(function() {
                            var highestBox = 0
                            $('.box', this).each(function() {
                                if ($(this).height() > highestBox) {
                                    highestBox = $(this).height()
                                }
                            })
                            $('.box', this).height(highestBox)
                        })
                    }
                }
                const MoveToOptions = () => {
                    View.value = 'paymentOptions'
                    nextTick(() => {
                        equalHeightBox()
                        Util.scrollToTop()
                    })
                }
                const MoveToPayment = () => {
                    if (!PaymentForm.value.firstname) {
                        error("Please enter your firstname")
                        return
                    }
                    if (!PaymentForm.value.firstname) {
                        error("Please enter your surname")
                        return
                    }
                    if (!PaymentForm.value.InvestmentValue) {
                        error("Please enter your investment amount")
                        return
                    }
                    if (PaymentForm.value.InvestmentValue.replace(/,/g, "") < minAmount) {
                        error("Investment amount cannot be less than <?php echo $naira; ?>" + formatCurrency(minAmount))
                        return
                    }
                    if (!PaymentForm.value.email_address) {
                        error("Please enter your email address")
                        return
                    }
                    if (!PaymentForm.value.phone_number) {
                        error("Please enter your phone number")
                        return
                    }
                    if (!PaymentForm.value.option) {
                        error("Please select your payment method")
                        return
                    }
                    PaymentForm.value.names = PaymentForm.value.firstname + ' ' + PaymentForm.value.surname
                    PaymentForm.value.txnref = PaymentForm.value.option === 'online' ? UUID() : ""
                    View.value = PaymentForm.value.option === 'online' ? 'online' : 'receipt'
                    Util.scrollToTop()
                }
                const ReceiptFile = ref(null)
                const UploadPayment = () => {
                    if (!PaystackLoaded(false)) {
                        return false
                    }
                    var formBody = new FormData()
                    for (const field in PaymentForm.value) {
                        formBody.append(field, PaymentForm.value[field])
                    }

                    if (ReceiptFile.value?.files[0]) {
                        formBody.append('slip', ReceiptFile.value.files[0])
                    } else {
                        error("Please select a receipt file to upload")
                        return
                    }
                    const slip = ReceiptFile.value.files[0]
                    if (slip.size > file_size_to_byte(maxUploadSize)) {
                        error("File should not be greater than " + maxUploadSize + "mb")
                        return
                    }
                    // var allowedFile = ["image/jpeg", "image/png", "image/gif", "application/pdf"]
                    var allowedFile = ["image/jpeg", "application/pdf"]
                    if (!allowedFile.includes(slip.type)) {
                        error("Only JPEG image and PDF payment receipt can be uploaded")
                        return
                    }
                    // if (!PaymentForm.value.tellerNo) {
                    //     error("Please provide teller number or transaction reference")
                    //     return
                    // }
                    showIndicator()
                    axios({
                            method: 'post',
                            url: ApiUrl + '/SaveProofOfPayment/',
                            data: formBody,
                            headers: {
                                'content-type': 'multipart/form-data'
                            }
                        })
                        .then(function(response) {
                            const data = response.data
                            if (data.status === 'success') {
                                notify('Proof of payment submitted successfully')
                                // hideIndicator()
                                window.location = '<?php echo site_url("apply/"); ?>' + data.result.txnref
                            } else {
                                hideIndicator()
                                error(data.result)
                            }
                        })
                        .catch(function(err) {
                            hideIndicator()
                            error(err.message)
                        })
                }
                const MakePayment = () => {

                    showIndicator()
                    axios({
                            method: 'post',
                            url: ApiUrl + '/MakePayment/' + Gateway.value,
                            data: PaymentForm.value
                        })
                        .then(function(response) {
                            hideIndicator()
                            const data = response.data
                            if (data.status === 'success') {
                                PaymentRef.value = data.result.txnref
                                Amount.value = data.result.amount
                                LoadPaymentGateway(data.result)
                            } else {
                                if (data.result === 'Duplicate') {
                                    error("Duplicate transaction. Please try again")
                                    PaymentForm.value.txnref = UUID()
                                } else {
                                    error(data.result)
                                }
                            }
                        })
                        .catch(function(err) {
                            hideIndicator()
                            error(err.message)
                        })
                }

                function LoadPaymentGateway(data) {
                    if (!Gateway.value) {
                        error('Please select a payment gateway')
                        return false
                    }
                    const txnref = PaymentRef.value
                    if (txnref === '') {
                        error("Invalid transaction reference")
                        return
                    }
                    const PAYMENT_MODE = data.PAYMENT_MODE

                    switch (Gateway.value) {
                        case 'paystack':
                            hideIndicator()
                            const PBFPubKeyDemo = data.PAYSTACK_DEMO_KEY
                            const PBFPubKeyLive = data.PAYSTACK_KEY
                            var email = data.email_address
                            var fullname = data.names
                            var amount = Amount.value
                            var kobo_amount = amount * 100
                            var PBFPubKey = PBFPubKeyLive
                            if (PAYMENT_MODE === 'demo') {
                                var PBFPubKey = PBFPubKeyDemo
                            }
                            var handler = PaystackPop.setup({
                                key: PBFPubKey,
                                email: email,
                                amount: kobo_amount,
                                currency: 'NGN',
                                ref: txnref,
                                callback: function(response) {
                                    ProcessPayment(txnref)
                                    Rave.close()
                                },
                                metadata: {
                                    custom_fields: [{
                                            display_name: 'Customer name',
                                            variable_name: 'cust_name',
                                            value: fullname
                                        },
                                        {
                                            display_name: 'Product Type',
                                            variable_name: 'product_type',
                                            value: 'Sukuk'
                                        }
                                    ]
                                },
                                onClose: function() {
                                    ProcessPayment(txnref)
                                }
                            })
                            handler.openIframe()

                            break
                        case 'globalpay':
                            showIndicator()
                            var GlobalPayForm = $('#GlobalPay')
                            nextTick(() => {
                                GlobalPayForm.submit()
                            })
                            break
                    }
                }
                const TrxStatus = ref({
                    status: '',
                    message: ''
                })
                const ProcessPayment = (trxref) => {
                    showIndicator()
                    axios({
                            method: 'get',
                            url: ApiUrl + '/sukuk_payment/' + trxref
                        })
                        .then(function(response) {
                            hideIndicator()
                            const data = response.data
                            Transaction.value = data.result.transaction
                            TrxStatus.value.status = data.result.status
                            TrxStatus.value.message = data.result.message
                            Gateway.value = data.result.transaction.gateway
                            if (data.status === 'success') {
                                notify('Your payment was successfully')
                                // hideIndicator()
                                window.location = '<?php echo site_url("apply/"); ?>' + data.result.transaction.txnref
                            } else {
                                hideIndicator()
                                const msg = data.result.message ? data.result.message : 'Pending'
                                const message = '<h3 class="w3-text-red">Transaction Failed!</h3> <h4>Status: ' + msg + '</h4>'
                                error(Util.handleError(data, message) ?? 'Pending')
                            }
                        })
                        .catch(function(err) {
                            error(err.message)
                        })
                        .finally(() => {
                            hideIndicator()
                        })
                }
                if (typeof Trxref.value !== 'undefined' && Trxref.value !== '') ProcessPayment(Trxref.value)
                const PaystackLoaded = (cbk) => {
                    if (typeof PaystackPop === "undefined") {
                        error(
                            'Paystack payment gateway is currently unreachable. Please check your internet connection, <a href="javascript:;" class="refreshPage">refresh this page</a> and try again later'
                        );
                        if (cbk) return
                    }
                    return true
                }
                onMounted(() => {
                    PaystackLoaded(false)
                })


                return {
                    ApiUrl,
                    Spinner,
                    isEmpty,
                    View,
                    formatCurrency,
                    FormatInputOn,
                    Errors,
                    ShowErrors,
                    PaymentGateways,
                    Gateway,
                    PaymentRef,
                    Amount,
                    Initialized,
                    activeBox,
                    PaymentForm,
                    ReceiptFile,
                    MoveToOptions,
                    MoveToPayment,
                    UploadPayment,
                    MakePayment,
                }
            }
        }
        const app = Vue.createApp(App);
        app.mount('#App')
    </script>
</body>

</html>