// JavaScript Document
function format_date(data) {
  return $.datepicker.formatDate('dd/mm/yy', new Date(data))
}
function formatDate(date) {
  var monthNames = [
    'January',
    'February',
    'March',
    'April',
    'May',
    'June',
    'July',
    'August',
    'September',
    'October',
    'November',
    'December'
  ]

  var day = date.getDate()
  var monthIndex = date.getMonth()
  var year = date.getFullYear()

  return day + '/' + monthIndex + '/' + year
}
$.fn.serializeObject = function () {
  'use strict'
  var o = {}
  var a = this.serializeArray()
  $.each(a, function () {
    if (o[this.name]) {
      if (!o[this.name].push) {
        o[this.name] = [o[this.name]]
      }
      o[this.name].push(this.value || '')
    } else {
      o[this.name] = this.value || ''
    }
  })
  return o
}
function formToJSON(form) {
  'use strict'
  return form.serializeObject()
}
function isJSON(str) {
  'use strict'
  try {
    JSON.parse(str)
    return true
  } catch (error) {
    return false
  }
}
function parseJSON(str) {
  'use strict'
  try {
    return JSON.parse(str)
  } catch (error) {
    return false
  }
}
function parseFromApi(data) {
  'use strict'
  var Data = parseJSON(data)
  if (Data) {
    if (Data.status === 'success') {
      return Data
    } else if (Data.status === 'error') {
      hideIndicator()
      error(Data.result)
      return false
    } else {
      hideIndicator()
      error(Data.result)
      return false
    }
  } else {
    hideIndicator()
    error(data)
    return false
  }
}
function showIndicator() {
  'use strict'
  var indicator =
    '<div class="loadinggif" style="position: fixed; z-index: 99999999;width: 100vw; height: 100vh; background: rgba(255,255,255,0.9);">' +
    '<div style="width: 150px; padding: 25px; margin: 10% auto auto; text-align: center; background-color: rgba(255, 255, 255, 0.0); color: #f00;">' +
    '<img style="width: 120px;" src="images/loading.gif" alt="" />' +
    '<div class="padding-top-24">' +
    //'<h4 style="text-align: center;" class="margin-bottom-10 bold size12">Processing...</h4>' +
    //'<span class="w3-block size12">This may take a while depending on the speed of your internet connection</span>' +
    '</div>' +
    ' </div>' +
    '</div>'
  $('body').find('.loadinggif').remove()
  $('body').prepend(indicator)
}
function hideIndicator() {
  'use strict'
  $('body').find('.loadinggif').remove()
}
function showResponse(message, type) {
  'use strict'
  var color = 'green'
  switch (type) {
    case 'error':
      color = 'red'
      break
    case 'warning':
      color = 'amber'
      break
    case 'success':
      color = 'green'
      break
    default:
      color = 'blue-gray'
      break
  }
  var Response =
    '<div class="mcResponse w3-panel w3-display-container w3-' +
    color +
    ' w3-display-topmiddle" style="z-index: 11111; width: 500px; max-width: 100%;">'
  Response +=
    '<span onclick="$(this).parent().fadeOut().remove();" class="w3-button w3-display-topright"><i class="fa fa-times-circle"></i></span>'
  Response += '<div class="padding-10">' + message + '</div></div>'
  $('body').find('.mcResponse').remove()
  $('body').prepend(Response)

  setTimeout(function () {
    hideResponse()
  }, 8000)
}
function hideResponse() {
  'use strict'
  $('body').find('.mcResponse').fadeOut('slow').remove()
}
function alertTitle(title, type) {
  'use strict'
  if (!title) {
    title = 'Error'
  }
  if (!type) {
    type = 'error'
  }
  var color = 'black'
  if (type === 'success') {
    color = 'green'
  }
  if (type === 'error') {
    color = 'red'
  }
  return '<h4 class="bold w3-text-' + color + '">' + title + '</h4>'
}
function errorTitle(title) {
  'use strict'
  if (!title) {
    title = 'Error'
  }
  return '<h4 class="bold w3-text-red">' + title + '</h4>'
}
function successTitle(title) {
  'use strict'
  if (!title) {
    title = 'Success'
  }
  return '<h4 class="bold w3-text-green">' + title + '</h4>'
}
function warningTitle(title) {
  'use strict'
  if (!title) {
    title = 'Warning'
  }
  return '<h4 class="bold w3-text-amber">' + title + '</h4>'
}
alertify.defaults = {
  // dialogs defaults
  autoReset: true,
  basic: false,
  closable: true,
  closableByDimmer: true,
  frameless: false,
  maintainFocus: true, // <== global default not per instance, applies to all dialogs
  maximizable: true,
  modal: true,
  movable: true,
  moveBounded: false,
  overflow: true,
  padding: true,
  pinnable: true,
  pinned: true,
  preventBodyShift: false, // <== global default not per instance, applies to all dialogs
  resizable: true,
  startMaximized: false,
  transition: 'pulse',

  // notifier defaults
  notifier: {
    // auto-dismiss wait time (in seconds)
    delay: 10,
    // default position
    position: 'bottom-right',
    // adds a close button to notifier messages
    closeButton: false
  },

  // language resources
  glossary: {
    // dialogs default title
    title: 'Homefix.ng',
    // ok button text
    ok: 'OK',
    // cancel button text
    cancel: 'Cancel'
  },

  // theme settings
  theme: {
    // class name attached to prompt dialog input textbox.
    input: 'ajs-input',
    // class name attached to ok button
    ok: 'ajs-ok w3-button w3-text-green w3-hover-green w3-border w3-border-green w3-white',
    // class name attached to cancel button
    cancel:
      'ajs-cancel w3-button w3-text-red w3-hover-red w3-border w3-border-red w3-white'
  }
}
function Alert(msg, url, alertTitle) {
  if (alertTitle === undefined) alertTitle = ''
  if (url === undefined) url = ''
  if (url !== '') {
    alertify.alert(alertTitle, msg, function () {
      window.location = url
    })
  } else {
    alertify.alert(alertTitle, msg)
  }
}
function Success(msg, url, alertTitle) {
  if (alertTitle === undefined) alertTitle = ''
  if (url === undefined) url = ''
  if (url !== '') {
    alertify.alert(alertTitle, msg, function () {
      showIndicator()
      window.location = url
    })
  } else {
    alertify.alert(alertTitle, msg)
  }
}
function success(msg, type, wait) {
  if (type !== 'popup') alertify.alert(msg)
  else alertify.success('Success')
}
function error(msg, type, wait) {
  if (type !== 'popup') {
    var title = '<h3 style="color: red">Error!</h3>'
    alertify.alert(title, msg)
  } else {
    alertify.error(msg, 'error')
  }
}
function warning(msg) {
  alertify.notify(msg, 'error', 5)
}
function message(msg) {
  alertify.notify(msg, 'info', 5)
}
function notify(msg) {
  alertify.notify(msg, 'success', 5)
}
function equal_heights(div) {
  'use strict'
  var maxHeight = 0
  $(div).each(function () {
    if ($(this).height() > maxHeight) {
      maxHeight = $(this).height()
    }
  })

  $(div).height(maxHeight + 50)
}
$('.currency').on('focus', function () {
  'use strict'
  $(this).toNumber()
})
$('.currency').on('blur', function () {
  'use strict'
  $(this).formatCurrency({ colorize: true, roundToDecimalPlace: 0 })
})
$('.currency').formatCurrency({ colorize: true, roundToDecimalPlace: 0 })

$('.number').on('focus', function () {
  'use strict'
  $(this).toNumber()
})
$('.number').on('blur', function () {
  'use strict'
  $(this).toNumber()
})
$('.number').toNumber()
;('use strict')
function scrollto(elem) {
  $('html, body').animate(
    {
      scrollTop: $(elem).offset().top
    },
    500
  )
}
$('.close-alert').on('click', function () {
  $(this).parent().fadeOut('slow').remove()
})
function csrf_input() {
  var input = ''
  $.ajax({
    url: apiurl + '/csrf_input/',
    type: 'GET',
    dataType: 'html',
    async: false,
    data: {},
    error: function (response) {
      hideIndicator()
      alert('An error occurred. Please check your internet connection')
    },
    success: function (data) {
      hideIndicator()
      var Data = parseFromApi(data)
      if (Data) {
        input = Data.result
      }
    }
  })
  return input
}
function get_request_token() {
  var token = ''
  $.ajax({
    url: apiurl + '/get_request_token/' + usr_rid + '/' + token_scope,
    type: 'GET',
    dataType: 'html',
    async: false,
    data: {},
    error: function (response) {
      alert('An error occurred. Please check your internet connection')
    },
    success: function (data) {
      var Data = parseFromApi(data)
      if (Data) {
        token = Data.result
      }
    }
  })
  return token
}
function append_request_token(form) {
  $.ajax({
    url: apiurl + '/get_request_token/' + usr_rid + '/' + token_scope,
    type: 'GET',
    dataType: 'html',
    async: false,
    data: {},
    error: function (response) {
      alert('An error occurred. Please check your internet connection')
    },
    success: function (data) {
      var Data = parseFromApi(data)
      if (Data) {
        form.find('input[name="hf-token"]').remove()
        form.append(
          '<input type="hidden" name="hf-token" value="' + Data.result + '" />'
        )
      }
    }
  })
}
function append_csrf_input(form) {
  $.ajax({
    url: apiurl + '/get_request_token/' + usr_rid + '/' + token_scope,
    type: 'GET',
    dataType: 'html',
    async: false,
    data: {},
    error: function (response) {
      alert('An error occurred. Please check your internet connection')
    },
    success: function (data) {
      var Data = parseFromApi(data)
      if (Data) {
        form.find('input[name="hf-token"]').remove()
        form.append(
          '<input type="hidden" name="hf-token" value="' + Data.result + '" />'
        )
      }
    }
  })
  /*$.ajax({
		url: apiurl + "/get_csrf_hash/",
		type: 'GET',
		dataType:"html",
		async: false,
		data: {},
		error: function( response ) {
			alert('An error occurred. Please check your internet connection');
		  },
		  success: function (data) {
			  var Data = parseFromApi(data);
			  if(Data){
				form.find('input[name="' + Data.result.name + '"]').remove();
				form.append('<input type="hidden" name="' + Data.result.name + '" value="' + Data.result.hash + '" />');
			}
				  
		 }
	});	*/
}
function get_csrf_hash() {
  'use strict'
  var token = {}
  $.ajax({
    url: apiurl + '/get_csrf_hash/',
    type: 'GET',
    dataType: 'html',
    async: false,
    data: {},
    error: function (response) {
      hideIndicator()
      error('An error occurred. Please check your internet connection')
    },
    success: function (data) {
      console.log('Hash: ', data)
      hideIndicator()
      var Data = parseFromApi(data)
      if (Data) {
        Token = Data.result
        token = Data.result
      }
    }
  })
  return token
}
function sha256(string) {
  'use strict'
  return sha256_digest(string)
}

function equalHeightBox() {
  let isMobile = window.matchMedia('only screen and (max-width: 760px)').matches
  if (!isMobile) {
    $('.equalHeightBox').each(function () {
      var highestBox = 0
      $('.box', this).each(function () {
        if ($(this).height() > highestBox) {
          highestBox = $(this).height()
        }
      })
      $('.box', this).height(highestBox)
    })
  }
}

function get_file_size(size) {
  if (!size) return '0kb'
  var kb = 1
  var mb = 1024
  var gb = 1024 * mb
  var tb = 1024 * gb
  var file_size = ''

  if (size < kb) {
    file_size = size + 'bytes'
  } else if (size < mb) {
    final = Math.round(size / kb, 2)
    file_size = final + 'kb'
  } else if (size < gb) {
    final = Math.round(size / mb, 2)
    file_size = final + 'mb'
  } else if (size < tb) {
    final = Math.round(size / gb, 2)
    file_size = final + 'gb'
  } else {
    final = Math.round(size / tb, 2)
    file_size = final + 'tb'
  }
  return file_size
}

function file_size_to_byte(file_size = false, unit = 'mb') {
  if (!file_size) return '0'
  var unit = unit.toLowerCase()

  switch (unit) {
    case 'kb':
      return file_size * 1024
    case 'mb':
      return file_size * 1024 * 1024
    case 'gb':
      return file_size * 1024 * 1024 * 1024
    case 'tb':
      return file_size * 1024 * 1024 * 1024 * 1024
  }
  return file_size
}
$(document).on('click', '.refreshPage', function () {
  location.reload()
})
var canStore = true
if (typeof Storage !== 'undefined') {
  canStore = true
} else {
  canStore = false
}
