<?php
/*
 * --------------------------------------------------------------------
 * CUSTOM CONFIG BY PRINCE MORPHEUS
 * --------------------------------------------------------------------
 *
*/
$Localhost = array(
    'localhost',
    '127.0.0.1',
    '192.168.43.108',
    '192.168.43.1',
    '192.168.15.5',
    '192.168.15.1',
    '::1'
);


define('_ENV', in_array($_SERVER['HTTP_HOST'], $Localhost) ? 'localhost' : 'remote');
$url =  in_array($_SERVER['HTTP_HOST'], $Localhost) ? 'localhost/sukuk' : 'www.lotuscapitallimited.com/sukuk';
define('_PROTOCOL', ((isset($_SERVER['HTTPS']) && (($_SERVER['HTTPS'] == 'on') || ($_SERVER['HTTPS'] == '1'))) || getenv('SSL_PROTOCOL_VERSION')) ? 'https://' : 'http://');
define('_APIURL', _PROTOCOL . $url . '/api');
define('_MEDIAPATH', _PROTOCOL . $url . '/media');
define('_SERVER', _PROTOCOL . $url);
define('_BASEURL', $url);
define('_BASEDIR', FCPATH);
define('_VIEWDIR', _BASEDIR . '\application\views');

if (strpos($_SERVER['HTTP_HOST'], 'www') !== 0) {
    header('Location: '. _PROTOCOL . 'www.' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
			exit;
		}


define('_SUKUK_ENABLE_APPLICATION', true);
define('_SUKUK_ENABLE_PAYMENT', false);
define('_SUKUK_POST_TO_API', true);
define('_SUKUK_CONTINUE_ON_API_ERROR', false);
define('_SUKUK_ENABLE_CAPTCHA', true);
define('_SUKUK_PAYMENT_MODE', 'live'); //demo, live
define('_PAYMENT_GATEWAYS', ['paystack']); //'paystack', 'globalpay'

//GLOBALPAY API SETTINGS
$_SUKUK_GLOBALPAY_API_URL = _SUKUK_PAYMENT_MODE == 'demo' ? 'https://demo.globalpay.com.ng/globalpay_demo/Paymentgatewaycapture.aspx' : 'https://www.globalpay.com.ng/GlobalPayAPI/Paymentgatewaycapture.aspx';
$_SUKUK_GLOBALPAY_WSDL_URL = _SUKUK_PAYMENT_MODE == 'demo' ? 'https://demo.globalpay.com.ng/GlobalpayWebService_demo/service.asmx?wsdl' : 'https://www.globalpay.com.ng/globalpaywebservice/service.asmx?wsdl';
$_SUKUK_GLOBALPAY_SOAP_ACTION = _SUKUK_PAYMENT_MODE == 'demo' ? 'http://www.eazypaynigeria.com/globalpay_demo/getTransactions' : 'https://www.eazypaynigeria.com/globalpay/getTransactions';
$_SUKUK_GLOBALPAY_SOAP_NAMESPACE = _SUKUK_PAYMENT_MODE == 'demo' ? 'http://www.eazypaynigeria.com/globalpay_demo/' : 'https://www.eazypaynigeria.com/globalpay/';
$_SUKUK_MERCHANT_ID = _SUKUK_PAYMENT_MODE == 'demo' ? '17770' : '3328';
define('_SUKUK_GLOBALPAY_DEMO_MID', '17770');
define('_SUKUK_GLOBALPAY_LIVE_MID', '3328');

define('_SUKUK_GLOBALPAY_API_URL', $_SUKUK_GLOBALPAY_API_URL);
define('_SUKUK_GLOBALPAY_WSDL_URL', $_SUKUK_GLOBALPAY_WSDL_URL);
define('_SUKUK_GLOBALPAY_SOAP_ACTION', $_SUKUK_GLOBALPAY_SOAP_ACTION);
define('_SUKUK_GLOBALPAY_SOAP_NAMESPACE', $_SUKUK_GLOBALPAY_SOAP_NAMESPACE);
define('_SUKUK_GLOBALPAY_CALLBACK_URL', 'https://lotuscapitallimited.com/sukuk/index.php/payment/');
define('_SUKUK_MERCHANT_ID', $_SUKUK_MERCHANT_ID);
define('_SUKUK_WS_USERNAME', 'lo_ws_user');
define('_SUKUK_WS_PASSWORD', 'lo_ws_password');
define('_SUKUK_MAX_RETRY', 50);
define('_SUKUK_MIN_AMOUNT', 10000); // 10000
define('_SUKUK_MULTIPLE', 1000);
define('_SUKUK_EMAIL_BODY_ALIGN', 'left'); // '

define('_PAYSTACK_VERIFYURL', 'https://api.paystack.co/transaction/verify/');

/* DEMO MERCHANT KEYS*/
/*define('_PAYSTACK_DEMO_PUBLICKEY', 'pk_test_1db0bd1aeabc26334f95d276710aa3290fb48591');
define('_PAYSTACK_DEMO_SECRETKEY', 'sk_test_d0bd04a3dacda3397f12f5cd42a7ef7f06189398');*/
/*  paysatck key LBank */
define('_PAYSTACK_DEMO_PUBLICKEY', 'pk_live_2e2895cc35a1790eff6d4cf7cbee6f39b99270aa');
define('_PAYSTACK_DEMO_SECRETKEY', 'sk_live_080d32a97ddb9180e3f55798c6c0fe8b2355b592');

/* LIVE MERCHANT KEYS*/
/*define('_PAYSTACK_PUBLICKEY', 'pk_live_1525008a6a50293abad6e8f3d380b41e9a0f452e');*/
/*define('_PAYSTACK_SECRETKEY', 'sk_live_032becf8bf31ab8697ccfa577793ef73e6c4b705');*/
define('_PAYSTACK_PUBLICKEY', 'pk_live_2e2895cc35a1790eff6d4cf7cbee6f39b99270aa');
define('_PAYSTACK_SECRETKEY', 'sk_live_080d32a97ddb9180e3f55798c6c0fe8b2355b592');

define('_API_BASEURL', 'http://integration.lotuscapitallimited.com:5030/api');

//SUKUK API SETTINGS
define('_SUKUK_CUSTOMER_API_URL', _API_BASEURL . '/SukukCustomer');
define('_SUKUK_SETUP_API_URL', _API_BASEURL . '/SukukSetup');
// define('_SUKUK_TOPUP_API_URL', 'http://197.255.63.195:8089/api/Investment/postPaymentRef');
define('_SUKUK_TOPUP_API_URL', _API_BASEURL . '/Investment/postPaymentRef');
define('_SUKUK_TOPUP_APIKEY', 'apiKey: lotus_2018');
define('_SUKUK_RECAPTCHA_KEY', '6LeW0LAUAAAAAIxn43-JZYC15i5QnVxN9o8rFqTr');
define('_SUKUK_RECAPTCHA_SECRET', '6LeW0LAUAAAAAEoY0qPlQ5KGKDP-cDHgthYLVEnd');
define('_SUKUK_MAX_UPLOAD_SIZE', 2); // in MB
define('_SUKUK_RECEIVING_BANK', 'Lotus Bank Limited');

//SUKUK SETTINGS
define('_SUKUK_SUBJECT_PREFIX', 'FGN SUKUK 4 Issuance');
define('_SUKUK_APP_TITLE', 'Sovereign Sukuk Subscription Form - UP TO N250 BILLION 10-YEAR IJARAH SUKUK DUE 2031');
define('_SUKUK_COMPANY_NAME', 'Lotus Financial Services Limited');
define('_SUKUK_ADDRESS', '1B Udi Street Osborne Foreshore Estate, Osborne Road Ikoyi, Lagos Nigeria');
define('_SUKUK_CONTACT_EMAIL', 'fgnsukuk2021@lotuscapitallimited.com');
define('_SUKUK_CONTACT_TELEPHONE', '(+234)0908-705-8405, 0908-705-8406, 0807-709-9550');
define('_SUKUK_PRIVACY_POLICY', 'https://lotuscapitallimited.com/privacy-policy');
define('_SUKUK_EMAIL_SENDER', 'fgnsukuk2021@lotuscapitallimited.com');
define('_SUKUK_EMAIL_SENDER_NAME', 'Lotus Financial Services Limited');
define('_SUKUK_EMAIL_RECIPIENT', 'fgnsukuk2021@lotuscapitallimited.com,itsupport@lotuscapitallimited.com');

define("_NAME_TITLE", ['Mr.', 'Mrs.', 'Miss.', 'Msgr.', 'Dr.', 'Esq.', 'Hon.', 'Jr. ', 'Prof.', 'Alh', 'Alhaja', 'Rev.', 'Rt. Hon.', 'Sr.', 'Other']);

function SukukInstruction()
{ ?>
    <h3 class="text-center mt-4 mb-3">INSTRUCTIONS FOR COMPLETING THE APPLICATION FORM</h3>
    <ol>
        <li>Applications must be made only on the official form as prescribed by the FGN Roads Sukuk Company 1 Plc.</li>
        <li>Applications must be for a minimum of N10,000.00 and thereafter, in multiples of N1,000.00. The value of the Sukuk applied for should be entered in the appropriate box.</li>
        <li>The Application Form, when completed, should be lodged with the Financial Advisers or Placement Agents. Applications must be accompanied by full payment for the amount applied for, which must be paid to the Receiving Banks at the time of submission.</li>
        <li>Applicants should note that No Charges or Fees would be paid by investors.</li>
        <li>For the purpose of this application, residency classification refers to the country where the Applicant(s) permanently resides as at the time of filling the Application Form, Applicant(s) must indicate his/their residency classification in the appropriate box provided.</li>
        <li>For joint applications, information on the Applicants should be provided in the appropriate boxes. However, all correspondence will be addressed to the first named Applicant.</li>
        <li>An application form from a group of individuals should be made in the names of those individuals with no mention of the names of the group. </li>
        <li>An application by a firm, which is not registered under the Companies and Allied Matters Act, should be made either in the name of the proprietor or in the names of the individual partners. In neither case should the name of the firm be mentioned.</li>
        <li>An application from a corporation must bear the corporate body’s seal and be signed in accordance with the company’s signature mandate by duly authorized officials. A corporate stamp may be used where the corporate seal is not available.</li>
        <li>An application from a pension or provident fund must be in line with the guidelines of the National Pension Commission with regard to the custody of the pension assets.</li>
        <li>An application by an illiterate person should bear his right thumb print on the Subscription Form and be witnessed by an official of the Financial Adviser or Bank at which the application is lodged, who must first have explained the meaning and effect of the application to the illiterate person in his own language. The witness should indicate his name and signature in the appropriate box.</li>
        <li>The applicant should not print his signature. If he is unable to sign in the normal manner he should be treated for the purpose of this offer as an illiterate and his right thumb should be clearly impressed on the Subscription Form.</li>
      
    </ol>
<?php
    $content = ob_get_contents();
    ob_end_clean();
    return $content;
}