const { onMounted, toRef } = Vue
export default {
  template: `
  <div class="input-group width200">
            <input :id="id" type="text" :name="name" v-model="initialValue" class="date-picker form-control cursor" :class="Class" />
            <span class="input-group-text">
              <i class="fas fa-calendar"></i>
            </span>
          </div>
          `,
  props: ['id', 'name', 'class', 'modelValue'],
  emits: ['modelValue'],
  setup(props, { emit }) {
    const initialValue = toRef(props, 'modelValue')
    const Name = toRef(props, 'name')
    const Id = toRef(props, 'id')
    const Class = toRef(props, 'class')
    onMounted(() => {
      $('.date-picker#' + Id.value)
        .duDatepicker({
          auto: true,
          format: 'dd/mm/yyyy',
          clearBtn: true,
          theme: 'red'
        })
        .on('datechanged', function (e) {
          emit('update:modelValue', e.date)
        })
    })
    return {
      initialValue,
      Class
    }
  }
}
